/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class I18n {
    public static final String ASCII_CHARSET = "ISO-8859-1";
    private static Map i18nMap = new HashMap();
    private boolean initialized = false;
    private String serviceName = null;
    private String i18nFile = null;
    private ClassLoader ucl = null;
    private Map resourceBundles = new HashMap();
    private int refCount = 0;

    protected I18n(String string) {
        this.serviceName = new String(string);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.i18nFile = this.serviceName;
        this.initialized = true;
    }

    public static I18n getInstance(String string) {
        if (string == null) {
            return null;
        }
        I18n i18n = null;
        Map map = i18nMap;
        synchronized (map) {
            i18n = (I18n)i18nMap.get(string);
            if (i18n == null) {
                i18n = new I18n(string);
                i18nMap.put(string, i18n);
            }
        }
        return i18n;
    }

    public static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        return new Locale(string2, string3, string4);
    }

    public String getResBundleName() {
        this.initialize();
        return this.i18nFile;
    }

    private synchronized ResourceBundle getResourceBundle(String string) {
        ResourceBundle resourceBundle = (ResourceBundle)this.resourceBundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = this.ucl != null ? ResourceBundle.getBundle(this.i18nFile, I18n.getLocale(string), this.ucl) : ResourceBundle.getBundle(this.i18nFile, I18n.getLocale(string));
            if (this.initialized) {
                this.resourceBundles.put(string, resourceBundle);
            }
        }
        return resourceBundle;
    }

    private static String getDefaultLocale() {
        String string = "en_US";
        return string;
    }

    public String getString(String string, String string2) {
        this.initialize();
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = this.getResourceBundle(string2);
        return resourceBundle.getString(string);
    }

    public String getString(String string) {
        this.initialize();
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = this.getResourceBundle(I18n.getDefaultLocale());
        return resourceBundle.getString(string);
    }

    public String getString(String string, String string2, Object[] objectArray) {
        this.initialize();
        if (string == null) {
            return null;
        }
        return MessageFormat.format(this.getString(string, string2), objectArray);
    }

    public String getString(String string, Object[] objectArray) {
        this.initialize();
        if (string == null) {
            return null;
        }
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public static String decodeCharset(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(ASCII_CHARSET);
            return new String(byArray, 0, byArray.length, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static boolean isAscii(String string) {
        if (string == null) {
            return true;
        }
        try {
            if (!string.equals(new String(string.getBytes(ASCII_CHARSET), ASCII_CHARSET))) {
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        return true;
    }

    private static String format(MessageFormat messageFormat, Object object) {
        String string = messageFormat.format(new Object[]{object}, new StringBuffer(), (FieldPosition)null).toString();
        return string;
    }

    public static String format(String string, Long l, String string2) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(I18n.getLocale(string2));
        messageFormat.applyPattern(string);
        String string3 = I18n.format(messageFormat, l);
        return string3;
    }

    public static String format(String string, Integer n, String string2) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(I18n.getLocale(string2));
        messageFormat.applyPattern(string);
        String string3 = I18n.format(messageFormat, n);
        return string3;
    }

    public static String format(String string, Date date, TimeZone timeZone, String string2) {
        DateFormat dateFormat;
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(I18n.getLocale(string2));
        messageFormat.applyPattern(string);
        ((DateFormat)messageFormat.getFormats()[0]).setTimeZone(timeZone);
        DateFormat dateFormat2 = (DateFormat)messageFormat.getFormats()[0];
        if (dateFormat2 != null) {
            dateFormat2.setTimeZone(timeZone);
        }
        if ((dateFormat = (DateFormat)messageFormat.getFormats()[1]) != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return I18n.format(messageFormat, date);
    }
}

