/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.services.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SessionRequestParser {
    private SessionRequest sessionRequest = null;
    Document document;
    static Debug debug = Debug.getInstance("amSession");

    public SessionRequestParser(Document document) {
        this.document = document;
    }

    public SessionRequestParser(String string) {
        this.document = XMLUtils.toDOMDocument(string, debug);
    }

    public SessionRequest parseXML() {
        NodeList nodeList;
        String string;
        if (this.document == null) {
            return null;
        }
        this.sessionRequest = new SessionRequest();
        Element element = this.document.getDocumentElement();
        String string2 = element.getAttribute("vers");
        if (string2 != null) {
            this.sessionRequest.setRequestVersion(string2);
        }
        if ((string2 = element.getAttribute("reqid")) != null) {
            this.sessionRequest.setRequestID(string2);
        }
        if ((string = element.getAttribute("requester")) != null && string.length() > 0) {
            try {
                this.sessionRequest.setRequester(new String(Base64.decode(string), "UTF-8"));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal requester attribute value=" + string);
            }
        }
        if ((nodeList = element.getElementsByTagName("GetSession")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(0);
            this.parseGetSessionAttributes((Element)nodeList.item(0));
        }
        if ((nodeList = element.getElementsByTagName("GetValidSessions")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(1);
        }
        if ((nodeList = element.getElementsByTagName("DestroySession")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(2);
        }
        if ((nodeList = element.getElementsByTagName("Logout")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(3);
        }
        if ((nodeList = element.getElementsByTagName("AddSessionListener")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(4);
        }
        if ((nodeList = element.getElementsByTagName("AddSessionListenerOnAllSessions")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(5);
        }
        if ((nodeList = element.getElementsByTagName("SetProperty")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(6);
        }
        if ((nodeList = element.getElementsByTagName("SessionID")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setSessionID(SessionRequestParser.parseCDATA((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("DestroySessionID")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setDestroySessionID(SessionRequestParser.parseCDATA((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("URL")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setNotificationURL(SessionRequestParser.parseCDATA((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("Property")) != null && nodeList.getLength() != 0) {
            this.parsePropertyAttributes((Element)nodeList.item(0));
        }
        if ((nodeList = element.getElementsByTagName("Pattern")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setPattern(SessionRequestParser.parseCDATA((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("GetSessionCount")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setMethodID(7);
        }
        if ((nodeList = element.getElementsByTagName("UUID")) != null && nodeList.getLength() != 0) {
            this.sessionRequest.setUUID(SessionRequestParser.parseCDATA((Element)nodeList.item(0)));
        }
        return this.sessionRequest;
    }

    private void parsePropertyAttributes(Element element) {
        if (element == null) {
            return;
        }
        String string = element.getAttribute("name");
        if (string != null) {
            this.sessionRequest.setPropertyName(string);
        }
        if ((string = element.getAttribute("value")) != null) {
            this.sessionRequest.setPropertyValue(string);
        }
    }

    static String parseCDATA(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private void parseGetSessionAttributes(Element element) {
        if (element == null) {
            return;
        }
        String string = element.getAttribute("reset");
        if (string != null) {
            if (string.equals("true")) {
                this.sessionRequest.setResetFlag(true);
            } else {
                this.sessionRequest.setResetFlag(false);
            }
        }
    }
}

