/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.util.CookieUtils;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.session.util.SessionUtils;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionRequestHandler
implements RequestHandler {
    private static final String sccsID = "@(#)SessionRequestHandler.java\t1.8  00/03/28 03/28/00  Sun Microsystems, Inc.";
    private SessionService sessionService = SessionService.getSessionService();
    private static Map sessionServiceURLTable = new HashMap();
    private static Boolean enableAddListenerOnAllSessions = null;

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        ResponseSet responseSet = new ResponseSet("session");
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request, httpServletRequest, httpServletResponse);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = request.getContent();
        SessionRequest sessionRequest = SessionRequest.parseXML(string);
        SessionResponse sessionResponse = new SessionResponse(sessionRequest.getRequestID(), sessionRequest.getMethodID());
        try {
            Object object;
            InetAddress inetAddress = InetAddress.getByName(httpServletRequest.getRemoteAddr());
            Object object2 = SessionUtils.getClientAddress(httpServletRequest);
            if (SessionUtils.isTrustedSource(inetAddress) && (object = sessionRequest.getRequester()) != null) {
                object2 = RestrictedTokenContext.unmarshal((String)object);
            }
            object = httpServletRequest;
            HttpServletResponse httpServletResponse2 = httpServletResponse;
            final SessionRequest sessionRequest2 = sessionRequest;
            sessionResponse = (SessionResponse)RestrictedTokenContext.doUsing(object2, new RestrictedTokenAction((HttpServletRequest)object, httpServletResponse2){
                private final /* synthetic */ HttpServletRequest val$httpReq;
                private final /* synthetic */ HttpServletResponse val$httpResp;
                {
                    this.val$httpReq = httpServletRequest;
                    this.val$httpResp = httpServletResponse;
                }

                public Object run() throws Exception {
                    return SessionRequestHandler.this.processSessionRequest(sessionRequest2, this.val$httpReq, this.val$httpResp);
                }
            });
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("SessionRequestHandler encounterd exception", exception);
            sessionResponse.setException(exception.getMessage());
        }
        return new Response(sessionResponse.toXMLString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SessionResponse processSessionRequest(SessionRequest sessionRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SessionResponse sessionResponse = new SessionResponse(sessionRequest.getRequestID(), sessionRequest.getMethodID());
        SessionID sessionID = new SessionID(sessionRequest.getSessionID());
        Session session = null;
        try {
            Object object;
            Object object2;
            Object object3;
            switch (sessionRequest.getMethodID()) {
                case 1: 
                case 5: 
                case 7: {
                    session = Session.getSession(sessionID);
                    if (session.getProperty("TokenRestriction") == null) break;
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("noPrivilege"));
                    return sessionResponse;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    if (sessionRequest.getMethodID() == 2) {
                        session = Session.getSession(sessionID);
                        if (session.getProperty("TokenRestriction") != null) {
                            sessionResponse.setException(sessionID + " " + SessionBundle.getString("noPrivilege"));
                            return sessionResponse;
                        }
                        sessionID = new SessionID(sessionRequest.getDestroySessionID());
                    }
                    if (!this.sessionService.isSessionFailoverEnabled()) {
                        object3 = Session.getSessionServiceURL(sessionID);
                        if (this.sessionService.isLocalSessionService((URL)object3)) break;
                        return this.forward((URL)object3, sessionRequest);
                    }
                    if (SessionService.getUseInternalRequestRouting()) {
                        object3 = this.sessionService.getCurrentHostServer(sessionID);
                        if (!this.sessionService.isLocalServer((String)object3)) {
                            try {
                                return this.forward(Session.getSessionServiceURL((String)object3), sessionRequest);
                            }
                            catch (SessionException sessionException) {
                                if (this.sessionService.checkServerUp((String)object3)) throw sessionException;
                                object2 = this.sessionService.getCurrentHostServer(sessionID);
                                if (((String)object2).equals(object3)) {
                                    throw sessionException;
                                }
                                if (!this.sessionService.isLocalServer((String)object2)) {
                                    return this.forward(Session.getSessionServiceURL((String)object2), sessionRequest);
                                }
                            }
                        }
                    } else {
                        object3 = CookieUtils.getCookieValueFromReq(httpServletRequest, Session.getCookieName());
                        object = CookieUtils.getCookieValueFromReq(httpServletRequest, SessionService.getHttpSessionTrackingCookieName());
                        if (!(this.sessionService.isSessionPresent(sessionID) || object3 != null && ((String)object3).equals(sessionID.toString()) && object != null && ((String)object).equals(sessionID.getTail()))) {
                            return this.forward(Session.getSessionServiceURL(sessionID), sessionRequest);
                        }
                    }
                    if (this.sessionService.isSessionPresent(sessionID) || this.sessionService.recoverSession(sessionID) != null) break;
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("sessionNotObtained"));
                    return sessionResponse;
                }
                default: {
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("unknownRequestMethod"));
                    return sessionResponse;
                }
            }
            switch (sessionRequest.getMethodID()) {
                case 0: {
                    sessionResponse.addSessionInfo(this.sessionService.getSessionInfo(sessionID, sessionRequest.getResetFlag()));
                    return sessionResponse;
                }
                case 1: {
                    object3 = sessionRequest.getPattern();
                    object = null;
                    object2 = new int[]{0};
                    object = this.sessionService.getValidSessions(session, (String)object3, (int[])object2);
                    sessionResponse.setStatus(object2[0]);
                    sessionResponse.setSessionInfoVector((Vector)object);
                    return sessionResponse;
                }
                case 2: {
                    this.sessionService.destroySession(session, new SessionID(sessionRequest.getDestroySessionID()));
                    return sessionResponse;
                }
                case 3: {
                    this.sessionService.logout(sessionID);
                    return sessionResponse;
                }
                case 4: {
                    this.sessionService.addSessionListener(sessionID, sessionRequest.getNotificationURL());
                    return sessionResponse;
                }
                case 5: {
                    if (!SessionRequestHandler.getEnableAddListenerOnAllSessions()) return sessionResponse;
                    this.sessionService.addSessionListenerOnAllSessions(session, sessionRequest.getNotificationURL());
                    return sessionResponse;
                }
                case 6: {
                    this.sessionService.setExternalProperty(sessionID, sessionRequest.getPropertyName(), sessionRequest.getPropertyValue());
                    return sessionResponse;
                }
                case 7: {
                    String string = sessionRequest.getUUID();
                    Map map = SessionCount.getSessionsFromLocalServer(string);
                    if (map == null) return sessionResponse;
                    sessionResponse.setSessionsForGivenUUID(map);
                    return sessionResponse;
                }
                default: {
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("unknownRequestMethod"));
                    return sessionResponse;
                }
            }
        }
        catch (SessionException sessionException) {
            sessionResponse.setException(sessionID + " " + sessionException.getMessage());
        }
        return sessionResponse;
    }

    private SessionResponse forward(URL uRL, SessionRequest sessionRequest) throws SessionException {
        try {
            SessionResponse sessionResponse;
            Object object = RestrictedTokenContext.getCurrent();
            if (object != null) {
                sessionRequest.setRequester(RestrictedTokenContext.marshal(object));
            }
            if ((sessionResponse = Session.sendPLLRequest(uRL, sessionRequest)).getException() != null) {
                throw new SessionException(sessionResponse.getException());
            }
            return sessionResponse;
        }
        catch (SessionException sessionException) {
            throw sessionException;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    private static boolean getEnableAddListenerOnAllSessions() {
        if (enableAddListenerOnAllSessions == null) {
            enableAddListenerOnAllSessions = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableAddListenerOnAllSessions"));
        }
        return enableAddListenerOnAllSessions;
    }
}

