/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.QuotaExhaustionAction;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionConstraint {
    public static final int DESTROY_OLD_SESSION = 1;
    public static final int DENY_ACCESS = 2;
    private static final int DEFAULT_QUOTA = Integer.MAX_VALUE;
    private static final String AM_SESSION_SERVICE = "iPlanetAMSessionService";
    private static final String SESSION_QUOTA_ATTR_NAME = "iplanet-am-session-quota-limit";
    private static Debug debug = SessionService.sessionDebug;
    private static QuotaExhaustionAction quotaExhaustionAction = null;

    static SessionService getSS() {
        return SessionCount.getSS();
    }

    protected static boolean checkQuotaAndPerformAction(InternalSession internalSession) {
        boolean bl = false;
        int n = -1;
        if (SessionCount.getDeploymentMode() == 2) {
            return false;
        }
        if (internalSession.getIsSessionUpgrade()) {
            SessionCount.incrementSessionCount(internalSession);
            return false;
        }
        int n2 = SessionConstraint.getSessionQuota(internalSession);
        try {
            Map map = SessionCount.getAllSessionsByUUID(internalSession.getUUID());
            if (map != null) {
                n = map.size();
            }
            if (n >= n2) {
                bl = quotaExhaustionAction.action(internalSession, map);
                if (debug.messageEnabled()) {
                    debug.message("Session quota exhausted or  session repository is not available.");
                }
            } else {
                SessionCount.incrementSessionCount(internalSession);
            }
        }
        catch (Exception exception) {
            debug.error("Exception in checkQuotaAndPerformAction", exception);
            bl = true;
        }
        return bl;
    }

    private static int getSessionQuota(InternalSession internalSession) {
        int n;
        block3: {
            n = SessionConstraint.getDefaultSessionQuota();
            try {
                AMIdentity aMIdentity = IdUtils.getIdentity((SSOToken)SessionCount.getAdminToken(), (String)internalSession.getUUID());
                Map map = aMIdentity.getServiceAttributes(AM_SESSION_SERVICE);
                Set set = (Set)map.get(SESSION_QUOTA_ATTR_NAME);
                Iterator iterator = set.iterator();
                if (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    n = Integer.valueOf(string);
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Failed to get the session quota via the IDRepo interfaces, => Use the default value from the dynamic schema instead.", exception);
            }
        }
        return n;
    }

    private static int getDefaultSessionQuota() {
        int n;
        block2: {
            n = Integer.MAX_VALUE;
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(AM_SESSION_SERVICE, SessionCount.getAdminToken());
                ServiceSchema serviceSchema = serviceSchemaManager.getDynamicSchema();
                Map map = serviceSchema.getAttributeDefaults();
                n = Misc.getIntMapAttr(map, SESSION_QUOTA_ATTR_NAME, String.valueOf(Integer.MAX_VALUE), debug);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Failed to get the default session quota setting. => Set user session quota to Integer.MAX_VALUE.", exception);
            }
        }
        return n;
    }

    static {
        SessionConstraint.getSS();
        quotaExhaustionAction = SessionService.getConstraintResultingBehavior() == 2 ? new DenyAccessAction() : new DestroyNextExpiringSessionAction();
    }

    private static class DestroyNextExpiringSessionAction
    implements QuotaExhaustionAction {
        private DestroyNextExpiringSessionAction() {
        }

        public boolean action(InternalSession internalSession, Map map) {
            Object object;
            Object object2;
            Object object3 = null;
            long l = Long.MAX_VALUE;
            Set set = map.keySet();
            Map map2 = map;
            synchronized (map2) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    long l2 = (Long)map.get(object);
                    if (l2 >= l) continue;
                    l = l2;
                    object3 = object;
                }
            }
            if (object3 != null) {
                object2 = new SessionID((String)object3);
                try {
                    object = Session.getSession((SessionID)object2);
                    ((Session)object).destroySession((Session)object);
                }
                catch (SessionException sessionException) {
                    if (debug.messageEnabled()) {
                        debug.message("Failed to destroy the next expiring session.", sessionException);
                    }
                    return true;
                }
            }
            SessionCount.incrementSessionCount(internalSession);
            return false;
        }
    }

    private static class DenyAccessAction
    implements QuotaExhaustionAction {
        private DenyAccessAction() {
        }

        public boolean action(InternalSession internalSession, Map map) {
            return true;
        }
    }
}

