/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;

public class SessionConfigListener
implements ServiceListener {
    private static String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String SESSION_RETRIEVAL_TIMEOUT = "iplanet-am-session-session-list-retrieval-timeout";
    private static final String MAX_SESSION_LIST_SIZE = "iplanet-am-session-max-session-list-size";
    private static long defSessionRetrievalTimeout;
    private static int defMaxSessionListSize;
    private static Debug debug;
    private static ServiceSchemaManager sSchemaMgr;
    public static long defSessionRetrievalTimeoutLong;
    public static int defMaxSessionListSizeInt;
    public static String defSessionRetrievalTimeoutStr;
    public static String defMaxSessionListSizeStr;
    private static String enablePropertyNotificationStr;

    public SessionConfigListener(ServiceSchemaManager serviceSchemaManager) {
        sSchemaMgr = serviceSchemaManager;
    }

    public void schemaChanged(String string, String string2) {
        if (string != null && !string.equalsIgnoreCase(SESSION_SERVICE_NAME)) {
            return;
        }
        try {
            ServiceSchema serviceSchema = sSchemaMgr.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            defSessionRetrievalTimeoutStr = Misc.getMapAttr(map, SESSION_RETRIEVAL_TIMEOUT, defSessionRetrievalTimeoutStr);
            defMaxSessionListSizeStr = Misc.getMapAttr(map, MAX_SESSION_LIST_SIZE, defMaxSessionListSizeStr);
            enablePropertyNotificationStr = Misc.getMapAttr(map, "iplanet-am-session-property-change-notification", "OFF");
            if (enablePropertyNotificationStr.equalsIgnoreCase("ON")) {
                SessionService.setPropertyNotificationEnabled(true);
                Set set = (Set)map.get("iplanet-am-session-notification-property-list");
                SessionService.setNotificationProperties(set);
            } else {
                SessionService.setPropertyNotificationEnabled(false);
            }
        }
        catch (Exception exception) {
            debug.error("SessionConfigListener : Unable to get Timeout & ListSize values", exception);
        }
        try {
            defSessionRetrievalTimeout = Long.parseLong(defSessionRetrievalTimeoutStr) * 1000L;
        }
        catch (Exception exception) {
            defSessionRetrievalTimeout = defSessionRetrievalTimeoutLong * 1000L;
            debug.error("SessionConfigListener : Unable to parse Timeout values", exception);
        }
        try {
            defMaxSessionListSize = Integer.parseInt(defMaxSessionListSizeStr);
        }
        catch (Exception exception) {
            defMaxSessionListSize = defMaxSessionListSizeInt;
            debug.error("SessionConfigListener : Unable to parse ListSize values", exception);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    public static long getTimeout() {
        return defSessionRetrievalTimeout;
    }

    public static int getMaxsize() {
        return defMaxSessionListSize;
    }

    static {
        debug = Debug.getInstance("amSession");
        sSchemaMgr = null;
        defSessionRetrievalTimeoutLong = 5L;
        defMaxSessionListSizeInt = 200;
        defSessionRetrievalTimeoutStr = Long.toString(defSessionRetrievalTimeoutLong);
        defMaxSessionListSizeStr = Integer.toString(defMaxSessionListSizeInt);
        enablePropertyNotificationStr = "OFF";
    }
}

