/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClusterStateService
implements Runnable {
    private Map servers = new HashMap();
    private ServerInfo[] serverSelectionList = new ServerInfo[0];
    private int lastSelected = -1;
    public static final int DEFAULT_TIMEOUT = 1000;
    private int timeout = 1000;
    public static final long DEFAULT_PERIOD = 1000L;
    private long period = 1000L;
    private String localServerId = null;
    private Thread checker;

    public ClusterStateService(String string, int n, long l, Map map) throws Exception {
        this.localServerId = string;
        this.timeout = n;
        this.period = l;
        this.serverSelectionList = new ServerInfo[map.size()];
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            ServerInfo serverInfo = new ServerInfo();
            Map.Entry entry = iterator.next();
            serverInfo.id = (String)entry.getKey();
            URL uRL = new URL((String)entry.getValue());
            serverInfo.address = new InetSocketAddress(uRL.getHost(), uRL.getPort());
            serverInfo.isUp = this.checkServerUp(serverInfo);
            this.servers.put(serverInfo.id, serverInfo);
            this.serverSelectionList[this.getNextSelected()] = serverInfo;
        }
        Arrays.sort(this.serverSelectionList);
        this.checker = new Thread(this);
        this.checker.setName("ClusterStateService");
        this.checker.setDaemon(true);
        this.checker.start();
    }

    private int getNextSelected() {
        this.lastSelected = (this.lastSelected + 1) % this.serverSelectionList.length;
        return this.lastSelected;
    }

    boolean isUp(String string) {
        return ((ServerInfo)this.servers.get((Object)string)).isUp;
    }

    boolean checkServerUp(String string) {
        ServerInfo serverInfo = (ServerInfo)this.servers.get(string);
        serverInfo.isUp = this.checkServerUp(serverInfo);
        return serverInfo.isUp;
    }

    int getServerSelectionListSize() {
        return this.serverSelectionList.length;
    }

    String getServerSelection(int n) {
        return this.serverSelectionList[n].id;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    long l = System.currentTimeMillis() + this.period;
                    Iterator iterator = this.servers.values().iterator();
                    while (iterator.hasNext()) {
                        ServerInfo serverInfo = (ServerInfo)iterator.next();
                        serverInfo.isUp = this.checkServerUp(serverInfo);
                    }
                    long l2 = l - System.currentTimeMillis();
                    if (l2 <= 0L) continue;
                    Thread.sleep(l2);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServerUp(ServerInfo serverInfo) {
        if (this.localServerId.equals(serverInfo.id)) {
            return true;
        }
        boolean bl = false;
        Socket socket = new Socket();
        try {
            socket.connect(serverInfo.address, this.timeout);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private class ServerInfo
    implements Comparable {
        String id;
        InetSocketAddress address;
        boolean isUp;

        private ServerInfo() {
        }

        public int compareTo(Object object) {
            return this.id.compareTo(((ServerInfo)object).id);
        }
    }
}

