/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.jdbc.JDBCConnectionPool;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.session.util.SessionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class JDBCSessionRepository
implements Runnable,
AMSessionRepository {
    private static DataSource dataSource = null;
    private static final String table = "sunwam_session";
    private static final String table_ext = "sunwam_session_ext";
    private static final String INSERT_SQL_STMT = "insert into sunwam_session(id,blob_chunk,blob_size,expiration_time,uuid,sessionstate,version) values(?,?,?,?,?,?,?)";
    private static final String UPDATE_SQL_STMT = "update sunwam_session set blob_chunk = ?, blob_size = ? , expiration_time = ? , uuid = ?, sessionstate = ?, version = ?  where id = ? and version = ?";
    private static final String GET_SESSION_COUNT_SQL_STMT = "select * from sunwam_session where uuid = ? and expiration_time > ? and sessionstate = 1";
    private static final String connectionPoolName = SystemProperties.get("com.sun.identity.session.failover.connectionPoolClass", "com.iplanet.dpro.session.jdbc.JDBCConnectionPool");
    private static int BLOB_CHUNK_SIZE = 7800;
    private static boolean isDatabaseUp = true;
    private static long gracePeriod = 300L;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static final String BRIEF_DB_ERROR_MSG = "Session failover service is not functional due to DB unavailability.";
    private static final String DB_ERROR_MSG = "Session database is not available at this moment.Please check with the system administrator for appropriate actions";
    private static long cleanUpPeriod = 60000L;
    private static long cleanUpValue = 0L;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.session.repository.cleanupRunPeriod";
    private static long healthCheckPeriod = 60000L;
    public static final String HEALTH_CHECK_RUN_PERIOD = "com.sun.identity.session.repository.healthCheckRunPeriod";
    private static long runPeriod = 60000L;
    private Thread checker;
    static Debug debug = SessionService.sessionDebug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        if (dataSource == null) {
            dataSource = (DataSource)Class.forName(connectionPoolName).newInstance();
        }
        Connection connection = null;
        try {
            if (!isDatabaseUp) {
                JDBCSessionRepository jDBCSessionRepository = this;
                synchronized (jDBCSessionRepository) {
                    if (!isDatabaseUp) {
                        ((JDBCConnectionPool)dataSource).reinitializePoolDataSource();
                        isDatabaseUp = true;
                    }
                }
            }
            connection = dataSource.getConnection();
        }
        catch (Exception exception) {
            isDatabaseUp = false;
            debug.error(BRIEF_DB_ERROR_MSG, exception);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, exception);
            }
            throw exception;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JDBCSessionRepository() throws Exception {
        block20: {
            ResultSet resultSet;
            Connection connection;
            block18: {
                connection = null;
                resultSet = null;
                connection = this.getConnection();
                resultSet = connection.getMetaData().getTables(null, null, table, new String[]{"TABLE"});
                boolean bl = resultSet.next();
                resultSet.close();
                resultSet = null;
                if (bl) break block18;
                debug.message("DataBase table does not exist");
            }
            Object var5_5 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block20;
            }
            catch (Exception exception) {}
            break block20;
            {
                catch (Exception exception) {
                    debug.error("JDBCSessionRepository Initialization failed.");
                    Object var5_6 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block20;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.checker = new Thread(this);
        this.checker.setName("JDBCSessionRepositoryChecker");
        this.checker.setDaemon(true);
        this.checker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public InternalSession retrieve(SessionID sessionID) throws Exception {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block36: {
            if (!isDatabaseUp) {
                return null;
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("select * from sunwam_session where id = ?");
            preparedStatement.setString(1, SessionUtils.getEncryptedStorageKey(sessionID));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block36;
            InternalSession internalSession = null;
            Object var13_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return internalSession;
        }
        byte[] byArray = resultSet.getBytes("blob_chunk");
        int n = resultSet.getInt("blob_size");
        long l = resultSet.getLong("version");
        byte[] byArray2 = byArray;
        if (n != 0 && n > byArray.length) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.retrieveBlobRemainder(connection, sessionID, byArray2);
        }
        InternalSession internalSession = (InternalSession)SessionUtils.decode(byArray2);
        internalSession.setVersion(l);
        connection.commit();
        InternalSession internalSession2 = internalSession;
        Object var13_9 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return internalSession2;
        catch (Exception exception) {
            InternalSession internalSession3;
            try {
                try {
                    connection.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                internalSession3 = null;
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {}
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
            return internalSession3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(InternalSession internalSession) throws Exception {
        block37: {
            if (!isDatabaseUp) {
                return;
            }
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            connection = this.getConnection();
            InternalSession internalSession2 = internalSession;
            synchronized (internalSession2) {
                SessionID sessionID = internalSession.getID();
                byte[] byArray = SessionUtils.encode(internalSession);
                long l = internalSession.getVersion();
                long l2 = internalSession.getExpirationTime() + gracePeriod;
                byte[] byArray2 = byArray;
                if (byArray.length > BLOB_CHUNK_SIZE) {
                    byArray2 = new byte[BLOB_CHUNK_SIZE];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                }
                String string = SessionUtils.getEncryptedStorageKey(sessionID);
                String string2 = internalSession.getUUID();
                int n = internalSession.getState();
                if (l == 0L) {
                    this.insertNewSessionEntry(connection, string, byArray2, byArray.length, l2, string2, n, l);
                } else {
                    statement = connection.prepareStatement(UPDATE_SQL_STMT);
                    statement.setBytes(1, byArray2);
                    statement.setInt(2, byArray.length);
                    statement.setLong(3, l2);
                    statement.setString(4, string2);
                    statement.setInt(5, n);
                    statement.setLong(6, l + 1L);
                    statement.setString(7, string);
                    statement.setLong(8, l);
                    int n2 = statement.executeUpdate();
                    if (n2 == 0) {
                        this.insertNewSessionEntry(connection, string, byArray2, byArray.length, l2, string2, n, l);
                    }
                }
                this.saveBlobRemainder(connection, sessionID, byArray, l2);
                connection.commit();
                internalSession.setVersion(l + 1L);
            }
            Object var19_18 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block37;
            }
            catch (Exception exception) {}
            break block37;
            {
                catch (Exception exception) {
                    debug.error("Exception thrown when saving the session into the JDBC repository.", exception);
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {
                    }
                    Object var19_19 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block37;
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewSessionEntry(Connection connection, String string, byte[] byArray, int n, long l, String string2, int n2, long l2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(INSERT_SQL_STMT);
            preparedStatement.setString(1, string);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.setInt(3, n);
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, string2);
            preparedStatement.setInt(6, n2);
            preparedStatement.setLong(7, l2 + 1L);
            preparedStatement.executeUpdate();
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void delete(SessionID sessionID) throws Exception {
        block22: {
            if (!isDatabaseUp) {
                return;
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            Object var4_4 = null;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("delete from sunwam_session where id = ?");
            preparedStatement.setString(1, SessionUtils.getEncryptedStorageKey(sessionID));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            preparedStatement = connection.prepareStatement("delete from sunwam_session_ext where id = ?");
            preparedStatement.setString(1, SessionUtils.getEncryptedStorageKey(sessionID));
            preparedStatement.executeUpdate();
            connection.commit();
            Object var8_5 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block22;
            }
            catch (Exception exception) {}
            break block22;
            {
                catch (Exception exception) {
                    debug.error("Exception thrown when deleting the session from the JDBC repository.", exception);
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {
                    }
                    Object var8_6 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteExpired() throws Exception {
        block22: {
            if (!isDatabaseUp) {
                return;
            }
            Connection connection = null;
            Statement statement = null;
            Object var3_3 = null;
            connection = this.getConnection();
            long l = System.currentTimeMillis() / 1000L;
            statement = connection.prepareStatement("delete from sunwam_session where expiration_time < ?");
            statement.setLong(1, l);
            statement.executeUpdate();
            statement.close();
            statement = null;
            statement = connection.prepareStatement("delete from sunwam_session_ext where expiration_time < ?");
            statement.setLong(1, l);
            statement.executeUpdate();
            connection.commit();
            Object var7_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block22;
            }
            catch (Exception exception) {}
            break block22;
            {
                catch (Exception exception) {
                    debug.error("Exception thrown when cleanning up the session from the JDBC repository.", exception);
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {
                    }
                    Object var7_7 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveBlobRemainder(Connection connection, SessionID sessionID, byte[] byArray, long l) throws Exception {
        Statement statement = null;
        try {
            int n;
            int n2 = 1;
            statement = connection.prepareStatement("delete from sunwam_session_ext where id = ?");
            statement.setString(1, SessionUtils.getEncryptedStorageKey(sessionID));
            statement.executeUpdate();
            statement.close();
            statement = null;
            if (n > 0) {
                byte[] byArray2 = new byte[BLOB_CHUNK_SIZE];
                statement = connection.prepareStatement("insert into sunwam_session_ext(id,blob_chunk,blob_chunk_seq,expiration_time)  values(?,?,?,?)");
                for (n = byArray.length - BLOB_CHUNK_SIZE; n > 0; n -= BLOB_CHUNK_SIZE) {
                    int n3 = Math.min(n, BLOB_CHUNK_SIZE);
                    System.arraycopy(byArray, n2 * BLOB_CHUNK_SIZE, byArray2, 0, n3);
                    statement.setString(1, SessionUtils.getEncryptedStorageKey(sessionID));
                    statement.setBytes(2, byArray2);
                    statement.setInt(3, n2);
                    statement.setLong(4, l);
                    statement.executeUpdate();
                    ++n2;
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {}
    }

    void retrieveBlobRemainder(Connection connection, SessionID sessionID, byte[] byArray) throws Exception {
        String string = SessionUtils.getEncryptedStorageKey(sessionID);
        this.retrieveBlobRemainder(connection, string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void retrieveBlobRemainder(Connection connection, String string, byte[] byArray) throws Exception {
        block21: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block19: {
                preparedStatement = null;
                resultSet = null;
                int n = byArray.length - BLOB_CHUNK_SIZE;
                if (n > 0) break block22;
                Object var11_7 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    block22: {
                        return;
                    }
                    preparedStatement = connection.prepareStatement("select blob_chunk, blob_chunk_seq from sunwam_session_ext where id = ?");
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        byte[] byArray2 = resultSet.getBytes("blob_chunk");
                        int n2 = resultSet.getInt("blob_chunk_seq");
                        if (byArray2.length == 0 || byArray2.length > BLOB_CHUNK_SIZE || n2 < 1 || n2 * BLOB_CHUNK_SIZE > byArray.length) {
                            throw new IllegalArgumentException("Invalid chunk");
                        }
                        int n3 = Math.min(byArray2.length, byArray.length - n2 * BLOB_CHUNK_SIZE);
                        System.arraycopy(byArray2, 0, byArray, n2 * BLOB_CHUNK_SIZE, n3);
                        n -= n3;
                    }
                    if (n == 0) break block19;
                    throw new IllegalArgumentException("Missing chunks");
                }
            }
            Object var11_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block21;
            }
            catch (Exception exception) {}
            break block21;
            catch (Throwable throwable) {
                Object var11_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Map getSessionsByUUID(String string) throws Exception {
        HashMap<String, Long> hashMap;
        block26: {
            if (!isDatabaseUp) {
                throw new SessionException("Session repository is not available.");
            }
            hashMap = new HashMap<String, Long>();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(GET_SESSION_COUNT_SQL_STMT);
            preparedStatement.setString(1, string);
            long l = System.currentTimeMillis() / 1000L;
            preparedStatement.setLong(2, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("id");
                byte[] byArray = resultSet.getBytes("blob_chunk");
                int n = resultSet.getInt("blob_size");
                byte[] byArray2 = byArray;
                if (n != 0 && n > byArray.length) {
                    byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    this.retrieveBlobRemainder(connection, string2, byArray2);
                }
                InternalSession internalSession = (InternalSession)SessionUtils.decode(byArray2);
                String string3 = internalSession.getID().toString();
                Long l2 = new Long(internalSession.getExpirationTime());
                hashMap.put(string3, l2);
            }
            connection.commit();
            Object var16_15 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block26;
            }
            catch (Exception exception) {}
            break block26;
            {
                catch (Exception exception) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw new SessionException("Error occurs when executing the GET_SESSION_COUNT query");
                }
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    long l;
                    long l2 = System.currentTimeMillis() + runPeriod;
                    if (debug.messageEnabled()) {
                        debug.message("Cleaning expired session records");
                    }
                    if (cleanUpValue <= 0L) {
                        this.deleteExpired();
                        cleanUpValue = cleanUpPeriod;
                    }
                    cleanUpValue -= runPeriod;
                    if (!isDatabaseUp) {
                        this.checkDatabaseAvailability();
                    }
                    if ((l = l2 - System.currentTimeMillis()) <= 0L) continue;
                    Thread.sleep(l);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkDatabaseAvailability() {
        block11: {
            Connection connection = null;
            connection = this.getConnection();
            Object var4_2 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    Object var4_3 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static {
        try {
            gracePeriod = Integer.parseInt(SystemProperties.get(CLEANUP_GRACE_PERIOD, String.valueOf(gracePeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        try {
            cleanUpPeriod = Integer.parseInt(SystemProperties.get(CLEANUP_RUN_PERIOD, String.valueOf(cleanUpPeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupRunPeriod, using default");
        }
        try {
            healthCheckPeriod = Integer.parseInt(SystemProperties.get(HEALTH_CHECK_RUN_PERIOD, String.valueOf(healthCheckPeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.healthCheckRunPeriod, using default");
        }
        runPeriod = cleanUpPeriod <= healthCheckPeriod ? cleanUpPeriod : healthCheckPeriod;
        cleanUpValue = cleanUpPeriod;
    }
}

