/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.jdbc.JDBCConnectionImpl;
import com.iplanet.dpro.session.service.SessionService;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class JDBCConnectionPool
implements DataSource,
ConnectionEventListener {
    private int maxPoolSize;
    private int steadyPoolSize;
    private int maxWaitTime;
    private boolean requireConnectionValidation = false;
    private boolean failAllConnections = false;
    private int isolationLevel;
    private static boolean isIsolationSet = false;
    private PrintWriter logWriter;
    private int loginTimeout;
    private long idletime;
    private boolean poolInitialized = false;
    private Map connectionStates;
    private Map free;
    private ConnectionPoolDataSource poolDS;
    private JDBCConnectionImpl jdbcProvider;
    Debug debug = SessionService.sessionDebug;

    public JDBCConnectionPool() throws Exception {
        this.setMaxPoolSize(SessionService.getMaxPoolSize());
        this.setSteadyPoolSize(SessionService.getMinPoolSize());
        this.setMaxWaitTime(SessionService.getConnectionMaxWaitTime());
        String string = SessionService.getJdbcDriverClass();
        this.jdbcProvider = (JDBCConnectionImpl)Class.forName(string).newInstance();
        this.jdbcProvider.init(SessionService.getJdbcURL(), SessionService.getSessionStoreUserName(), SessionService.getSessionStorePassword());
        this.poolDS = this.jdbcProvider.getConnectionPoolDataSource();
    }

    private synchronized void initPool() throws SQLException {
        if (this.poolInitialized) {
            return;
        }
        this.connectionStates = new HashMap(this.getSteadyPoolSize());
        this.free = new HashMap(this.getSteadyPoolSize());
        this.createSteadyConnections();
        this.poolInitialized = true;
    }

    private static boolean isValid(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (this.getMaxWaitTime() > 0) {
            l = System.currentTimeMillis();
        }
        while ((connection = this.internalGetConnection()) == null) {
            if (this.getMaxWaitTime() > 0) {
                l2 = System.currentTimeMillis() - l;
                if (l2 < (long)this.getMaxWaitTime()) {
                    l3 = (long)this.getMaxWaitTime() - l2;
                } else {
                    throw new SQLException("No available connection. Wait-time expired.");
                }
            }
            JDBCConnectionPool jDBCConnectionPool = this;
            synchronized (jDBCConnectionPool) {
                block10: {
                    try {
                        if (this.free.size() != 0) break block10;
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        }
        return connection;
    }

    private synchronized Connection internalGetConnection() throws SQLException {
        Object object;
        this.initPool();
        Connection connection = null;
        PooledConnection pooledConnection = null;
        ConnectionState connectionState = null;
        Iterator iterator = this.free.entrySet().iterator();
        if (iterator.hasNext()) {
            object = iterator.next();
            pooledConnection = (PooledConnection)object.getKey();
            connectionState = (ConnectionState)object.getValue();
            connectionState.setBusy(true);
            this.free.remove(pooledConnection);
        }
        if (pooledConnection != null) {
            connection = pooledConnection.getConnection();
            if (this.isRequireConnectionValidation()) {
                boolean bl = false;
                try {
                    bl = JDBCConnectionPool.isValid(connection);
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) {
                    if (this.failAllConnections) {
                        connection = this.failAllConnections();
                    } else {
                        this.connectionStates.remove(pooledConnection);
                        this.destroyConnection(pooledConnection);
                        connection = null;
                    }
                }
            }
        }
        if (connection == null && this.connectionStates.size() < this.getMaxPoolSize()) {
            pooledConnection = this.createConnection(true);
            connection = pooledConnection.getConnection();
        }
        if (connection != null) {
            if (!isIsolationSet) {
                object = connection.getMetaData();
                if (object.supportsTransactionIsolationLevel(4)) {
                    this.setIsolationLevel(4);
                    SessionService.sessionDebug.message("JDBCConnectionPool IsolationLevel set to TRANSACTION_REPEATABLE_READ");
                } else {
                    this.setIsolationLevel(2);
                    SessionService.sessionDebug.message("JDBCConnectionPool IsolationLevel set to TRANSACTION_READ_COMMITTED");
                }
                isIsolationSet = true;
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(this.isolationLevel);
        }
        return connection;
    }

    private PooledConnection createConnection(boolean bl) throws SQLException {
        PooledConnection pooledConnection = this.poolDS.getPooledConnection();
        ConnectionState connectionState = new ConnectionState();
        connectionState.setBusy(bl);
        pooledConnection.addConnectionEventListener(this);
        this.connectionStates.put(pooledConnection, connectionState);
        if (!bl) {
            this.free.put(pooledConnection, connectionState);
            this.notifyAll();
        }
        return pooledConnection;
    }

    private Connection failAllConnections() throws SQLException {
        Connection connection = null;
        this.emptyPool();
        this.createSteadyConnections();
        if (this.free.size() > 0) {
            Map.Entry entry = (Map.Entry)this.free.keySet().iterator().next();
            PooledConnection pooledConnection = (PooledConnection)entry.getKey();
            ConnectionState connectionState = (ConnectionState)entry.getValue();
            connectionState.setBusy(true);
            this.free.remove(pooledConnection);
            connection = pooledConnection.getConnection();
        }
        return connection;
    }

    void reinitializePoolDataSource() throws SQLException {
        this.jdbcProvider.init(SessionService.getJdbcURL(), SessionService.getSessionStoreUserName(), SessionService.getSessionStorePassword());
        this.poolDS = this.jdbcProvider.getConnectionPoolDataSource();
        this.emptyPool();
        this.createSteadyConnections();
    }

    private synchronized void createSteadyConnections() throws SQLException {
        for (int i = 0; i < this.getSteadyPoolSize(); ++i) {
            this.createConnection(false);
        }
    }

    private void destroyConnection(PooledConnection pooledConnection) {
        try {
            pooledConnection.removeConnectionEventListener(this);
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.debug.message("JDBCConnectionPool:destroyConnection", sQLException);
        }
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        ConnectionState connectionState = this.getConnectionState(pooledConnection);
        if (connectionState == null || !connectionState.isBusy()) {
            throw new IllegalStateException();
        }
        connectionState.setBusy(false);
        connectionState.touchTimestamp();
        this.free.put(pooledConnection, connectionState);
        this.notifyAll();
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        ConnectionState connectionState = this.getConnectionState(pooledConnection);
        if (connectionState == null || !connectionState.isBusy()) {
            throw new IllegalStateException();
        }
        this.connectionStates.remove(pooledConnection);
        this.destroyConnection(pooledConnection);
    }

    private ConnectionState getConnectionState(PooledConnection pooledConnection) {
        return (ConnectionState)this.connectionStates.get(pooledConnection);
    }

    public synchronized void emptyPool() {
        Iterator iterator = this.connectionStates.keySet().iterator();
        while (iterator.hasNext()) {
            this.destroyConnection((PooledConnection)iterator.next());
        }
        this.free.clear();
        this.connectionStates.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Pool [");
        stringBuffer.append("] PoolSize=");
        stringBuffer.append(this.connectionStates.size());
        stringBuffer.append("  FreeConnections=");
        stringBuffer.append(this.free.size());
        return stringBuffer.toString();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setSteadyPoolSize(int n) {
        this.steadyPoolSize = Math.min(n, this.maxPoolSize);
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public void setMaxWaitTime(int n) {
        this.maxWaitTime = n;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setRequireConnectionValidation(boolean bl) {
        this.requireConnectionValidation = bl;
    }

    public boolean isRequireConnectionValidation() {
        return this.requireConnectionValidation;
    }

    private void setFailAllConnections(boolean bl) {
        this.failAllConnections = bl;
    }

    private boolean isFailAllConnections() {
        return this.failAllConnections;
    }

    public void setIsolationLevel(int n) {
        this.isolationLevel = n;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public static class ConnectionState {
        private boolean busy;
        private long timestamp;

        public boolean isFree() {
            return !this.busy;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean bl) {
            this.busy = bl;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public ConnectionState() {
            this.touchTimestamp();
        }
    }
}

