/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ValidationErrorHandler;
import com.iplanet.am.util.XMLHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static boolean validating = false;
    private static String ATTR_VALUE_PAIR_NODE;
    private static String VALUE_NODE;

    public static Document toDOMDocument(String string, Debug debug) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            return XMLUtils.toDOMDocument(byteArrayInputStream, debug);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document:\n" + string, unsupportedEncodingException);
            }
            return null;
        }
    }

    public static Document toDOMDocument(InputStream inputStream, Debug debug) {
        DocumentBuilderFactory documentBuilderFactory;
        block8: {
            documentBuilderFactory = null;
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(validating);
                documentBuilderFactory.setNamespaceAware(true);
            }
            catch (Exception exception) {
                if (debug == null) break block8;
                debug.error("XMLUtils.DocumentBuilder init failed", exception);
            }
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (documentBuilder == null) {
                if (debug != null) {
                    debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            documentBuilder.setEntityResolver(new XMLHandler());
            if (debug != null && debug.warningEnabled()) {
                documentBuilder.setErrorHandler(new ValidationErrorHandler(debug));
            }
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document", exception);
            }
            return null;
        }
    }

    public static Set parseAttributesTag(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1 || node2.getNodeName().equals("Attribute")) {
                String string = ((Element)node2).getAttribute("name");
                hashSet.add(string);
            }
            ++n2;
        }
        return hashSet;
    }

    public static Map parseAttributeValuePairTags(Node node) {
        NodeList nodeList = node.getChildNodes();
        HashMap hashMap = null;
        int n = nodeList.getLength();
        if (n <= 0) {
            return EMPTY_MAP;
        }
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2;
            long l;
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("AttributeValuePair") && (l = (long)(nodeList2 = node2.getChildNodes()).getLength()) >= 2L) {
                Object object;
                String string = null;
                HashSet<String> hashSet = null;
                Node node3 = null;
                int n3 = 0;
                while ((long)n3 < l) {
                    node3 = nodeList2.item(n3);
                    if (node3.getNodeType() == 1 && node3.getNodeName().equals("Attribute")) {
                        n3 = (int)l;
                    }
                    ++n3;
                }
                string = ((Element)node3).getAttribute("name");
                int n4 = 0;
                while ((long)n4 < l) {
                    object = nodeList2.item(n4);
                    if (object.getNodeType() == 1 && object.getNodeName().equals("Value")) {
                        String string2;
                        Text text;
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                        }
                        if ((text = (Text)object.getFirstChild()) != null && (string2 = text.getNodeValue()) != null) {
                            hashSet.add(string2.trim());
                        }
                    }
                    ++n4;
                }
                if (hashSet != null) {
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    if ((object = (Set)hashMap.get(string)) != null) {
                        hashSet.addAll((Collection<String>)object);
                    }
                    hashMap.put(string, hashSet);
                    hashSet = null;
                }
            }
            ++n2;
        }
        if (hashMap == null) {
            return EMPTY_MAP;
        }
        return hashMap;
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(validating);
        return documentBuilderFactory.newDocumentBuilder().newDocument();
    }

    public static Document getXMLDocument(InputStream inputStream) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(validating);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            String string = "\n" + sAXParseException.getMessage() + "\n";
            Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
            throw new Exception(string + "XMLUtils.parser_error" + objectArray);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{new String(sAXException.getMessage())};
            throw new Exception("XMLUtils.exception_message" + objectArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{new String(parserConfigurationException.getMessage())};
            throw new Exception("XMLUtils.invalid_xml_document" + objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{new String(iOException.getMessage())};
            throw new Exception("XMLUtils.invalid_input_stream" + objectArray);
        }
    }

    public static Node getRootNode(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static boolean hasElementChild(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Node getNamedChildNode(Node node, String string, String string2, String string3) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (string.equalsIgnoreCase(node2.getNodeName()) && XMLUtils.getNodeAttributeValue(node2, string2).equalsIgnoreCase(string3)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static Set getChildNodes(Node node, String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                hashSet.add(node2);
            }
            ++n;
        }
        return hashSet;
    }

    public static String getElementValue(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 3) {
                stringBuffer.append(node.getNodeValue());
            }
            ++n2;
        }
        return stringBuffer.toString().trim();
    }

    public static String getElementString(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            node = nodeList.item(n);
            if (node.getNodeType() != 3) {
                return null;
            }
            stringBuffer.append(node.getNodeValue());
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static String getNodeAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static String getNodeAttributeValueNS(Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItemNS(string, string2);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static Set getAttributeValuePair(Node node) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(VALUE_NODE)) {
                hashSet.add(XMLUtils.getValueOfValueNode(node2));
            }
            ++n;
        }
        return hashSet;
    }

    public static String getValueOfValueNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            stringBuffer.append(node2.getNodeValue());
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static List getElementsByTagNameNS1(Element element, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            Node node = null;
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                String string3 = node.getLocalName();
                String string4 = node.getNamespaceURI();
                if (string3 != null && string3.equals(string2) && string4 != null && string4.equals(string)) {
                    arrayList.add(node);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static String printAttributeValue(Element element, String string) {
        Object object;
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('<');
        stringBuffer.append(string).append(element.getLocalName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = (Attr)namedNodeMap.item(n2);
            stringBuffer.append(' ');
            stringBuffer.append(object.getNodeName());
            stringBuffer.append("=\"");
            stringBuffer.append(object.getNodeValue());
            stringBuffer.append('\"');
            ++n2;
        }
        stringBuffer.append('>');
        object = element.getChildNodes();
        if (object != null) {
            int n3 = object.getLength();
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append(XMLUtils.print(object.item(n4)));
                ++n4;
            }
        }
        stringBuffer.append("</");
        stringBuffer.append(string).append(element.getLocalName());
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String print(Node node) {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource dOMSource = new DOMSource(node);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String escapeSpecialCharacters(String string) {
        char c;
        String string2 = string;
        StringBuffer stringBuffer = null;
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '&' || c == '<' || c == '>' || c == '\'' || c == '\"' || c == '\n') {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n2));
            while (n2 < n) {
                c = string.charAt(n2);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("&#xD;");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    static {
        try {
            String string = SystemProperties.get("com.iplanet.am.util.xml.validating", "off");
            String string2 = SystemProperties.get("com.iplanet.services.debug.level", "error");
            if (string.trim().equalsIgnoreCase("on") && (string2.trim().equalsIgnoreCase("warning") || string2.trim().equalsIgnoreCase("message"))) {
                validating = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
        VALUE_NODE = "Value";
    }
}

