/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.jaxrpc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.jaxrpc.SMSObjectIF;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.util.DN;

public class SMSJAXRPCObject
extends SMSObject
implements SMSObjectListener {
    private SOAPClient client;
    private static SMSObjectIF remoteStub;
    private static boolean serverFailed;
    private static String baseDN;
    private static Set entriesPresent;
    private static Set entriesNotPresent;
    private static boolean initialized;
    protected static boolean isLocal;
    private static String notificationID;
    private static Debug debug;
    private static Map objectListeners;
    private static int RETRIES;
    private static final String SERVICE_NAME = "SMSJAXRPCObject";
    private static final String INTERFACE_NAME = "SMSObjectIF";
    private static final String SMS_URL = "com.sun.identity.sm.jaxrpc.url";

    public SMSJAXRPCObject() {
        if (!initialized) {
            String string = SERVICE_NAME;
            synchronized (string) {
                if (!initialized) {
                    this.client = new SOAPClient(INTERFACE_NAME);
                    try {
                        URL uRL = WebtopNaming.getNotificationURL();
                        PLLClient.addNotificationHandler(INTERFACE_NAME, new SMSNotificationHandler());
                        notificationID = (String)this.client.send("registerNotificationURL", uRL.toString(), null);
                        if (debug.messageEnabled()) {
                            debug.message("SMSJAXRPCObject: Using notification mechanism for cache updates: " + uRL.toString());
                        }
                    }
                    catch (Exception exception) {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSJAXRPCObject: Registering for notification via URL failed: " + exception.getMessage() + "\nUsing polling mechanism for updates");
                        }
                        NotificationThread notificationThread = new NotificationThread(this);
                        notificationThread.start();
                    }
                    this.registerCallbackHandler(this);
                    initialized = true;
                }
            }
        }
    }

    public Map read(SSOToken sSOToken, String string) throws SMSException, SSOException {
        try {
            Object[] objectArray = new String[]{sSOToken.getTokenID().toString(), string};
            return (Map)this.client.send(this.client.encodeMessage("read", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:read -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-cannot-read");
        }
    }

    public void create(SSOToken sSOToken, String string, Map map) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, map};
            this.client.send(this.client.encodeMessage("create", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:create -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-cannot-create");
        }
    }

    public void modify(SSOToken sSOToken, String string, ModificationItem[] modificationItemArray) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, SMSJAXRPCObject.toMods(modificationItemArray)};
            this.client.send(this.client.encodeMessage("modify", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:modify -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-cannot-modify");
        }
    }

    public void delete(SSOToken sSOToken, String string) throws SMSException, SSOException {
        try {
            Object[] objectArray = new String[]{sSOToken.getTokenID().toString(), string};
            this.client.send(this.client.encodeMessage("delete", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:delete -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-cannot-delete");
        }
    }

    public Set searchSubOrgNames(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2, new Integer(n), new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
            return (Set)this.client.send(this.client.encodeMessage("searchSubOrgNames", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:searchSubOrgNames -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-suborg-cannot-search");
        }
    }

    public Set searchOrganizationNames(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2, String string2, String string3, Set set) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), new Boolean(bl), new Boolean(bl2), string2, string3, set};
            return (Set)this.client.send(this.client.encodeMessage("searchOrganizationNames", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:searchOrganizationNames -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-org-cannot-search");
        }
    }

    public Set subEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2, new Integer(n), new Boolean(bl), new Boolean(bl2)};
            return (Set)this.client.send(this.client.encodeMessage("subEntries", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:subEntries -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-subentry-cannot-search");
        }
    }

    public Set schemaSubEntries(SSOToken sSOToken, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2, string3, new Integer(n), new Boolean(bl), new Boolean(bl2)};
            return (Set)this.client.send(this.client.encodeMessage("schemaSubEntries", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:subEntries -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-schemasubentry-cannot-search");
        }
    }

    public Set search(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        try {
            Object[] objectArray = new String[]{sSOToken.getTokenID().toString(), string, string2};
            return (Set)this.client.send(this.client.encodeMessage("search", objectArray), null);
        }
        catch (SSOException sSOException) {
            throw sSOException;
        }
        catch (SMSException sMSException) {
            throw sMSException;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:search -- Exception:", exception);
            throw new SMSException(exception, "sms-JAXRPC-error-in-searching");
        }
    }

    public boolean entryExists(SSOToken sSOToken, String string) {
        Object object;
        if (entriesPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + string);
            }
            return true;
        }
        if (entriesNotPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + string);
            }
            return false;
        }
        boolean bl = false;
        try {
            object = new String[]{sSOToken.getTokenID().toString(), string};
            Boolean bl2 = (Boolean)this.client.send(this.client.encodeMessage("entryExists", (Object[])object), null);
            bl = bl2;
        }
        catch (Exception exception) {
            debug.error("SMSJAXRPCObject:entryExists -- Exception:", exception);
            return false;
        }
        if (bl) {
            object = new HashSet(entriesPresent);
            object.add(string);
            entriesPresent = object;
        } else {
            object = new HashSet(entriesNotPresent);
            object.add(string);
            entriesNotPresent = object;
        }
        return bl;
    }

    public String getRootSuffix() {
        if (baseDN == null) {
            try {
                baseDN = (String)this.client.send(this.client.encodeMessage("getRootSuffix", null), null);
            }
            catch (Exception exception) {
                debug.error("SMSJAXRPCObject:getRootSuffix:Exception:", exception);
            }
        }
        return baseDN;
    }

    public synchronized String registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        return this.registerCallbackHandler(sMSObjectListener);
    }

    protected String registerCallbackHandler(SMSObjectListener sMSObjectListener) {
        String string = SMSUtils.getUniqueID();
        objectListeners.put(string, sMSObjectListener);
        return string;
    }

    public synchronized void deregisterCallbackHandler(String string) {
        objectListeners.remove(string);
    }

    public void objectChanged(String string, int n) {
        string = new DN(string).toRFCString().toLowerCase();
        Set set = entriesPresent;
        synchronized (set) {
            if (n == 1) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesPresent.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.equals(new DN(string2).toRFCString().toLowerCase())) continue;
                    hashSet.add(string2);
                }
                entriesPresent = hashSet;
            } else if (n == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesNotPresent.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string.equals(new DN(string3).toRFCString().toLowerCase())) continue;
                    hashSet.add(string3);
                }
                entriesNotPresent = hashSet;
            }
        }
    }

    public void allObjectsChanged() {
    }

    static String toMods(ModificationItem[] modificationItemArray) throws SMSException {
        if (modificationItemArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<Modifications size=\"");
        stringBuffer.append(modificationItemArray.length);
        stringBuffer.append("\">");
        int n = 0;
        while (n < modificationItemArray.length) {
            stringBuffer.append("<AttributeValuePair event=\"");
            switch (modificationItemArray[n].getModificationOp()) {
                case 1: {
                    stringBuffer.append("ADD");
                    break;
                }
                case 2: {
                    stringBuffer.append("REPLACE");
                    break;
                }
                case 3: {
                    stringBuffer.append("DELETE");
                }
            }
            stringBuffer.append("\"><Attribute name=\"");
            Attribute attribute = modificationItemArray[n].getAttribute();
            stringBuffer.append(attribute.getID());
            stringBuffer.append("\"/>");
            int n2 = attribute.size();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("<Value>");
                try {
                    stringBuffer.append(attribute.get(n3));
                }
                catch (NamingException namingException) {
                    throw new SMSException(namingException, "sms-JAXRPC-cannot-copy-fromModItemToString");
                }
                stringBuffer.append("</Value>");
                ++n3;
            }
            stringBuffer.append("</AttributeValuePair>");
            ++n;
        }
        stringBuffer.append("</Modifications>");
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObject::ModsToString: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    static void sendNotification(String string) {
        String string2 = string.substring(4);
        int n = 3;
        if (string.startsWith("ADD:")) {
            n = 0;
        }
        if (string.startsWith("DEL:")) {
            n = 1;
        }
        Iterator iterator = objectListeners.values().iterator();
        while (iterator.hasNext()) {
            SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator.next();
            sMSObjectListener.objectChanged(string2, n);
        }
    }

    static {
        entriesPresent = new HashSet();
        entriesNotPresent = new HashSet();
        debug = Debug.getInstance("amSMS");
        objectListeners = new HashMap();
        RETRIES = 3;
    }

    static class SMSNotificationHandler
    implements NotificationHandler {
        SMSNotificationHandler() {
        }

        public void process(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                Notification notification = (Notification)vector.elementAt(n);
                String string = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("SMSJAXRPCObject:SMSNotificationHandler:  received notification: " + string);
                }
                SMSJAXRPCObject.sendNotification(string);
                ++n;
            }
        }
    }

    static class NotificationThread
    extends Thread {
        static final String CACHE_TIME_PROPERTY = "com.sun.identity.sm.cacheTime";
        static int pollingTime = 1;
        static int sleepTime = 60000;

        NotificationThread(SMSJAXRPCObject sMSJAXRPCObject) {
            this.setDaemon(true);
            String string = SystemProperties.get(CACHE_TIME_PROPERTY);
            if (string != null) {
                try {
                    pollingTime = Integer.parseInt(string);
                    if (pollingTime > 0) {
                        sleepTime = pollingTime * 1000 * 60;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("SMSJAXRPCObject::NotificationThread:: Cache Time error: " + string, numberFormatException);
                }
            }
        }

        public void run() {
            boolean bl = false;
            SOAPClient sOAPClient = new SOAPClient(SMSJAXRPCObject.INTERFACE_NAME);
            while (true) {
                try {
                    while (true) {
                        if (bl) {
                            Thread.sleep(sleepTime);
                        }
                        Object[] objectArray = new Object[]{new Integer(pollingTime)};
                        Set set = (Set)sOAPClient.send(sOAPClient.encodeMessage("objectsChanged", objectArray), null);
                        if (debug.messageEnabled()) {
                            debug.message("SMSJAXRPCObject:NotificationThread retrived changes: " + set);
                        }
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            SMSJAXRPCObject.sendNotification((String)iterator.next());
                        }
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.warning("SMSJAXRCPObject::NotificationThread:run Number Format Exception for polling Time: " + pollingTime, numberFormatException);
                    continue;
                }
                catch (SMSException sMSException) {
                    if (sMSException.getExceptionCode() != SMSException.STATUS_REPEATEDLY_FAILED) {
                        bl = false;
                    }
                    debug.warning("SMSJAXRPCObject::NotificationThread:run SMSException", sMSException);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                    debug.warning("SMSJAXRPCObject::NotificationThread:run Interrupted Exception", interruptedException);
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                    debug.warning("SMSJAXRPCObject::NotificationThread:run Exception", exception);
                    continue;
                }
                break;
            }
        }
    }
}

