/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceInstanceImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ServiceInstance {
    private ServiceConfigManager scm;
    private SSOToken token;
    private ServiceInstanceImpl instance;

    ServiceInstance(ServiceConfigManager serviceConfigManager, ServiceInstanceImpl serviceInstanceImpl) {
        this.scm = serviceConfigManager;
        this.instance = serviceInstanceImpl;
        this.token = serviceConfigManager.getSSOToken();
    }

    public String getName() {
        return this.instance.getName();
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public String getGroup() {
        return this.instance.getGroup();
    }

    public void setGroup(String string) throws SSOException, SMSException {
        if (!this.scm.containsGroup(string)) {
            Object[] objectArray = new String[]{string};
            throw new SMSException("amSDK", "sms-invalid-group-name", objectArray);
        }
        String[] stringArray = new String[]{string};
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        sMSEntry.setAttribute("sunserviceID", stringArray);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public String getURI() {
        return this.instance.getURI();
    }

    public void setURI(String string) throws SSOException, SMSException {
        String[] stringArray = new String[]{string};
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        sMSEntry.setAttribute("labeleduri", stringArray);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\nService Instance: ").append(this.getName()).append("\n\tGroup: ").append(this.getGroup()).append("\n\tURI: ").append(this.getURI()).append("\n\tAttributes: ").append(this.getAttributes());
        return stringBuffer.toString();
    }

    public Map getAttributes() {
        return this.instance.getAttributes();
    }

    public void setAttributes(Map map) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.setAttributeValuePairs(sMSEntry, map, Collections.EMPTY_SET);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public void addAttribute(String string, Set set) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.addAttribute(sMSEntry, string, set, Collections.EMPTY_SET);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public void removeAttribute(String string) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.removeAttribute(sMSEntry, string);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public void removeAttributeValues(String string, Set set) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.removeAttributeValues(sMSEntry, string, set, Collections.EMPTY_SET);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public void replaceAttributeValue(String string, String string2, String string3) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.replaceAttributeValue(sMSEntry, string, string2, string3, Collections.EMPTY_SET);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    public void replaceAttributeValues(String string, Set set, Set set2) throws SSOException, SMSException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        SMSUtils.replaceAttributeValues(sMSEntry, string, set, set2, Collections.EMPTY_SET);
        sMSEntry.save(this.token);
        this.instance.refresh(sMSEntry);
    }

    void delete() throws SMSException, SSOException {
        SMSEntry sMSEntry = this.instance.getSMSEntry();
        sMSEntry.delete();
        this.instance.refresh(sMSEntry);
    }
}

