/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ServiceConfigImpl
implements ServiceListener {
    private ServiceConfigManagerImpl scm;
    private ServiceSchemaImpl ss;
    private SSOToken token;
    private boolean globalConfig;
    private boolean newEntry;
    private String serviceComponentName;
    private String orgName;
    private String groupName;
    private String compName;
    private String configID;
    private int priority;
    private Map attributes;
    private Map attributesWithoutDefaults;
    private CachedSMSEntry smsEntry;
    private CachedSubEntries subEntries = null;
    private static Map configImpls = new HashMap();
    private static Map userPrincipals = new HashMap();
    private static Debug debug = SMSEntry.debug;
    private static final String configMutex = "ConfigMutex";

    private ServiceConfigImpl(ServiceConfigManagerImpl serviceConfigManagerImpl, ServiceSchemaImpl serviceSchemaImpl, CachedSMSEntry cachedSMSEntry, String string, String string2, String string3, boolean bl, SSOToken sSOToken) throws SMSException, SSOException {
        this.scm = serviceConfigManagerImpl;
        this.ss = serviceSchemaImpl;
        this.smsEntry = cachedSMSEntry;
        this.smsEntry.addServiceListener(this);
        ServiceSchemaManagerImpl serviceSchemaManagerImpl = serviceConfigManagerImpl.getServiceSchemaManagerImpl();
        serviceSchemaManagerImpl.addListener(this);
        this.orgName = string == null ? SMSEntry.baseDN : string;
        this.groupName = string2;
        if (string3 == null || string3.equals("")) {
            this.compName = "";
            this.serviceComponentName = "/";
        } else {
            this.compName = string3.substring(string3.lastIndexOf(47) + 1);
            this.serviceComponentName = string3;
        }
        this.globalConfig = bl;
        this.update();
        this.token = sSOToken;
    }

    String getComponentName() {
        return this.serviceComponentName;
    }

    String getSchemaID() {
        return this.configID;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getOrganizationName() {
        return this.orgName;
    }

    int getPriority() {
        return this.priority;
    }

    Set getSubConfigNames(SSOToken sSOToken) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(this.token, this.smsEntry.getDN());
        }
        return this.subEntries.getSubEntries(sSOToken);
    }

    Set getSubConfigNames(SSOToken sSOToken, String string) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(sSOToken, this.smsEntry.getDN());
        }
        return this.subEntries.getSubEntries(sSOToken, string);
    }

    Set getSubConfigNames(String string, String string2) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(this.token, this.smsEntry.getDN());
        }
        return this.subEntries.getSchemaSubEntries(string, string2);
    }

    ServiceConfigImpl getSubConfig(SSOToken sSOToken, String string) throws SSOException, SMSException {
        String string2 = string = SMSSchema.unescapeName(string);
        String string3 = "ou=" + string + "," + this.smsEntry.getDN();
        return ServiceConfigImpl.getInstance(sSOToken, this.scm, null, string3, this.orgName, this.groupName, this.serviceComponentName + "/" + SMSSchema.escapeSpecialCharacters(string), this.globalConfig, this.ss);
    }

    Map getAttributes() {
        if (!SMSEntry.cacheSMSEntries) {
            this.update();
        }
        return SMSUtils.copyAttributes(this.attributes);
    }

    Map getAttributesWithoutDefaults() {
        if (!SMSEntry.cacheSMSEntries) {
            this.update();
        }
        return SMSUtils.copyAttributes(this.attributesWithoutDefaults);
    }

    String getDN() {
        return this.smsEntry.getDN();
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry sMSEntry) throws SMSException {
        this.smsEntry.refresh(sMSEntry);
    }

    ServiceSchemaImpl getServiceSchemaImpl() {
        return this.ss;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    void updateAndNotifyListeners() {
        this.update();
    }

    void update() {
        String[] stringArray;
        String[] stringArray2;
        SMSEntry sMSEntry = this.smsEntry.getSMSEntry();
        this.newEntry = sMSEntry.isNewEntry();
        Map map = SMSUtils.getAttrsFromEntry(sMSEntry);
        Map map2 = SMSUtils.getAttrsFromEntry(sMSEntry);
        String string = this.ss.getValidate();
        if (string == null || string.equalsIgnoreCase("yes")) {
            Object object;
            stringArray2 = this.ss.getAttributeSchemaNames();
            stringArray = map.keySet();
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator<Object> iterator = stringArray.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (stringArray2.contains(object)) continue;
                hashSet.add(object);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                map.remove(object);
                map2.remove(object);
            }
            object = stringArray2.iterator();
            while (object.hasNext()) {
                AttributeValidator attributeValidator = this.ss.getAttributeValidator((String)object.next());
                map = attributeValidator.inheritDefaults(map);
                map2 = attributeValidator.decodeEncodedAttrs(map2);
            }
        }
        this.priority = 0;
        stringArray2 = this.smsEntry.getSMSEntry().getAttributeValues("sunsmspriority");
        if (stringArray2 != null) {
            try {
                this.priority = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                SMSEntry.debug.error("ServiceConfig::getPriority() " + numberFormatException);
            }
        }
        this.configID = (stringArray = sMSEntry.getAttributeValues("sunserviceID")) != null ? stringArray[0] : this.compName;
        this.attributes = map;
        this.attributesWithoutDefaults = map2;
    }

    static ServiceConfigImpl getInstance(SSOToken sSOToken, ServiceConfigManagerImpl serviceConfigManagerImpl, ServiceSchemaImpl serviceSchemaImpl, String string, String string2, String string3, String string4, boolean bl) throws SSOException, SMSException {
        return ServiceConfigImpl.getInstance(sSOToken, serviceConfigManagerImpl, serviceSchemaImpl, string, string2, string3, string4, bl, null);
    }

    static ServiceConfigImpl getInstance(SSOToken sSOToken, ServiceConfigManagerImpl serviceConfigManagerImpl, ServiceSchemaImpl serviceSchemaImpl, String string, String string2, String string3, String string4, boolean bl, ServiceSchemaImpl serviceSchemaImpl2) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::getInstance: called: " + string);
        }
        String string5 = DNMapper.orgNameToDN(string2);
        String string6 = ServiceConfigImpl.getCacheName(serviceConfigManagerImpl.getName(), serviceConfigManagerImpl.getVersion(), string5, string3, string4, bl);
        ServiceConfigImpl serviceConfigImpl = ServiceConfigImpl.getFromCache(string6, string, sSOToken);
        if (serviceConfigImpl != null) {
            if (!SMSEntry.cacheSMSEntries) {
                serviceConfigImpl.update();
            }
            return serviceConfigImpl;
        }
        if (!SMSEntry.checkIfEntryExists(DNMapper.orgNameToDN(string5), sSOToken)) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceConfigImpl::getInstance called with non existant organization name: " + string5);
            }
            return null;
        }
        String string7 = configMutex;
        synchronized (string7) {
            serviceConfigImpl = ServiceConfigImpl.getFromCache(string6, string, sSOToken);
            if (serviceConfigImpl == null) {
                Object object;
                CachedSMSEntry cachedSMSEntry = ServiceConfigImpl.checkAndUpdatePermission(string6, string, sSOToken);
                if (serviceSchemaImpl == null) {
                    object = null;
                    SMSEntry sMSEntry = cachedSMSEntry.getSMSEntry();
                    String[] stringArray = sMSEntry.getAttributeValues("sunserviceID");
                    if (stringArray != null) {
                        object = stringArray[0];
                    } else {
                        int n = string4.lastIndexOf(47);
                        object = string4.substring(n + 1);
                    }
                    if (serviceSchemaImpl2 != null) {
                        serviceSchemaImpl = serviceSchemaImpl2.getSubSchema((String)object);
                    }
                    if (serviceSchemaImpl == null) {
                        ServiceConfigImpl serviceConfigImpl2 = null;
                        return serviceConfigImpl2;
                    }
                }
                serviceConfigImpl = new ServiceConfigImpl(serviceConfigManagerImpl, serviceSchemaImpl, cachedSMSEntry, string5, string3, string4, bl, sSOToken);
                object = new HashMap(configImpls);
                ((HashMap)object).put(string6, serviceConfigImpl);
                configImpls = object;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::getInstance: return: " + string);
        }
        return serviceConfigImpl;
    }

    static ServiceConfigImpl getFromCache(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException {
        Set set;
        ServiceConfigImpl serviceConfigImpl = (ServiceConfigImpl)configImpls.get(string);
        if (serviceConfigImpl != null && !serviceConfigImpl.smsEntry.isValid()) {
            serviceConfigImpl = null;
        }
        if (serviceConfigImpl != null && !(set = (Set)userPrincipals.get(string)).contains(sSOToken.getTokenID().toString())) {
            ServiceConfigImpl.checkAndUpdatePermission(string, string2, sSOToken);
        }
        return serviceConfigImpl;
    }

    static synchronized CachedSMSEntry checkAndUpdatePermission(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, string2, null);
        HashSet<String> hashSet = (HashSet<String>)userPrincipals.get(string);
        hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
        hashSet.add(sSOToken.getTokenID().toString());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(userPrincipals);
        hashMap.put(string, hashSet);
        userPrincipals = hashMap;
        return cachedSMSEntry;
    }

    static void clearCache() {
        configImpls = new HashMap();
    }

    static String getCacheName(String string, String string2, String string3, String string4, String string5, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string).append(string2).append(string3).append(string4).append(string5).append(bl);
        return stringBuffer.toString().toLowerCase();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    public void schemaChanged(String string, String string2) {
        if (string.equalsIgnoreCase(this.scm.getName())) {
            this.update();
        }
    }
}

