/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class SMSEventListenerManager
implements SMSObjectListener {
    protected static Map notificationObjects = Collections.synchronizedMap(new HashMap());
    protected static Map allChanges = Collections.synchronizedMap(new HashMap());
    protected static Map nodeChanges = Collections.synchronizedMap(new HashMap());
    protected static Map subNodeChanges = Collections.synchronizedMap(new HashMap());
    private static Debug debug = SMSEntry.eventDebug;
    protected static boolean initialized;

    static void initialize(SSOToken sSOToken) {
        if (!initialized) {
            try {
                initialized = true;
                SMSEntry.registerCallbackHandler(sSOToken, new SMSEventListenerManager());
                debug.message("Initialized SMS Event listner");
            }
            catch (Exception exception) {
                debug.error("SMSEventListenerManager::initialize Unable to intialize SMS listener: " + exception);
                initialized = false;
            }
        }
    }

    SMSEventListenerManager() {
    }

    public void objectChanged(String string, int n) {
        this.objectChanged(string, n, false);
    }

    private void objectChanged(String string, int n, boolean bl) {
        if (debug.messageEnabled()) {
            debug.message("SMSEventListener::entry changed for: " + string + " type: " + n);
        }
        DN dN = new DN(string);
        String string2 = dN.toRFCString().toLowerCase();
        if (!bl && !SMSEntry.enableDataStoreNotification && n == 1) {
            Iterator<Object> iterator;
            HashSet<String> hashSet = new HashSet<String>();
            Map map = nodeChanges;
            synchronized (map) {
                iterator = nodeChanges.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (!new DN(string3).isDescendantOf(dN)) continue;
                    hashSet.add(string3);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("SMSEventListener::objectChanged: Sending delete event of: " + string2 + " to child nodes: " + hashSet);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.objectChanged((String)iterator.next(), n, true);
            }
        }
        SMSEventListenerManager.sendNotifications((Set)nodeChanges.get(string2), null, n);
        if (n == 0 || n == 1) {
            if (debug.messageEnabled()) {
                debug.message("SMSEventListener::entry changed for: " + string2 + " sending notifications to its parents");
            }
            SMSEventListenerManager.sendNotifications((Set)subNodeChanges.get(new DN(string2).getParent().toRFCString().toLowerCase()), string, n);
        }
        SMSEventListenerManager.sendAllChangesNotification(string2, n);
    }

    public void allObjectsChanged() {
        Iterator<Object> iterator;
        if (debug.messageEnabled()) {
            debug.message("SMSEventListenerManager::allObjectsChanged called");
        }
        HashSet hashSet = new HashSet();
        Map map = nodeChanges;
        synchronized (map) {
            iterator = nodeChanges.keySet().iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.objectChanged((String)iterator.next(), 3);
        }
    }

    protected static String notifyAllNodeChanges(SSOToken sSOToken, Object object) {
        SMSEventListenerManager.initialize(sSOToken);
        String string = SMSUtils.getUniqueID();
        allChanges.put(string, object);
        return string;
    }

    protected static String notifyChangesToNode(SSOToken sSOToken, String string, Method method, Object object, Object[] objectArray) {
        SMSEventListenerManager.initialize(sSOToken);
        String string2 = new DN(string).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(nodeChanges, string2, method, object, objectArray);
    }

    protected static String notifyChangesToSubNodes(SSOToken sSOToken, String string, Method method, Object object, Object[] objectArray) {
        SMSEventListenerManager.initialize(sSOToken);
        String string2 = new DN(string).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(subNodeChanges, string2, method, object, objectArray);
    }

    protected static void removeNotification(String string) {
        NotificationObject notificationObject = (NotificationObject)notificationObjects.get(string);
        if (notificationObject != null) {
            notificationObject.set.remove(notificationObject);
        }
        allChanges.remove(string);
    }

    private static String addNotificationObject(Map map, String string, Method method, Object object, Object[] objectArray) {
        HashSet<NotificationObject> hashSet = (HashSet<NotificationObject>)map.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<NotificationObject>();
            map.put(string, hashSet);
        }
        NotificationObject notificationObject = new NotificationObject(method, object, objectArray, hashSet);
        hashSet.add(notificationObject);
        notificationObjects.put(notificationObject.getID(), notificationObject);
        return notificationObject.getID();
    }

    private static void sendAllChangesNotification(String string, int n) {
        Map map = allChanges;
        synchronized (map) {
            Iterator iterator = allChanges.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object v = iterator.next();
                if (v instanceof ServiceConfigManagerImpl) {
                    object = (ServiceConfigManagerImpl)v;
                    ((ServiceConfigManagerImpl)object).entryChanged(string, n);
                }
                if (!(v instanceof OrganizationConfigManagerImpl)) continue;
                object = (OrganizationConfigManagerImpl)v;
                ((OrganizationConfigManagerImpl)object).entryChanged(string, n);
            }
        }
    }

    private static void sendNotifications(Set set, String string, int n) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    NotificationObject notificationObject = (NotificationObject)iterator.next();
                    if (string != null && notificationObject.object instanceof CachedSubEntries) {
                        CachedSubEntries cachedSubEntries = (CachedSubEntries)notificationObject.object;
                        if (string.startsWith("o=")) continue;
                        if (n == 0) {
                            cachedSubEntries.add(new DN(string).explodeDN(true)[0]);
                            continue;
                        }
                        cachedSubEntries.remove(new DN(string).explodeDN(true)[0]);
                        continue;
                    }
                    notificationObject.method.invoke(notificationObject.object, notificationObject.args);
                }
                catch (Exception exception) {
                    debug.error("SMSEvent notification: Unable to send notification: ", exception);
                }
            }
        }
    }

    private static class NotificationObject {
        String id;
        Method method;
        Object object;
        Object[] args;
        Set set;

        NotificationObject(Method method, Object object, Object[] objectArray, Set set) {
            this.method = method;
            this.object = object;
            this.args = objectArray;
            this.set = set;
        }

        String getID() {
            if (this.id == null) {
                this.id = SMSUtils.getUniqueID();
            }
            return this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof NotificationObject) {
                NotificationObject notificationObject = (NotificationObject)object;
                if (this.id == notificationObject.id) {
                    return true;
                }
            }
            return false;
        }
    }
}

