/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class OrganizationConfigManager {
    private SSOToken token;
    private String orgName;
    private String orgDN;
    private OrgConfigViaAMSDK amsdk;
    private OrganizationConfigManagerImpl orgConfigImpl;
    static String orgNamingAttrInLegacyMode;
    protected static final String SERVICES_NODE;
    private static Set serviceSchemaSet;
    private static boolean registeredForNotifications;
    private static boolean registeredForConfigNotifications;
    private static boolean realmEnabled;
    private static boolean coexistMode;
    private static boolean migratedTo70;

    public OrganizationConfigManager(SSOToken sSOToken, String string) throws SMSException {
        this.token = sSOToken;
        this.orgName = string;
        this.orgConfigImpl = OrganizationConfigManagerImpl.getInstance(sSOToken, string);
        this.orgDN = this.orgConfigImpl.getOrgDN();
        try {
            if (migratedTo70 && !registeredForConfigNotifications) {
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager("sunidentityrepositoryservice", sSOToken);
                serviceConfigManager.addListener(new OrganizationConfigManagerListener());
                registeredForConfigNotifications = true;
            }
        }
        catch (SMSException sMSException) {
            SMSEntry.debug.error("OrganizationConfigManager: constructor. Unable to construct ServiceConfigManager for idRepoService ", sMSException);
            throw sMSException;
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager:Constructor", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (coexistMode) {
            this.amsdk = new OrgConfigViaAMSDK(sSOToken, DNMapper.realmNameToAMSDKName(this.orgDN), this.orgDN);
            if (orgNamingAttrInLegacyMode == null) {
                orgNamingAttrInLegacyMode = this.getNamingAttrForOrg();
            }
        }
    }

    public String getOrganizationName() {
        return this.orgName;
    }

    public Set getConfiguredServices() throws SMSException {
        return this.getAssignedServices();
    }

    public Set getServiceSchemas() throws SMSException {
        if (serviceSchemaSet != null && !serviceSchemaSet.isEmpty()) {
            return serviceSchemaSet;
        }
        try {
            Set set = OrganizationConfigManager.getServiceNames(this.token);
            serviceSchemaSet = new HashSet(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ServiceSchema serviceSchema;
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager((String)iterator.next(), this.token);
                if (!registeredForNotifications) {
                    serviceSchemaManager.addListener(new OrganizationConfigManagerListener());
                }
                if ((serviceSchema = serviceSchemaManager.getOrganizationCreationSchema()) == null) continue;
                serviceSchemaSet.add(serviceSchema);
            }
            registeredForNotifications = true;
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager:getServiceSchemas unable to get service schema", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
        return serviceSchemaSet;
    }

    public OrganizationConfigManager createSubOrganization(String string, Map map) throws SMSException {
        String string2;
        boolean bl;
        block8: {
            bl = false;
            string2 = OrganizationConfigManager.normalizeDN(string, this.orgDN);
            try {
                new OrganizationConfigManager(this.token, string2);
                SMSEntry.debug.error("OrganizationConfigManager::createSubOrganization() Realm Already Exists.. " + string2);
                bl = true;
            }
            catch (SMSException sMSException) {
                if (!SMSEntry.debug.messageEnabled()) break block8;
                SMSEntry.debug.message("OrganizationConfigManager::createSubOrganization() New Realm, creating realm: " + string + "-" + sMSException);
            }
        }
        Object[] objectArray = new Object[]{string};
        if (bl) {
            throw new SMSException("amSDK", SMSEntry.bundle.getString("sms-organization_already_exists1"), objectArray);
        }
        if (coexistMode) {
            this.amsdk.createSubOrganization(string);
        }
        if ((realmEnabled || string2.toLowerCase().startsWith("o=sunamhiddenrealm")) && this.getSubOrganizationNames(string, false).isEmpty()) {
            CreateServiceConfig.createOrganization(this.token, string2);
        }
        OrganizationConfigManager organizationConfigManager = this.getSubOrgConfigManager(string);
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Map map2 = (Map)map.get(string3);
                if (map2 == null || map2.isEmpty()) continue;
                organizationConfigManager.setAttributes(string3, map2);
            }
        }
        if (realmEnabled && !coexistMode) {
            OrganizationConfigManager.loadDefaultServices(this.token, organizationConfigManager);
        }
        return organizationConfigManager;
    }

    public Set getSubOrganizationNames() throws SMSException {
        try {
            return this.getSubOrganizationNames("*", false);
        }
        catch (SMSException sMSException) {
            SMSEntry.debug.error("OrganizationConfigManager: getSubOrganizationNames() Unable to get sub organization names ", sMSException);
            throw sMSException;
        }
    }

    public Set getPeerOrganizationNames() throws SMSException {
        Set set = Collections.EMPTY_SET;
        if (realmEnabled) {
            try {
                OrganizationConfigManager organizationConfigManager = this.getParentOrgConfigManager();
                set = organizationConfigManager.getSubOrganizationNames();
            }
            catch (SMSException sMSException) {
                if (SMSEntry.debug.warningEnabled()) {
                    SMSEntry.debug.warning("OrganizationConfigManager: getPeerOrganizationNames() Unable to get Peer organization names ", sMSException);
                }
                throw sMSException;
            }
        }
        return set;
    }

    public Set getSubOrganizationNames(String string, boolean bl) throws SMSException {
        try {
            if (realmEnabled) {
                return this.orgConfigImpl.getSubOrganizationNames(this.token, string, bl);
            }
            return this.amsdk.getSubOrganizationNames(string, bl);
        }
        catch (SMSException sMSException) {
            SMSEntry.debug.error("OrganizationConfigManager: getSubOrganizationNames(String pattern, boolean recursive) Unable to get sub organization names for filter: " + string, sMSException);
            throw sMSException;
        }
    }

    public void deleteSubOrganization(String string, boolean bl) throws SMSException {
        block9: {
            Object object;
            String string2 = OrganizationConfigManager.normalizeDN(string, this.orgDN);
            if (realmEnabled) {
                try {
                    OrganizationConfigManager organizationConfigManager;
                    object = CachedSMSEntry.getInstance(this.token, string2, null);
                    SMSEntry sMSEntry = ((CachedSMSEntry)object).getClonedSMSEntry();
                    if (!bl && !(organizationConfigManager = this.getSubOrgConfigManager(string)).getSubOrganizationNames().isEmpty()) {
                        throw new SMSException(SMSEntry.bundle.getString("sms-entries-exists"), "sms-entries-exists");
                    }
                    sMSEntry.delete(this.token);
                    ((CachedSMSEntry)object).refresh(sMSEntry);
                }
                catch (SSOException sSOException) {
                    SMSEntry.debug.error("OrganizationConfigManager: deleteSubOrganization(String subOrgName, boolean recursive) Unable to delete sub organization ", sSOException);
                    throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
                }
            }
            if (coexistMode) {
                object = DNMapper.realmNameToAMSDKName(string2);
                this.amsdk.deleteSubOrganization((String)object);
            }
            try {
                DelegationUtils.deleteRealmPrivileges((SSOToken)this.token, (String)string2);
            }
            catch (SSOException sSOException) {
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager::deleteSubOrganization SSOException in deleting permissions ", sSOException);
                }
            }
            catch (DelegationException delegationException) {
                if (!SMSEntry.debug.messageEnabled()) break block9;
                SMSEntry.debug.message("OrganizationConfigManager::deleteSubOrganization DelegationException in deleting permission ", delegationException);
            }
        }
    }

    public OrganizationConfigManager getSubOrgConfigManager(String string) throws SMSException {
        return new OrganizationConfigManager(this.token, OrganizationConfigManager.normalizeDN(string, this.orgDN));
    }

    public Map getAttributes(String string) throws SMSException {
        HashMap<String, Set> hashMap;
        if (string == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Set> hashMap2 = null;
        if (migratedTo70) {
            string = string.toLowerCase();
            try {
                SMSEntry sMSEntry;
                Map map;
                hashMap = CachedSMSEntry.getInstance(this.token, this.orgDN, null);
                if (coexistMode) {
                    ((CachedSMSEntry)((Object)hashMap)).update();
                }
                if ((map = SMSUtils.getAttrsFromEntry(sMSEntry = ((CachedSMSEntry)((Object)hashMap)).getSMSEntry())) != null && !map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!string2.toLowerCase().startsWith(string)) continue;
                        Set set = (Set)map.get(string2);
                        String string3 = string2.substring(string.length() + 1);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap<String, Set>();
                        }
                        hashMap2.put(string3, set);
                    }
                }
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("OrganizationConfigManager: getAttributes(String serviceName) Unable to get Attributes", sSOException);
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && string.equalsIgnoreCase("sunidentityrepositoryservice") && (hashMap = this.amsdk.getAttributes()) != null && !hashMap.isEmpty()) {
            if (hashMap2 == null) {
                hashMap2 = hashMap;
            } else {
                hashMap2.putAll(hashMap);
            }
        }
        return hashMap2 == null ? Collections.EMPTY_MAP : hashMap2;
    }

    public void addAttributeValues(String string, String string2, Set set) throws SMSException {
        if (string == null || string2 == null) {
            return;
        }
        if (migratedTo70) {
            string = string.toLowerCase();
            try {
                CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, this.orgDN, null);
                SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationCreationSchema();
                if (serviceSchema == null) {
                    throw new SMSException(SMSEntry.bundle.getString("sms-SMSSchema_service_notfound"), "sms-SMSSchema_service_notfound");
                }
                HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
                hashMap.put(string2, set);
                serviceSchema.validateAttributes(hashMap);
                SMSUtils.addAttribute(sMSEntry, string + "-" + string2, set, serviceSchema.getSearchableAttributeNames());
                sMSEntry.save(this.token);
                cachedSMSEntry.refresh(sMSEntry);
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to add Attribute Values", sSOException);
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && string.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.addAttributeValues(string2, set);
        }
    }

    public void setAttributes(String string, Map map) throws SMSException {
        if (string == null) {
            return;
        }
        if (migratedTo70) {
            string = string.toLowerCase();
            try {
                CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, this.orgDN, null);
                SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
                if (map != null && !map.isEmpty()) {
                    String[] stringArray;
                    Object object;
                    Object object2;
                    ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                    ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationCreationSchema();
                    serviceSchema.validateAttributes(map);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        object = (Set)map.get(object2);
                        hashMap.put(string + "-" + (String)object2, object);
                    }
                    object2 = this.getAttributes(string);
                    object = object2.keySet().iterator();
                    while (object.hasNext()) {
                        stringArray = (String[])object.next();
                        if (map.containsKey(stringArray)) continue;
                        hashMap.put(string + "-" + (String)stringArray, object2.get(stringArray));
                    }
                    SMSUtils.setAttributeValuePairs(sMSEntry, hashMap, serviceSchema.getSearchableAttributeNames());
                    if (sMSEntry.getDN().equalsIgnoreCase(SERVICES_NODE)) {
                        stringArray = sMSEntry.getAttributeValues("objectclass");
                        boolean bl = false;
                        int n = 0;
                        while (stringArray != null && n < stringArray.length) {
                            if (stringArray[n].startsWith("sunServiceComponent")) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl) {
                            sMSEntry.addAttribute("objectclass", "sunServiceComponent");
                        }
                    } else if (sMSEntry.getDN().startsWith("o=")) {
                        stringArray = sMSEntry.getAttributeValues("objectclass");
                        boolean bl = false;
                        int n = 0;
                        while (stringArray != null && n < stringArray.length) {
                            if (stringArray[n].equalsIgnoreCase("sunRealmService")) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl) {
                            sMSEntry.addAttribute("objectclass", "sunRealmService");
                        }
                    }
                    sMSEntry.save(this.token);
                    cachedSMSEntry.refresh(sMSEntry);
                }
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to set Attributes", sSOException);
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && string.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.setAttributes(map);
        }
    }

    public void removeAttribute(String string, String string2) throws SMSException {
        if (string == null || string2 == null) {
            return;
        }
        if (migratedTo70) {
            try {
                CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, this.orgDN, null);
                SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
                SMSUtils.removeAttribute(sMSEntry, string.toLowerCase() + "-" + string2);
                sMSEntry.save(this.token);
                cachedSMSEntry.refresh(sMSEntry);
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to remove Attribute", sSOException);
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && string.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.removeAttribute(string2);
        }
    }

    public void removeAttributeValues(String string, String string2, Set set) throws SMSException {
        if (string == null || string2 == null) {
            return;
        }
        if (migratedTo70) {
            try {
                CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, this.orgDN, null);
                SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationCreationSchema();
                HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
                hashMap.put(string2, set);
                serviceSchema.validateAttributes(hashMap);
                SMSUtils.removeAttributeValues(sMSEntry, string.toLowerCase() + "-" + string2, set, serviceSchema.getSearchableAttributeNames());
                sMSEntry.save(this.token);
                cachedSMSEntry.refresh(sMSEntry);
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to remove Attribute Values", sSOException);
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && string.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.removeAttributeValues(string2, set);
        }
    }

    public ServiceConfig getServiceConfig(String string) throws SMSException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, this.token);
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(this.orgName, null);
            return serviceConfig;
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to get Service Config", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public ServiceConfig addServiceConfig(String string, Map map) throws SMSException {
        try {
            ServiceConfigManagerImpl serviceConfigManagerImpl = ServiceConfigManagerImpl.getInstance(this.token, string, ServiceManager.serviceDefaultVersion(this.token, string));
            ServiceConfigImpl serviceConfigImpl = serviceConfigManagerImpl.getOrganizationConfig(this.token, this.orgName, null);
            if (serviceConfigImpl == null || serviceConfigImpl.isNewEntry()) {
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, this.token);
                return serviceConfigManager.createOrganizationConfig(this.orgName, map);
            }
            SMSEntry.debug.error("OrganizationConfigManager: ServiceConfig already exists: " + serviceConfigImpl.getDN());
            throw new ServiceAlreadyExistsException(SMSEntry.bundle.getString("sms-service_already_exists1"));
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to add Service Config", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public void removeServiceConfig(String string) throws SMSException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, this.token);
            serviceConfigManager.deleteOrganizationConfig(this.orgName);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to delete Service Config", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public String addListener(ServiceListener serviceListener) {
        return this.orgConfigImpl.addListener(serviceListener);
    }

    public void removeListener(String string) {
        this.orgConfigImpl.removeListener(string);
    }

    private static String normalizeDN(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager.normalizeDN()-subOrgName " + string);
        }
        String string3 = null;
        if (DN.isDN(string)) {
            int n = string.lastIndexOf(DNMapper.serviceDN);
            if (n == -1) {
                n = string.lastIndexOf(SMSEntry.baseDN);
            }
            if (n > 0) {
                string = string.substring(0, n - 1);
            }
            string3 = DNMapper.normalizeDN(string) + string2;
        } else if (string.indexOf(47) != -1) {
            int n;
            String string4 = DNMapper.convertToDN(string).toString();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager.normalizeDN()-slashConvertedString: " + string4);
            }
            string3 = string4 != null && string4.length() > 0 ? (string4.charAt(string4.length() - 1) == ',' ? string4 + DNMapper.serviceDN : ((n = string4.indexOf(",")) >= 0 ? string4 + "," + DNMapper.serviceDN : string4 + "," + string2)) : string2;
        } else {
            string3 = string.startsWith("sunamhiddenrealm") ? "o=" + string + "," + DNMapper.serviceDN : (coexistMode ? orgNamingAttrInLegacyMode + "=" + string + "," + DNMapper.realmNameToAMSDKName(string2) : "o=" + string + "," + string2);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager::normalizeDN() suborgdn " + string3);
        }
        return string3;
    }

    static Set getServiceNames(SSOToken sSOToken) throws SMSException, SSOException {
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(sSOToken, DNMapper.serviceDN);
        return cachedSubEntries.getSubEntries(sSOToken);
    }

    public Set getAssignableServices() throws SMSException {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            object = OrganizationConfigManager.getServiceNames(this.token).iterator();
            while (object.hasNext()) {
                String string;
                String string2 = (String)object.next();
                ServiceSchemaManagerImpl serviceSchemaManagerImpl = ServiceSchemaManagerImpl.getInstance(this.token, string2, string = ServiceManager.serviceDefaultVersion(this.token, string2));
                if (serviceSchemaManagerImpl.getSchema(SchemaType.ORGANIZATION) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("ou").append("=").append("default").append(",").append("ou=OrganizationConfig,").append("ou").append("=").append(string).append(",").append("ou").append("=");
                stringBuffer.append(string2);
                if (!this.orgDN.equalsIgnoreCase(DNMapper.serviceDN)) {
                    stringBuffer.append(",").append("services");
                }
                stringBuffer.append(",").append(this.orgDN);
                try {
                    SMSEntry.getDelegationPermission(this.token, stringBuffer.toString(), SMSEntry.modifyActionSet);
                    hashSet.add(string2);
                }
                catch (SMSException sMSException) {
                    if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) continue;
                    throw sMSException;
                }
            }
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager.getAssignableServices(): SSOException", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        object = new HashSet(hashSet);
        ((AbstractSet)object).removeAll(this.getAssignedServices());
        return object;
    }

    public Set getAssignedServices() throws SMSException {
        return this.getAssignedServices(true);
    }

    public Set getAssignedServices(boolean bl) throws SMSException {
        Set set = Collections.EMPTY_SET;
        set = coexistMode ? this.amsdk.getAssignedServices() : this.orgConfigImpl.getAssignedServices(this.token);
        if (!bl) {
            // empty if block
        }
        return set;
    }

    public void assignService(String string, Map map) throws SMSException {
        this.addServiceConfig(string, map);
    }

    public Map getServiceAttributes(String string) throws SMSException {
        ServiceConfig serviceConfig = this.getServiceConfig(string);
        if (serviceConfig == null) {
            Object[] objectArray = new Object[]{string};
            SMSEntry.debug.error("OrganizationConfigManager.getServiceAttributes() Unable to get service attributes. ");
            throw new SMSException("amSDK", SMSEntry.bundle.getString("sms-no-organization-schema"), objectArray);
        }
        return serviceConfig.getAttributes();
    }

    public void unassignService(String string) throws SMSException {
        this.removeServiceConfig(string);
    }

    public void modifyService(String string, Map map) throws SMSException {
        try {
            this.getServiceConfig(string).setAttributes(map);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager.modifyService SSOException in modify service ", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public String getNamingAttrForOrg() {
        return OrgConfigViaAMSDK.getNamingAttrForOrg();
    }

    public OrganizationConfigManager getParentOrgConfigManager() throws SMSException {
        OrganizationConfigManager organizationConfigManager = null;
        String string = null;
        if (DN.isDN(this.orgDN)) {
            if (this.orgDN.equalsIgnoreCase(DNMapper.serviceDN)) {
                return this;
            }
            string = new DN(this.orgDN).getParent().toString();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager.getParentOrgConfigManager() parentDN : " + string);
            }
            if (string != null && string.length() > 0) {
                organizationConfigManager = new OrganizationConfigManager(this.token, string);
            }
        }
        return organizationConfigManager;
    }

    public static void loadDefaultServices(SSOToken sSOToken, OrganizationConfigManager organizationConfigManager) throws SMSException {
        block19: {
            if (!migratedTo70) {
                return;
            }
            Set set = ServiceManager.servicesAssignedByDefault();
            OrganizationConfigManager organizationConfigManager2 = organizationConfigManager.getParentOrgConfigManager();
            if (set == null) {
                return;
            }
            Set set2 = organizationConfigManager2.getAssignedServices();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices assignedServices : " + set2);
            }
            boolean bl = false;
            String string = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() || bl) {
                if (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (string.equals("iPlanetAMAuthService")) {
                        bl = true;
                        continue;
                    }
                } else if (bl) {
                    string = "iPlanetAMAuthService";
                    bl = false;
                }
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("ServiceName : " + string);
                }
                try {
                    ServiceConfig serviceConfig = organizationConfigManager2.getServiceConfig(string);
                    Map map = null;
                    if (serviceConfig == null || !set2.contains(string)) continue;
                    map = serviceConfig.getAttributesWithoutDefaults();
                    if (SMSEntry.debug.messageEnabled()) {
                        SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices Copying service from parent: " + string);
                    }
                    ServiceConfig serviceConfig2 = organizationConfigManager.addServiceConfig(string, map);
                    OrganizationConfigManager.copySubConfig(serviceConfig, serviceConfig2);
                }
                catch (SSOException sSOException) {
                    if (SMSEntry.debug.messageEnabled()) {
                        SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices SSOException in loading default services ", sSOException);
                    }
                    throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
                }
            }
            try {
                if (coexistMode) {
                    DelegationUtils.createRealmPrivileges((SSOToken)sSOToken, (String)organizationConfigManager.getOrganizationName());
                } else {
                    DelegationUtils.copyRealmPrivilegesFromParent((SSOToken)sSOToken, (OrganizationConfigManager)organizationConfigManager2, (OrganizationConfigManager)organizationConfigManager);
                }
            }
            catch (SSOException sSOException) {
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices SSOException in copying permissions ", sSOException);
                }
            }
            catch (DelegationException delegationException) {
                if (!SMSEntry.debug.messageEnabled()) break block19;
                SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices DelegationException in copying permission ", delegationException);
            }
        }
    }

    static void copySubConfig(ServiceConfig serviceConfig, ServiceConfig serviceConfig2) throws SMSException, SSOException {
        Set set = serviceConfig.getSubConfigNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ServiceConfig serviceConfig3 = serviceConfig.getSubConfig(string);
            serviceConfig2.addSubConfig(string, serviceConfig3.getSchemaID(), serviceConfig3.getPriority(), serviceConfig3.getAttributesWithoutDefaults());
            ServiceConfig serviceConfig4 = serviceConfig2.getSubConfig(string);
            OrganizationConfigManager.copySubConfig(serviceConfig3, serviceConfig4);
        }
    }

    static {
        SERVICES_NODE = "ou=services," + SMSEntry.baseDN;
        realmEnabled = ServiceManager.isRealmEnabled();
        coexistMode = ServiceManager.isCoexistenceMode();
        migratedTo70 = ServiceManager.isConfigMigratedTo70();
    }

    class OrganizationConfigManagerListener
    implements ServiceListener {
        OrganizationConfigManagerListener() {
        }

        public void schemaChanged(String string, String string2) {
            serviceSchemaSet = null;
            ServiceManager.schemaChanged();
            if (string.equalsIgnoreCase("iPlanetAMPlatformService")) {
                ServiceManager.accessManagerServers = null;
            }
        }

        public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
            if (string.equalsIgnoreCase("sunidentityrepositoryservice")) {
                try {
                    ServiceManager.checkFlags(OrganizationConfigManager.this.token);
                }
                catch (SSOException sSOException) {
                    SMSEntry.debug.error("OrganizationConfigManager: globalConfigChanged ", sSOException);
                }
                catch (SMSException sMSException) {
                    SMSEntry.debug.error("OrganizationConfigManager: globalConfigChanged ", sMSException);
                }
                realmEnabled = ServiceManager.isRealmEnabled();
                coexistMode = ServiceManager.isCoexistenceMode();
                migratedTo70 = ServiceManager.isConfigMigratedTo70();
            }
        }

        public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
            if (string.equalsIgnoreCase("sunidentityrepositoryservice")) {
                OrgConfigViaAMSDK.attributeMappings = new HashMap();
                OrgConfigViaAMSDK.reverseAttributeMappings = new HashMap();
            }
        }
    }
}

