/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class CachedSMSEntry {
    private static final String cachedSMSEntriesMutex = "CachedSMSEntriesMutex";
    protected static final String UPDATE_NOTIFY_METHOD = "updateAndNotifyListeners";
    protected static final String UPDATE_METHOD = "update";
    protected static Map smsEntries = new CaseInsensitiveHashMap(1000);
    protected Set serviceObjects;
    protected Set principals;
    protected SSOToken token;
    protected String dnRFCStr;
    protected SMSEntry smsEntry;
    protected String notificationID = null;
    private boolean valid = false;

    private CachedSMSEntry(SMSEntry sMSEntry) {
        this.smsEntry = sMSEntry;
        DN dN = new DN(sMSEntry.getDN());
        this.dnRFCStr = dN.toRFCString();
        this.serviceObjects = new HashSet();
        this.token = sMSEntry.getSSOToken();
        this.principals = new HashSet();
        this.addPrincipal(this.token);
        this.valid = true;
        this.smsEntry.setReadOnly();
        try {
            Class<?> clazz = this.getClass();
            this.notificationID = SMSEventListenerManager.notifyChangesToNode(this.token, this.smsEntry.getDN(), clazz.getDeclaredMethod(UPDATE_METHOD, null), this, null);
        }
        catch (Exception exception) {
            SMSEntry.debug.error("CachedSMSEntry: unable to add listener for " + sMSEntry.getDN(), exception);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: create new instance: " + this.dnRFCStr);
        }
    }

    boolean isValid() {
        return this.valid;
    }

    void update() {
        block14: {
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("CachedSMSEntry: update method called: " + this.dnRFCStr);
            }
            try {
                SSOToken sSOToken = this.getValidSSOToken();
                if (sSOToken != null) {
                    this.smsEntry.read(sSOToken);
                    this.updateServiceListeners(UPDATE_NOTIFY_METHOD);
                    break block14;
                }
                String string = cachedSMSEntriesMutex;
                synchronized (string) {
                    smsEntries.remove(this.dnRFCStr);
                }
                SMSEventListenerManager.removeNotification(this.notificationID);
                this.notificationID = null;
                this.valid = false;
            }
            catch (SMSException sMSException) {
                SMSEntry.debug.error("Error in reading entry attributes: " + this.dnRFCStr, sMSException);
                String string = cachedSMSEntriesMutex;
                synchronized (string) {
                    smsEntries.remove(this.dnRFCStr);
                }
                SMSEventListenerManager.removeNotification(this.notificationID);
                this.notificationID = null;
                this.valid = false;
            }
            catch (SSOException sSOException) {
                SMSEntry.debug.error("SSOToken problem in reading entry attributes: " + this.dnRFCStr, sSOException);
                String string = cachedSMSEntriesMutex;
                synchronized (string) {
                    smsEntries.remove(this.dnRFCStr);
                }
                SMSEventListenerManager.removeNotification(this.notificationID);
                this.notificationID = null;
                this.valid = false;
            }
        }
    }

    SSOToken getValidSSOToken() {
        if (!SMSEntry.tm.isValidToken(this.token)) {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = this.principals.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                try {
                    this.token = SMSEntry.tm.createSSOToken((String)object);
                    if (!SMSEntry.tm.isValidToken(this.token)) continue;
                    break;
                }
                catch (SSOException sSOException) {
                    hashSet.add(object);
                }
            }
            if (!hashSet.isEmpty()) {
                object = new HashSet(this.principals);
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    object.remove(iterator2.next());
                }
                this.principals = object;
            }
        }
        if (this.principals.isEmpty()) {
            return null;
        }
        return this.token;
    }

    void updateServiceListeners(String string) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::updateServiceListeners method called: " + this.dnRFCStr);
        }
        Iterator iterator = this.serviceObjects.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                Method method = e.getClass().getDeclaredMethod(string, null);
                method.invoke(e, null);
            }
            catch (Exception exception) {
                SMSEntry.debug.error("CachedSMSEntry::unable to deliver notification(" + this.dnRFCStr + ")", exception);
            }
        }
    }

    void addServiceListener(Object object) {
        if (this.notificationID == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.identity.sm.CachedSMSEntry");
                SSOToken sSOToken = this.getValidSSOToken();
                if (sSOToken == null) {
                    return;
                }
                this.notificationID = SMSEventListenerManager.notifyChangesToNode(sSOToken, this.smsEntry.getDN(), clazz.getDeclaredMethod(UPDATE_METHOD, null), this, null);
            }
            catch (Exception exception) {
                SMSEntry.debug.error("CachedSMSEntry::unable to register service objects for notifications: ", exception);
            }
        }
        this.serviceObjects.add(object);
    }

    protected void removeServiceListener(Object object) {
        this.serviceObjects.remove(object);
        if (this.serviceObjects.isEmpty()) {
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
        }
    }

    synchronized void addPrincipal(SSOToken sSOToken) {
        HashSet<String> hashSet = new HashSet<String>(this.principals);
        hashSet.add(sSOToken.getTokenID().toString());
        this.principals = hashSet;
    }

    boolean checkPrincipal(SSOToken sSOToken) {
        return this.principals.contains(sSOToken.getTokenID().toString());
    }

    public SMSEntry getSMSEntry() {
        return this.smsEntry;
    }

    public SMSEntry getClonedSMSEntry() {
        try {
            return (SMSEntry)this.smsEntry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            SMSEntry.debug.error("Unable to clone SMSEntry: " + this.smsEntry, cloneNotSupportedException);
            return null;
        }
    }

    boolean isNewEntry() {
        return this.smsEntry.isNewEntry();
    }

    String getDN() {
        return this.dnRFCStr;
    }

    void refresh(SMSEntry sMSEntry) throws SMSException {
        this.smsEntry.refresh(sMSEntry);
        this.updateServiceListeners(UPDATE_METHOD);
    }

    static CachedSMSEntry getInstance(SSOToken sSOToken, ServiceSchemaManagerImpl serviceSchemaManagerImpl, String string, String string2) throws SMSException {
        String string3 = ServiceManager.getServiceNameDN(string, string2);
        try {
            return CachedSMSEntry.getInstance(sSOToken, string3, serviceSchemaManagerImpl);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("SMS: Invalid SSOToken: ", sSOException);
            return null;
        }
    }

    public static CachedSMSEntry getInstance(SSOToken sSOToken, String string, Object object) throws SMSException, SSOException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance: " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        CachedSMSEntry cachedSMSEntry = null;
        String string3 = cachedSMSEntriesMutex;
        synchronized (string3) {
            cachedSMSEntry = (CachedSMSEntry)smsEntries.get(string2);
            if (cachedSMSEntry == null) {
                cachedSMSEntry = new CachedSMSEntry(new SMSEntry(sSOToken, string));
                smsEntries.put(string2, cachedSMSEntry);
            }
        }
        if (!cachedSMSEntry.checkPrincipal(sSOToken)) {
            new SMSEntry(sSOToken, string);
            cachedSMSEntry.addPrincipal(sSOToken);
        }
        if (object != null) {
            cachedSMSEntry.addServiceListener(object);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance success: " + string);
        }
        if (cachedSMSEntry.isNewEntry()) {
            SMSEntry sMSEntry = cachedSMSEntry.getSMSEntry();
            sMSEntry.dn = string;
        }
        return cachedSMSEntry;
    }

    static void clearCache() {
        Map map = smsEntries;
        String string = cachedSMSEntriesMutex;
        synchronized (string) {
            smsEntries = new CaseInsensitiveHashMap();
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            CachedSMSEntry cachedSMSEntry = (CachedSMSEntry)map.get((String)iterator.next());
            cachedSMSEntry.valid = false;
        }
    }

    String getXMLSchema() {
        String[] stringArray = this.smsEntry.getAttributeValues("sunServiceSchema");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    void writeXMLSchema(SSOToken sSOToken, InputStream inputStream) throws SSOException, SMSException, IOException {
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        this.writeXMLSchema(sSOToken, new String(byArray));
    }

    void writeXMLSchema(SSOToken sSOToken, String string) throws SSOException, SMSException {
        SMSEntry.validateToken(sSOToken);
        String[] stringArray = new String[]{string};
        SMSEntry sMSEntry = this.getClonedSMSEntry();
        sMSEntry.setAttribute("sunServiceSchema", stringArray);
        sMSEntry.save(sSOToken);
        this.refresh(sMSEntry);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::writeXMLSchema: successfully wrote the XML schema for dn: " + sMSEntry.getDN());
        }
    }
}

