/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.AppSSOTokenProvider;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SystemAppTokenProvider
implements AppSSOTokenProvider {
    private static final String MODULE_APPLICATION = "Application";
    private String appUserName;
    private String appPassword;

    public SystemAppTokenProvider(String string, String string2) {
        this.appUserName = string;
        this.appPassword = string2;
    }

    public SSOToken getAppSSOToken() {
        SSOToken sSOToken = null;
        try {
            Callback[] callbackArray;
            AuthContext authContext = new AuthContext("/");
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, MODULE_APPLICATION);
            if (authContext.hasMoreRequirements() && (callbackArray = authContext.getRequirements()) != null) {
                this.addLoginCallbackMessage(callbackArray, this.appUserName, this.appPassword);
                authContext.submitRequirements(callbackArray);
            }
            if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                sSOToken = authContext.getSSOToken();
            }
        }
        catch (AuthLoginException authLoginException) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", authLoginException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", unsupportedCallbackException);
        }
        catch (Exception exception) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", exception);
        }
        return sSOToken;
    }

    private void addLoginCallbackMessage(Callback[] callbackArray, String string, String string2) throws UnsupportedCallbackException {
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback;
            if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                ((NameCallback)callback).setName(string);
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                ((PasswordCallback)callback).setPassword(string2.toCharArray());
            }
            ++n;
        }
    }
}

