/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AppSSOTokenProvider;
import com.sun.identity.security.SystemAppTokenProvider;
import java.security.Principal;
import java.security.PrivilegedAction;

public class AdminTokenAction
implements PrivilegedAction {
    private static SSOTokenManager tokenManager;
    private static SSOToken appSSOToken;
    private static AdminTokenAction instance;
    private static boolean authInitialized;
    static Debug debug;
    static final String ADMIN_TOKEN_PROVIDER = "com.sun.identity.security.AdminToken";
    static final String APP_USERNAME = "com.sun.identity.agents.app.username";
    static final String APP_SECRET = "com.iplanet.am.service.secret";
    static final String APP_PASSWORD = "com.iplanet.am.service.password";
    public static final String AMADMIN_MODE = "com.sun.identity.security.amadmin";

    public static AdminTokenAction getInstance() {
        if (instance == null) {
            instance = new AdminTokenAction();
        }
        return instance;
    }

    public AdminTokenAction() {
        if (tokenManager == null) {
            try {
                tokenManager = SSOTokenManager.getInstance();
            }
            catch (SSOException sSOException) {
                debug.error("AdminTokenAction::init Unable to get SSOTokenManager", sSOException);
            }
        }
    }

    public void authenticationInitialized() {
        authInitialized = true;
        appSSOToken = AdminTokenAction.getSSOToken();
        if (debug.messageEnabled()) {
            debug.message("AdminTokenAction:authenticationInit called. AppSSOToken className=" + (appSSOToken == null ? "null" : appSSOToken.getClass().getName()));
        }
    }

    public Object run() {
        SSOToken sSOToken;
        block19: {
            String string;
            String string2;
            block20: {
                String string3;
                if (appSSOToken != null && tokenManager.isValidToken(appSSOToken)) {
                    return appSSOToken;
                }
                sSOToken = AdminTokenAction.getSSOToken();
                if (sSOToken != null) {
                    if (!WebtopNaming.isServerMode() || authInitialized) {
                        appSSOToken = sSOToken;
                    }
                    return sSOToken;
                }
                if (debug.messageEnabled()) {
                    debug.message("AdminTokenAction::run Unable to get SSOToken  from serverconfig.xml");
                }
                if ((string3 = SystemProperties.get(ADMIN_TOKEN_PROVIDER)) != null) {
                    try {
                        AppSSOTokenProvider appSSOTokenProvider = (AppSSOTokenProvider)Class.forName(string3).newInstance();
                        sSOToken = appSSOTokenProvider.getAppSSOToken();
                    }
                    catch (Throwable throwable) {
                        if (debug.warningEnabled()) {
                            debug.warning("AdminTokenAction: Exception while calling appSSOToken provider plugin.", throwable);
                        }
                        break block19;
                    }
                }
                string2 = SystemProperties.get(APP_USERNAME);
                String string4 = SystemProperties.get(APP_SECRET);
                String string5 = SystemProperties.get(APP_PASSWORD);
                string = null;
                if (string5 != null && !string5.equals("")) {
                    string = string5;
                } else if (string4 != null && !string4.equals("")) {
                    try {
                        string = Crypt.decode(string4);
                    }
                    catch (Throwable throwable) {
                        if (!debug.messageEnabled()) break block20;
                        debug.message("AdminTokenAction::run Unable to  decrypt secret password", throwable);
                    }
                }
            }
            if (string2 == null || string2.length() == 0 || string == null || string.length() == 0) {
                debug.message("AdminTokenAction: App user name or password is empty");
            } else {
                if (debug.messageEnabled()) {
                    debug.message("App user name: " + string2);
                }
                SystemAppTokenProvider systemAppTokenProvider = new SystemAppTokenProvider(string2, string);
                sSOToken = systemAppTokenProvider.getAppSSOToken();
            }
        }
        if (sSOToken == null) {
            debug.error("AdminTokenAction: FATAL ERROR: Cannot obtain Application SSO token.\nCheck AMConfig.properties for the following properties\n\tcom.sun.identity.agents.app.username\n\tcom.iplanet.am.service.password");
        } else if (!WebtopNaming.isServerMode() || authInitialized) {
            appSSOToken = sSOToken;
        }
        return sSOToken;
    }

    private static SSOToken getSSOToken() {
        SSOToken sSOToken;
        block9: {
            sSOToken = null;
            try {
                if (AdminUtils.getAdminPassword() != null) {
                    String string = AdminUtils.getAdminDN();
                    String string2 = new String(AdminUtils.getAdminPassword());
                    if (!authInitialized && (WebtopNaming.isServerMode() || SystemProperties.get(AMADMIN_MODE) != null)) {
                        AuthContext authContext = new AuthContext((Principal)new AuthPrincipal(string), string2.toCharArray());
                        sSOToken = authContext.getSSOToken();
                    } else {
                        boolean bl = authInitialized;
                        if (bl) {
                            authInitialized = false;
                        }
                        sSOToken = new SystemAppTokenProvider(string, string2).getAppSSOToken();
                        if (bl && sSOToken != null) {
                            authInitialized = true;
                        }
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (debug.messageEnabled()) {
                    debug.message("AdminTokenAction::getSSOToken Not found AdminDN and AdminPassword.", noClassDefFoundError);
                }
            }
            catch (Throwable throwable) {
                if (!debug.messageEnabled()) break block9;
                debug.message("AdminTokenAction::getSSOToken Exception reading from serverconfig.xml", throwable);
            }
        }
        return sSOToken;
    }

    static {
        debug = Debug.getInstance("amSecurity");
    }
}

