/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public abstract class AbstractRequest {
    protected List respondWiths = Collections.EMPTY_LIST;
    protected Element signature = null;
    protected String requestID = null;
    protected int majorVersion = 1;
    protected int minorVersion = SAMLConstants.PROTOCOL_MINOR_VERSION;
    protected Date issueInstant = null;
    protected boolean signed = false;
    protected boolean valid = true;

    protected AbstractRequest() {
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return this.valid;
    }

    public abstract void signXML() throws SAMLException;

    public List getRespondWith() {
        return this.respondWiths;
    }

    public boolean addRespondWith(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        if (this.respondWiths == null || this.respondWiths == Collections.EMPTY_LIST) {
            this.respondWiths = new ArrayList();
        }
        this.respondWiths.add(string);
        return true;
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element element) {
        if (this.signed) {
            return false;
        }
        if (element == null) {
            return false;
        }
        this.signature = element;
        this.signed = true;
        return true;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public boolean setRequestID(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        this.requestID = string;
        return true;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public boolean setIssueInstant(Date date) {
        if (this.signed) {
            return false;
        }
        if (date == null) {
            return false;
        }
        this.issueInstant = date;
        return true;
    }
}

