/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.sun.identity.saml.common.SAMLConstants;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SAMLUtilsCommon {
    public static SecureRandom random = new SecureRandom();
    public static final String SAMLID_PREFIX = "s";
    public static SAMLConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;
    private static final String UTC_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String UTC_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.S'Z'";
    private static final String PST_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String PST_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.sz";
    private static TimeZone UTC_TIME_ZONE;

    public static void setResourceBundle(ResourceBundle resourceBundle) {
        bundle = resourceBundle;
    }

    public static void setDebugInstance(Debug debug) {
        SAMLUtilsCommon.debug = debug;
    }

    public static String generateAssertionID() {
        return SAMLUtilsCommon.generateID();
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        String string = SAMLID_PREFIX + SAMLUtilsCommon.byteArrayToHexString(byArray);
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.generated ID is: " + string);
        }
        return string;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = 0xFF & byArray[i] | 0xFFFFFF00;
            stringBuffer.append(Integer.toHexString(n2).substring(6));
        }
        return stringBuffer.toString();
    }

    public static String makeEndElementTagXML(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string2 = "";
        if (bl) {
            string2 = "saml:";
        }
        stringBuffer.append("</").append(string2).append(string).append(">").append("\n");
        return stringBuffer.toString();
    }

    public static String makeStartElementTagXML(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string2 = "";
        String string3 = "";
        if (bl) {
            string2 = "saml:";
        }
        if (bl2) {
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string2).append(string).append(string3).append(">");
        return stringBuffer.toString();
    }

    public static boolean checkStatement(Element element, String string) {
        String string2 = element.getLocalName();
        if (string2 == null) {
            return false;
        }
        if (string2.equals("Statement") || string2.equals("SubjectStatement")) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            String string3 = null;
            Attr attr = null;
            for (int i = 0; i < n; ++i) {
                attr = (Attr)namedNodeMap.item(i);
                string3 = attr.getLocalName();
                if (string3 == null || !string3.equals("type") || !attr.getNodeValue().equals(string + "Type")) continue;
                return true;
            }
        } else if (string2.equals(string)) {
            return true;
        }
        return false;
    }

    private static TimeZone getTimeZone(String string) throws ParseException {
        TimeZone timeZone = null;
        int n = -1;
        if (string.indexOf(90) != -1) {
            timeZone = UTC_TIME_ZONE;
        } else {
            int n2;
            n = string.indexOf(43);
            if (n != -1) {
                Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                int n3 = gregorianCalendar.get(11) * 60 * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000;
                return new SimpleTimeZone(n3, "UTC");
            }
            n = string.lastIndexOf(45);
            if (n != -1 && n > (n2 = string.indexOf(84))) {
                Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                int n4 = -1 * (gregorianCalendar.get(11) * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000);
                return new SimpleTimeZone(n4, "UTC");
            }
        }
        return timeZone;
    }

    static {
        bundle = Locale.getInstallResourceBundle("amSAML");
        debug = Debug.getInstance("amSAML");
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    }
}

