/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SAMLCertUtils {
    private static Map certdbCerts;

    public static CertEntry getMatchingCertEntry(X509Certificate x509Certificate) {
        String string = x509Certificate.getIssuerDN().getName().trim();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        Iterator iterator = certdbCerts.entrySet().iterator();
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Found " + certdbCerts.entrySet().size() + " jks certs");
        }
        while (iterator.hasNext()) {
            CertEntry certEntry = (CertEntry)iterator.next().getValue();
            if (!string.equals(certEntry.getIssuerDN().getName()) || !bigInteger.equals(certEntry.getSerialNumber())) continue;
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Matching cert found.");
            }
            return certEntry;
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Matching cert not found.");
        }
        return null;
    }

    static {
        KeyStore keyStore;
        JKSKeyProvider jKSKeyProvider;
        certdbCerts = Collections.synchronizedMap(new HashMap());
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Start loading certs from jks key store");
        }
        if ((jKSKeyProvider = new JKSKeyProvider()) != null && (keyStore = jKSKeyProvider.getKeyStore()) != null) {
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                    CertEntry certEntry = new CertEntry(string, x509Certificate.getIssuerDN(), x509Certificate.getSerialNumber());
                    certdbCerts.put(string, certEntry);
                }
            }
            catch (KeyStoreException keyStoreException) {
                SAMLUtilsCommon.debug.error("Key store has problem.", keyStoreException);
            }
        }
    }

    public static class CertEntry {
        private String nickName = null;
        private Principal issuerDN = null;
        private BigInteger serialNumber;

        public CertEntry(String string, Principal principal, BigInteger bigInteger) {
            this.nickName = string;
            this.issuerDN = principal;
            this.serialNumber = bigInteger;
        }

        public String getNickName() {
            return this.nickName;
        }

        public Principal getIssuerDN() {
            return this.issuerDN;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }
}

