/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.AdviceBase;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatementBase;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Assertion
extends AssertionBase {
    public boolean isSignatureValid() {
        if (this.signed & !this.validationDone) {
            this.valid = SAMLUtils.checkSignatureValid(this.xmlString, "AssertionID", this._issuer);
            this.validationDone = true;
        }
        return this.valid;
    }

    public void signXML() throws SAMLException {
        String string = SystemProperties.get("com.sun.identity.saml.xmlsig.certalias");
        this.signXML(string);
    }

    public void signXML(String string) throws SAMLException {
        if (this.signed) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion.signXML: the assertion is already signed.");
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("alreadySigned"));
        }
        if (string == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assetion.signXML: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(SAMLUtilsCommon.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        if (this._majorVersion == 1 && this._minorVersion == 0) {
            SAMLUtilsCommon.debug.message("Assetion.signXML: sign with version 1.0");
            this.signatureString = xMLSignatureManager.signXML(this.toString(true, true), string);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, SAMLUtilsCommon.debug).getDocumentElement();
        } else {
            SAMLUtilsCommon.debug.message("Assetion.signXML: sign with version 1.1");
            Document document = XMLUtils.toDOMDocument(this.toString(true, true), SAMLUtilsCommon.debug);
            this.signature = xMLSignatureManager.signXML(document, string, null, "AssertionID", this.getAssertionID(), true, null);
            this.signatureString = XMLUtils.print(this.signature);
        }
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    protected Assertion() {
    }

    public Assertion(Element element) throws SAMLException {
        this.parseAssertionElement(element);
    }

    protected void parseAssertionElement(Element element) throws SAMLException {
        Element element2;
        String string;
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Assertion.parseAssertionElement:");
        }
        if ((string = (element2 = element).getLocalName()) == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!string.equals("Assertion")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + string);
        }
        String string2 = element2.getAttribute("Issuer");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "Issuer");
        }
        this._issuer = string2;
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
            this.validationDone = false;
        } else if (n != 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
        string2 = element2.getAttribute("MajorVersion");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MajorVersion", numberFormatException);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (n2 != 1) {
            if (n2 < 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (n2 > 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
        }
        if ((string2 = element2.getAttribute("MinorVersion")) == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MinorVersion", numberFormatException);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Assertion.parseAssertionElement: minMinorVersion = " + this.getMinAssertionMinorVersion() + ", maxMinorVersion = " + this.getMaxAssertionMinorVersion());
        }
        if (n2 < this.getMinAssertionMinorVersion()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too low");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow"));
        }
        if (n2 > this.getMaxAssertionMinorVersion()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too high");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
        }
        this._minorVersion = n2;
        string2 = element2.getAttribute("AssertionID");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "AssertionID");
        }
        this._assertionID = new AssertionIDReference(string2);
        string2 = element2.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = DateUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: could not parse IssueInstant", parseException);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput") + " " + parseException.getMessage());
        }
        NodeList nodeList = element.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Node node = nodeList.item(n4);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3.equals("Conditions")) {
                    this._conditions = new Conditions((Element)node);
                } else if (string3.equals("Advice")) {
                    this._advice = new Advice((Element)node);
                } else if (string3.equals("AuthenticationStatement")) {
                    this._statements.add(new AuthenticationStatement((Element)node));
                } else if (string3.equals("AuthorizationDecisionStatement")) {
                    this._statements.add(new AuthorizationDecisionStatement((Element)node));
                } else if (string3.equals("AttributeStatement")) {
                    this._statements.add(new AttributeStatement((Element)node));
                } else if (string3.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (!this.processUnknownElement((Element)node)) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Assertion: invalid element in Assertion");
                    }
                    throw new SAMLRequesterException("invalidElement");
                }
            }
            ++n4;
        }
        if (this._statements.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public Assertion(String string, String string2, Date date, Set set) throws SAMLException {
        super(string, string2, date, set);
    }

    public Assertion(String string, String string2, Date date, Conditions conditions, Set set) throws SAMLException {
        super(string, string2, date, conditions, set);
    }

    public Assertion(String string, String string2, Date date, Conditions conditions, Advice advice, Set set) throws SAMLException {
        super(string, string2, date, conditions, advice, set);
    }

    public Advice getAdvice() {
        return (Advice)this._advice;
    }

    protected AdviceBase createAdvice(Element element) throws SAMLException {
        return new Advice(element);
    }

    protected AuthorizationDecisionStatementBase createAuthorizationDecisionStatement(Element element) throws SAMLException {
        return new AuthorizationDecisionStatement(element);
    }

    protected AuthenticationStatement createAuthenticationStatement(Element element) throws SAMLException {
        return new AuthenticationStatement(element);
    }

    protected AttributeStatement createAttributeStatement(Element element) throws SAMLException {
        return new AttributeStatement(element);
    }

    protected AssertionIDReference createAssertionIDReference(Element element) throws SAMLException {
        return new AssertionIDReference(element);
    }

    protected AssertionIDReference createAssertionIDReference(String string) throws SAMLException {
        return new AssertionIDReference(string);
    }

    protected Conditions createConditions(Element element) throws SAMLException {
        return new Conditions(element);
    }

    protected boolean processUnknownElement(Element element) throws SAMLException {
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Assertion.processUnknownElement:");
        }
        return false;
    }

    protected int getMinAssertionMinorVersion() {
        return 0;
    }

    protected int getMaxAssertionMinorVersion() {
        return 1;
    }
}

