/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOToken;
import com.sun.identity.jaxrpc.JAXRPCUtil;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class AssertionManagerClient {
    private static String SERVICE_NAME = "samlassertionmanager";
    static boolean checkedForLocal;
    static boolean isLocal;
    private boolean useLocal;
    private static SOAPClient remoteStub;
    private static AssertionManager assertionManager;
    private SOAPClient stub;

    public AssertionManagerClient() throws SAMLException {
        if (!checkedForLocal) {
            try {
                remoteStub = AssertionManagerClient.getServiceEndPoint(SystemProperties.get("com.iplanet.am.server.protocol"), SystemProperties.get("com.iplanet.am.server.host"), SystemProperties.get("com.iplanet.am.server.port"));
                remoteStub.send("checkForLocal", null, null);
                if (isLocal) {
                    SAMLUtilsCommon.debug.warning("AMC(): Using local service");
                    assertionManager = AssertionManager.getInstance();
                }
                checkedForLocal = true;
            }
            catch (Exception exception) {
                if (SAMLUtilsCommon.debug.warningEnabled()) {
                    SAMLUtilsCommon.debug.warning("AssertionManagerClient()Exception", exception);
                }
                throw new SAMLException(exception.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
        }
    }

    public AssertionManagerClient(String string) throws SAMLException {
        try {
            String[] stringArray = new String[]{string};
            this.stub = new SOAPClient(stringArray);
            this.useLocal = false;
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AssertionManagerClient() Exception", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public AssertionManagerClient(String[] stringArray) throws SAMLException {
        try {
            this.stub = new SOAPClient(stringArray);
            this.useLocal = false;
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AssertionManagerClient() Exception", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    private static SOAPClient getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL(SERVICE_NAME, string, string2, string3);
        String string4 = uRL.toString();
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("AssertionManagerClient with URL: " + string4);
        }
        String[] stringArray = new String[]{string4};
        return new SOAPClient(stringArray);
    }

    private static SOAPClient getRemoteStub() throws SAMLException {
        SOAPClient sOAPClient = null;
        try {
            URL uRL = new URL(JAXRPCUtil.getValidURL(SERVICE_NAME));
            sOAPClient = AssertionManagerClient.getServiceEndPoint(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
            sOAPClient.send("checkForLocal", null, null);
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getRemoteStub: generic error: ", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
        return sOAPClient;
    }

    public Assertion createAssertion(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(sSOToken);
        }
        String string = null;
        try {
            string = (String)this.stub.send("createAssertion", sSOToken.getTokenID().toString(), null);
            return new Assertion(XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:createAssertion(SSO)", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Assertion createAssertion(SSOToken sSOToken, List list) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(sSOToken, list);
        }
        if (list == null || list.isEmpty()) {
            return this.createAssertion(sSOToken);
        }
        String string = null;
        try {
            Object[] objectArray;
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                linkedList.add(objectArray.toString(true, true));
            }
            objectArray = new Object[]{sSOToken.getTokenID().toString(), linkedList};
            string = (String)this.stub.send("createAssertion", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:createAssertion(SSO, attrs)", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public AssertionArtifact createAssertionArtifact(Assertion assertion, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertionArtifact(assertion, string);
        }
        String string2 = null;
        try {
            Object[] objectArray = new Object[]{assertion.toString(true, true), Base64.encode(SAMLUtils.stringToByteArray(string))};
            string2 = (String)this.stub.send("createAssertionArtifact", objectArray, (String)null);
            return new AssertionArtifact(string2);
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:createAssertionArtifact:", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, Set set) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, set);
        }
        String string = null;
        try {
            Object[] objectArray;
            HashSet<String> hashSet = new HashSet<String>();
            if (set != null && !set.isEmpty()) {
                objectArray = set.iterator();
                while (objectArray.hasNext()) {
                    hashSet.add(Base64.encode(SAMLUtils.stringToByteArray((String)objectArray.next())));
                }
            }
            objectArray = new Object[]{assertionIDReference.getAssertionIDReference(), hashSet};
            string = (String)this.stub.send("getAssertionByIdRef", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertion: " + assertionIDReference, exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, string);
        }
        String string2 = null;
        try {
            if (string == null || string.equals("")) {
                string = " ";
            }
            Object[] objectArray = new Object[]{assertionIDReference.getAssertionIDReference(), Base64.encode(SAMLUtils.stringToByteArray(string))};
            string2 = (String)this.stub.send("getAssertionByIdRef", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string2, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertion: " + assertionIDReference, exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, Set set) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionArtifact, set);
        }
        String string = null;
        try {
            if (set == null || set.isEmpty()) {
                SAMLUtilsCommon.debug.error("AssertionManagerClient:getAssertion(AssertionArtifact, Set): destID set is null");
                throw new SAMLException("nullInput");
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(Base64.encode(SAMLUtils.stringToByteArray((String)iterator.next())));
            }
            Object[] objectArray = new Object[]{assertionArtifact.getAssertionArtifact(), hashSet};
            string = (String)this.stub.send("getAssertion", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertion: " + assertionArtifact, exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    protected Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionArtifact, string);
        }
        String string2 = null;
        try {
            Object[] objectArray = new Object[]{assertionArtifact.getAssertionArtifact(), Base64.encode(SAMLUtils.stringToByteArray(string))};
            string2 = (String)this.stub.send("getAssertion", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string2, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertion: " + assertionArtifact, exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, sSOToken);
        }
        String string = null;
        try {
            Object[] objectArray = new Object[]{assertionIDReference.getAssertionIDReference(), sSOToken.getTokenID().toString()};
            string = (String)this.stub.send("getAssertionByIdRefToken", objectArray, (String)null);
            return new Assertion(XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertion: " + assertionIDReference, exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Set getAssertionArtifacts(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertionArtifacts(sSOToken);
        }
        try {
            return (Set)this.stub.send("getAssertionArtifacts", sSOToken.getTokenID().toString(), null);
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertionArtifacts: ", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    public Set getAssertions(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertions(sSOToken);
        }
        try {
            return (Set)this.stub.send("getAssertions", sSOToken.getTokenID().toString(), null);
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.warningEnabled()) {
                SAMLUtilsCommon.debug.warning("AMC:getAssertions: ", exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }
}

