/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.protocol.https;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.protocol.JSSEDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import sun.security.x509.GeneralName;
import sun.security.x509.X500Name;

public class AMHostnameVerifier
implements HostnameVerifier {
    public static boolean trustAllServerCerts = false;
    public static boolean checkSubjectAltName = false;
    public static boolean resolveIPAddress = false;

    public boolean verify(String string, SSLSession sSLSession) {
        Object object;
        if (trustAllServerCerts) {
            return true;
        }
        boolean bl = true;
        X509Certificate x509Certificate = null;
        String string2 = null;
        try {
            object = (X509Certificate[])sSLSession.getPeerCertificates();
            x509Certificate = object[0];
            String string3 = x509Certificate.getSubjectDN().getName();
            string2 = new X500Name(string3).getCommonName();
        }
        catch (Exception exception) {
            JSSEDebug.debug.error("ApprovalCallback:" + exception.toString());
        }
        if (string2 == null) {
            return false;
        }
        if (resolveIPAddress) {
            try {
                bl = InetAddress.getByName(string2).getHostAddress().equals(InetAddress.getByName(string).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                if (JSSEDebug.debug.messageEnabled()) {
                    JSSEDebug.debug.message("ApprovalCallback:", unknownHostException);
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        if (checkSubjectAltName && !bl) {
            try {
                object = x509Certificate.getSubjectAlternativeNames().iterator();
                while (!bl && object.hasNext()) {
                    bl = this.compareHosts((GeneralName)object.next(), string);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return bl;
    }

    private boolean compareHosts(GeneralName generalName, String string) {
        block3: {
            try {
                if (generalName.getType() == 2) {
                    String string2 = generalName.toString();
                    string2 = string2.substring(string2.indexOf(58) + 1).trim();
                    return InetAddress.getByName(string2).equals(InetAddress.getByName(string));
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!JSSEDebug.debug.messageEnabled()) break block3;
                JSSEDebug.debug.message(unknownHostException.toString());
            }
        }
        return false;
    }

    static {
        String string = SystemProperties.get("com.iplanet.am.jssproxy.trustAllServerCerts");
        trustAllServerCerts = string != null && string.equalsIgnoreCase("true");
        string = SystemProperties.get("com.iplanet.am.jssproxy.checkSubjectAltName");
        checkSubjectAltName = string != null && string.equalsIgnoreCase("true");
        string = SystemProperties.get("com.iplanet.am.jssproxy.resolveIPAddress");
        boolean bl = resolveIPAddress = string != null && string.equalsIgnoreCase("true");
        if (JSSEDebug.debug.messageEnabled()) {
            JSSEDebug.debug.message("AMHostnameVerifier trustAllServerCerts = " + trustAllServerCerts);
            JSSEDebug.debug.message("AMHostnameVerifier checkSubjectAltName = " + checkSubjectAltName);
        }
    }
}

