/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PolicyService {
    static final String POLICY_SERVICE_ROOT = "PolicyService";
    static final String POLICY_REQUEST = "PolicyRequest";
    static final String POLICY_RESPONSE = "PolicyResponse";
    static final String POLICY_NOTIFICATION = "PolicyNotification";
    static final String POLICYSERVICE_VERSION = "version";
    static final String POLICYSERVICE_REVISION = "revisionNumber";
    static final String CRLF = "\r\n";
    public static final String POLICY_SERVICE = "policy";
    public static final int POLICY_REQUEST_ID = 1;
    public static final int POLICY_RESPONSE_ID = 2;
    public static final int POLICY_NOTIFICATION_ID = 3;
    static Debug debug = Debug.getInstance("amPolicy");
    static final String ON_ERROR_REVISION_NUMBER = "0";
    private String version = "1.0";
    private int methodID = 0;
    private PolicyRequest policyReq;
    private PolicyResponse policyRes;
    private PolicyNotification policyNotification;
    private String revision;

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int n) {
        this.methodID = n;
    }

    public PolicyRequest getPolicyRequest() {
        return this.policyReq;
    }

    public void setPolicyRequest(PolicyRequest policyRequest) {
        this.policyReq = policyRequest;
    }

    public PolicyResponse getPolicyResponse() {
        return this.policyRes;
    }

    public void setPolicyResponse(PolicyResponse policyResponse) {
        this.policyRes = policyResponse;
    }

    public PolicyNotification getPolicyNotification() {
        return this.policyNotification;
    }

    public void setPolicyNotification(PolicyNotification policyNotification) {
        this.policyNotification = policyNotification;
    }

    public static PolicyService parseXML(String string) throws PolicyEvaluationException {
        Node node;
        String string2;
        Document document = null;
        try {
            document = XMLUtils.getXMLDocument(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            debug.error("PolicyService: XML parsing error");
            throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, exception);
        }
        PolicyService policyService = new PolicyService();
        Node node2 = XMLUtils.getRootNode(document, POLICY_SERVICE_ROOT);
        if (node2 == null) {
            debug.error("PolicyService: invalid root element specified in the request");
            throw new PolicyEvaluationException("amPolicy", "invalid_root_element", null, null);
        }
        String string3 = XMLUtils.getNodeAttributeValue(node2, POLICYSERVICE_VERSION);
        if (string3 != null) {
            policyService.setVersion(string3);
        }
        if ((string2 = XMLUtils.getNodeAttributeValue(node2, POLICYSERVICE_REVISION)) != null) {
            policyService.setRevision(string2);
        }
        if ((node = XMLUtils.getChildNode(node2, POLICY_REQUEST)) != null) {
            PolicyRequest policyRequest = PolicyRequest.parseXML(node);
            policyService.setPolicyRequest(policyRequest);
            policyService.setMethodID(1);
            return policyService;
        }
        node = XMLUtils.getChildNode(node2, POLICY_RESPONSE);
        if (node != null) {
            PolicyResponse policyResponse = PolicyResponse.parseXML(node);
            policyService.setPolicyResponse(policyResponse);
            policyService.setMethodID(2);
            return policyService;
        }
        node = XMLUtils.getChildNode(node2, POLICY_NOTIFICATION);
        if (node != null) {
            PolicyNotification policyNotification = PolicyNotification.parseXML(node);
            policyService.setPolicyNotification(policyNotification);
            policyService.setMethodID(3);
            return policyService;
        }
        debug.error("PolicyService: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_service_method", null, null);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<PolicyService version=\"" + this.version + "\"");
        if (this.revision != null && this.revision.trim().length() != 0) {
            stringBuffer.append(" revisionNumber=\"" + this.revision + "\"");
        }
        stringBuffer.append(">\r\n");
        switch (this.methodID) {
            case 1: {
                if (this.policyReq == null) break;
                stringBuffer.append(this.policyReq.toXMLString());
                break;
            }
            case 2: {
                if (this.policyRes == null) break;
                stringBuffer.append(this.policyRes.toXMLString());
                break;
            }
            case 3: {
                if (this.policyNotification == null) break;
                stringBuffer.append(this.policyNotification.toXMLString());
                break;
            }
        }
        stringBuffer.append("</PolicyService>\r\n");
        return stringBuffer.toString();
    }
}

