/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.remote.AdvicesHandleableByAMRequest;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import org.w3c.dom.Node;

public class PolicyRequest {
    public static final int POLICY_REQUEST_GET_RESOURCE_RESULTS = 1;
    public static final int POLICY_REQUEST_ADD_POLICY_LISTENER = 2;
    public static final int POLICY_REQUEST_REMOVE_POLICY_LISTENER = 3;
    public static final int POLICY_REQUEST_ADVICES_HANDLEABLE_BY_AM_REQUEST = 4;
    static final String POLICY_REQUEST = "PolicyRequest";
    static final String GET_RESOURCE_RESULTS = "GetResourceResults";
    static final String ADD_POLICY_LISTENER = "AddPolicyListener";
    static final String REMOVE_POLICY_LISTENER = "RemovePolicyListener";
    static final String ADVICES_HANDLEABLE_BY_AM_REQUEST = "AdvicesHandleableByAMRequest";
    static final String APP_SSOTOKEN = "appSSOToken";
    static final String REQUEST_ID = "requestId";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private ResourceResultRequest resourceResultReq = null;
    private PolicyListenerRequest policyListenerReq = null;
    private RemoveListenerRequest removeListenerReq = null;
    private AdvicesHandleableByAMRequest advicesHandleableByAMRequest = null;
    private String appSSOToken = null;
    private String requestId = null;
    private int methodID = 0;

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int n) {
        this.methodID = n;
    }

    public String getAppSSOToken() {
        return this.appSSOToken;
    }

    public void setAppSSOToken(String string) {
        this.appSSOToken = string;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String string) {
        this.requestId = string;
    }

    public ResourceResultRequest getResourceResultRequest() {
        return this.resourceResultReq;
    }

    public void setResourceResultRequest(ResourceResultRequest resourceResultRequest) {
        this.resourceResultReq = resourceResultRequest;
    }

    public PolicyListenerRequest getPolicyListenerRequest() {
        return this.policyListenerReq;
    }

    public void setPolicyListenerRequest(PolicyListenerRequest policyListenerRequest) {
        this.policyListenerReq = policyListenerRequest;
    }

    public RemoveListenerRequest getRemoveListenerRequest() {
        return this.removeListenerReq;
    }

    public void setRemoveListenerRequest(RemoveListenerRequest removeListenerRequest) {
        this.removeListenerReq = removeListenerRequest;
    }

    public void setAdvicesHandleableByAMRequest(AdvicesHandleableByAMRequest advicesHandleableByAMRequest) {
        this.advicesHandleableByAMRequest = advicesHandleableByAMRequest;
    }

    public static PolicyRequest parseXML(Node node) throws PolicyEvaluationException {
        PolicyRequest policyRequest = new PolicyRequest();
        String string = XMLUtils.getNodeAttributeValue(node, APP_SSOTOKEN);
        if (string == null) {
            debug.error("PolicyRequest: missing attribute appSSOToken");
            Object[] objectArray = new String[]{APP_SSOTOKEN};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyRequest.setAppSSOToken(string);
        string = XMLUtils.getNodeAttributeValue(node, REQUEST_ID);
        if (string == null) {
            debug.error("PolicyRequest: missing attribute requestId");
            Object[] objectArray = new String[]{REQUEST_ID};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyRequest.setRequestId(string);
        Node node2 = XMLUtils.getChildNode(node, GET_RESOURCE_RESULTS);
        if (node2 != null) {
            ResourceResultRequest resourceResultRequest = null;
            try {
                resourceResultRequest = ResourceResultRequest.parseXML(node2);
            }
            catch (PolicyEvaluationException policyEvaluationException) {
                throw new PolicyEvaluationException(policyEvaluationException, policyRequest.getRequestId());
            }
            policyRequest.setResourceResultRequest(resourceResultRequest);
            policyRequest.setMethodID(1);
            return policyRequest;
        }
        node2 = XMLUtils.getChildNode(node, ADD_POLICY_LISTENER);
        if (node2 != null) {
            PolicyListenerRequest policyListenerRequest = null;
            try {
                policyListenerRequest = PolicyListenerRequest.parseXML(node2);
            }
            catch (PolicyEvaluationException policyEvaluationException) {
                throw new PolicyEvaluationException(policyEvaluationException, policyRequest.getRequestId());
            }
            policyRequest.setPolicyListenerRequest(policyListenerRequest);
            policyRequest.setMethodID(2);
            return policyRequest;
        }
        node2 = XMLUtils.getChildNode(node, REMOVE_POLICY_LISTENER);
        if (node2 != null) {
            RemoveListenerRequest removeListenerRequest = null;
            try {
                removeListenerRequest = RemoveListenerRequest.parseXML(node2);
            }
            catch (PolicyEvaluationException policyEvaluationException) {
                throw new PolicyEvaluationException(policyEvaluationException, policyRequest.getRequestId());
            }
            policyRequest.setRemoveListenerRequest(removeListenerRequest);
            policyRequest.setMethodID(3);
            return policyRequest;
        }
        node2 = XMLUtils.getChildNode(node, ADVICES_HANDLEABLE_BY_AM_REQUEST);
        if (node2 != null) {
            policyRequest.setAdvicesHandleableByAMRequest(new AdvicesHandleableByAMRequest());
            policyRequest.setMethodID(4);
            return policyRequest;
        }
        debug.error("PolicyRequest: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_method", null, null);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<PolicyRequest appSSOToken=\"" + this.appSSOToken + "\" " + REQUEST_ID + "=\"" + this.requestId + "\">" + CRLF);
        if (this.methodID == 1) {
            stringBuffer.append(this.resourceResultReq.toXMLString());
        } else if (this.methodID == 2) {
            stringBuffer.append(this.policyListenerReq.toXMLString());
        } else if (this.methodID == 3) {
            stringBuffer.append(this.removeListenerReq.toXMLString());
        } else if (this.methodID == 4) {
            stringBuffer.append(this.advicesHandleableByAMRequest.toXMLString());
        }
        stringBuffer.append("</PolicyRequest>\r\n");
        return stringBuffer.toString();
    }
}

