/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PeerOrgReferral
extends OrgReferral {
    private static Debug debug = Debug.getInstance("amPolicy");
    private static final String PEER_ORG_REFERRAL = "PeerOrgReferral";

    public String getReferralTypeName() {
        return PEER_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        if (debug.messageEnabled()) {
            debug.message("PeerOrgReferral.getValidValues():entering");
        }
        try {
            Set set = (Set)this._configurationMap.get("OrganizationName");
            if (set == null || set.isEmpty()) {
                debug.error("PeerOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string2);
            String string3 = organizationConfigManager.getOrganizationName();
            if (debug.messageEnabled()) {
                debug.message("PeerOrgReferral.getValidValues():fullOrgName=" + string3);
            }
            OrganizationConfigManager organizationConfigManager2 = organizationConfigManager.getParentOrgConfigManager();
            String string4 = organizationConfigManager2.getOrganizationName();
            Set set2 = organizationConfigManager2.getSubOrganizationNames(string, false);
            if (!string3.equals(string4) && set2 != null && !set2.isEmpty()) {
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string5;
                    String string6 = (String)iterator2.next();
                    OrganizationConfigManager organizationConfigManager3 = organizationConfigManager2.getSubOrgConfigManager(string6);
                    if (organizationConfigManager3 == null || string3.equals(string5 = organizationConfigManager3.getOrganizationName())) continue;
                    hashSet.add(string5);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PeerOrgReferral.getValidValues():returning=" + hashSet);
            }
        }
        catch (SMSException sMSException) {
            debug.error("Can not get valid values for referral " + this.getReferralTypeName() + sMSException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, sMSException);
        }
        return new ValidValues(n, hashSet);
    }
}

