/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class Organization
implements Subject {
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedOrgDNs = Collections.EMPTY_SET;
    private Set selectedRFCOrgDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private String orgSearchFilter;
    private int userSearchScope = 2;
    private int orgSearchScope = 2;
    private String userRDNAttrName;
    private String orgRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private ConnectionPool connPool;
    private String orgName;
    private boolean localDS;
    private boolean aliasEnabled;
    private String ldapServer;
    static Debug debug = Debug.getInstance("amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "org_initialization_failed", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        if (string == null) {
            debug.error("Organization.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = string.toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-base-dn");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        this.orgSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-filter");
        string2 = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-scope");
        this.orgSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.orgRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("Organization.initialize(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\norgSearchFilter: " + this.orgSearchFilter + "\norgRDNAttrName: " + this.orgRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "org_subject_not_yet_initialized", null, null);
        }
        String string2 = null;
        string2 = string != null && !string.trim().equals("") ? "(&" + this.orgSearchFilter + "(" + this.orgRDNAttrName + "=" + string + "))" : this.orgSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("Organization.getValidValues(): organization search filter is: " + string2);
        }
        String[] stringArray = new String[]{this.orgRDNAttrName};
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.orgSearchScope, string2, stringArray, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("Organization.getValidValues(): found org name =" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray2 = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("Organization.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("Organization.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                int n3 = lDAPException.getLDAPResultCode();
                if (n3 == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                if (n3 == 32) {
                    Object[] objectArray = new String[]{this.baseDN};
                    throw new PolicyException("amPolicy", "no_such_ldap_base_dn", objectArray, null);
                }
                String string3 = lDAPException.getLDAPErrorMessage();
                String string4 = lDAPException.errorCodeToString();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var15_21 = null;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("Organization.getValidValues(): return set=" + ((Object)hashSet).toString());
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(string);
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("Organization.getValues() gets called");
        }
        return this.selectedOrgDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("Organization.setValues() Invalid names");
            throw new InvalidNameException("amPolicy", "org_subject_invalid_user_names", null, "null", 5);
        }
        this.selectedOrgDNs = new HashSet();
        this.selectedOrgDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("Organization.setValues(): selected org names=" + this.selectedOrgDNs);
        }
        this.selectedRFCOrgDNs = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.selectedRFCOrgDNs.add(new DN((String)iterator.next()).toRFCString().toLowerCase());
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        boolean bl = false;
        String string = sSOToken.getPrincipal().getName();
        if (debug.messageEnabled()) {
            debug.message("Organization.isMember(): user local DN is " + string);
        }
        DN dN = null;
        boolean bl2 = false;
        if (this.selectedRFCOrgDNs.size() > 0) {
            String string2 = sSOToken.getTokenID().toString();
            Iterator iterator = this.selectedRFCOrgDNs.iterator();
            while (iterator.hasNext()) {
                Boolean bl3 = null;
                String string3 = (String)iterator.next();
                bl3 = SubjectEvaluationCache.isMember(string2, this.ldapServer, string3);
                if (bl3 != null) {
                    boolean bl4;
                    if (debug.messageEnabled()) {
                        debug.message("Organization.isMember():Got membership from cache of " + string + " in org " + string3 + " :" + bl3);
                    }
                    if (!(bl4 = bl3.booleanValue())) continue;
                    return bl4;
                }
                if (debug.messageEnabled()) {
                    debug.message("Organization:isMember():entry for " + string3 + " not in subject evaluation cache, fetching from " + "directory server.");
                }
                if (dN == null && (dN = this.getUserDN(sSOToken)) == null) {
                    if (debug.messageEnabled()) {
                        debug.message("Organization.isMember(): User " + string + " is not found in the directory");
                    }
                    return false;
                }
                if (!bl && !PolicyEvaluator.ssoListenerRegistry.containsKey(string2)) {
                    sSOToken.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(string2, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("Organization.isMember(): sso listener added .\n");
                    }
                    bl = true;
                }
                if (!this.isMemberOfOrg(string3, dN, string2)) continue;
                if (debug.messageEnabled()) {
                    debug.message("Organization.isMember(): User " + dN.toRFCString() + " is a member of the " + "Organization object");
                }
                bl2 = true;
                break;
            }
        }
        if (debug.messageEnabled()) {
            if (bl2) {
                debug.message("Organization.isMember(): User " + string + " is a member of this Organization object");
            } else {
                debug.message("Organization.isMember(): User " + string + " is not a member of this Organization object");
            }
        }
        return bl2;
    }

    private boolean isMemberOfOrg(String string, DN dN, String string2) {
        DN dN2 = new DN(string);
        boolean bl = dN.isDescendantOf(dN2);
        if (debug.messageEnabled()) {
            String string3 = bl ? "is member of" : "is not a member of";
            debug.message("Organization.isMemberOfGroup(): User " + dN.toRFCString() + " " + string3 + " the Organization " + string + ", adding to Subject eval cache");
        }
        SubjectEvaluationCache.addEntry(string2, this.ldapServer, string, bl);
        return bl;
    }

    public int hashCode() {
        return this.selectedOrgDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Organization) {
            Organization organization = (Organization)object;
            if (this.selectedOrgDNs != null && organization.selectedOrgDNs != null && this.selectedOrgDNs.equals(organization.selectedOrgDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Organization organization = null;
        try {
            organization = (Organization)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedRFCOrgDNs != null) {
            organization.selectedRFCOrgDNs = new HashSet();
            organization.selectedRFCOrgDNs.addAll(this.selectedRFCOrgDNs);
        }
        return organization;
    }

    private DN getUserDN(SSOToken sSOToken) throws SSOException, PolicyException {
        DN dN = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = sSOToken.getPrincipal().getName();
        if (this.localDS && !PolicyUtils.principalNameEqualsUuid(sSOToken)) {
            dN = new DN(string);
        } else {
            Object object;
            int n = string.indexOf("=");
            int n2 = string.indexOf(",");
            if (n <= 0 || n2 <= 0 || n >= n2) {
                throw new PolicyException("amPolicy", "org_subject_invalid_local_user_dn", null, null);
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = null;
            string3 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string2, this.aliasEnabled) + ")" : PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string2, this.aliasEnabled);
            if (debug.messageEnabled()) {
                debug.message("Organization.getUserDN(): search filter is: " + string3);
            }
            String[] stringArray = new String[]{this.userRDNAttrName};
            LDAPConnection lDAPConnection = this.connPool.getConnection();
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(this.maxResults);
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
            try {
                try {
                    lDAPConnection.authenticate(this.authid, this.authpw);
                    object = lDAPConnection.search(this.baseDN, this.userSearchScope, string3, stringArray, false, lDAPSearchConstraints);
                    while (object.hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = object.next();
                            if (lDAPEntry == null) continue;
                            hashSet.add(lDAPEntry.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            Object[] objectArray = new String[]{this.orgName};
                            int n3 = lDAPException.getLDAPResultCode();
                            if (n3 == 4) {
                                debug.warning("Organization.getUserDN(): exceeded the size limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                            }
                            if (n3 == 3) {
                                debug.warning("Organization.getUserDN(): exceeded the time limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                            }
                            throw new PolicyException(lDAPException);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    int n4 = lDAPException.getLDAPResultCode();
                    if (n4 == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    if (n4 == 32) {
                        Object[] objectArray = new String[]{this.baseDN};
                        throw new PolicyException("amPolicy", "no_such_ldap_base_dn", objectArray, null);
                    }
                    String string4 = lDAPException.getLDAPErrorMessage();
                    String string5 = lDAPException.errorCodeToString();
                    if (string5 != null) {
                        throw new PolicyException(string4 + ": " + string5);
                    }
                    throw new PolicyException(string4);
                }
                catch (Exception exception) {
                    throw new PolicyException(exception);
                }
                Object var18_24 = null;
            }
            catch (Throwable throwable) {
                Object var18_25 = null;
                this.connPool.close(lDAPConnection);
                throw throwable;
            }
            this.connPool.close(lDAPConnection);
            if (hashSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("Organization.getUserDN(): qualified users=" + hashSet);
                }
                object = hashSet.iterator();
                dN = new DN((String)object.next());
            }
        }
        return dN;
    }
}

