/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class DSAMERole
implements Subject {
    private boolean initialized;
    private String organizationDN;
    private Set subjectRoles = Collections.EMPTY_SET;
    private int timeLimit;
    private int maxResults;
    private int roleSearchScope;
    private String ldapServer;
    private static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    private static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    private static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    static Debug debug = Debug.getInstance("amPolicy");

    public void initialize(Map map) throws PolicyException {
        this.organizationDN = (String)map.get("iplanet-am-policy-config-is-roles-base-dn");
        String string = (String)map.get("iplanet-am-policy-config-is-roles-search-scope");
        this.roleSearchScope = string.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.ldapServer = PolicyUtils.getISDSHostName().toLowerCase();
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
        }
        catch (NumberFormatException numberFormatException) {
            debug.error("Can not parse search parameters in DSAMERole", numberFormatException);
            this.timeLimit = 5;
            this.maxResults = 100;
        }
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "role_subject_not_yet_initialized", null, null);
        }
        try {
            int n;
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.organizationDN);
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setMaxResults(this.maxResults);
            aMSearchControl.setTimeOut(this.timeLimit);
            aMSearchControl.setSearchScope(this.roleSearchScope);
            AMSearchResults aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
            switch (aMSearchResults.getErrorCode()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return new ValidValues(n, aMSearchResults.getSearchResults());
        }
        catch (AMException aMException) {
            LDAPException lDAPException = aMException.getLDAPException();
            if (lDAPException != null) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                if (n == 32) {
                    Object[] objectArray = new String[]{this.organizationDN};
                    throw new PolicyException("amPolicy", "no_such_am_roles_base_dn", objectArray, null);
                }
                String string2 = lDAPException.getLDAPErrorMessage();
                String string3 = lDAPException.errorCodeToString();
                if (string3 != null) {
                    throw new PolicyException(string2 + ": " + string3);
                }
                throw new PolicyException(string2);
            }
            throw new PolicyException(aMException);
        }
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(string);
    }

    public Set getValues() {
        if (this.subjectRoles == null) {
            return Collections.EMPTY_SET;
        }
        return this.subjectRoles;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            throw new InvalidNameException("amPolicy", "role_subject_invalid_role_names", null, null, 5);
        }
        if (set.isEmpty()) {
            this.subjectRoles = set;
        } else {
            this.subjectRoles = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                this.subjectRoles.add(new DN(string).toRFCString().toLowerCase());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Set subjectRoles to: " + this.subjectRoles);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        String string = sSOToken.getTokenID().toString();
        String string2 = sSOToken.getPrincipal().getName();
        boolean bl = false;
        boolean bl2 = false;
        Set set = null;
        if (this.subjectRoles.size() > 0) {
            Iterator iterator = this.subjectRoles.iterator();
            while (iterator.hasNext()) {
                Boolean bl3 = null;
                String string3 = (String)iterator.next();
                bl3 = SubjectEvaluationCache.isMember(string, this.ldapServer, string3);
                if (bl3 != null) {
                    boolean bl4;
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember():Got membership from cache of " + sSOToken.getPrincipal().getName() + " in DSAME role " + string3 + " :" + bl3);
                    }
                    if (!(bl4 = bl3.booleanValue())) continue;
                    return bl4;
                }
                if (!bl && !PolicyEvaluator.ssoListenerRegistry.containsKey(string)) {
                    sSOToken.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(string, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember(): sso listener added .\n");
                    }
                    bl = true;
                }
                if (debug.messageEnabled()) {
                    debug.message("DSAMERole:isMember():entry for " + string3 + " not in subject evaluation cache, fetching " + "from NS User Cache.");
                }
                if (set == null) {
                    set = PolicyEvaluator.getUserNSRoleValues(sSOToken);
                }
                if (set != null && !set.isEmpty()) {
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember():\n  user roles: " + set + "\n  subject roles: " + this.subjectRoles);
                    }
                    if (set.contains(string3)) {
                        bl2 = true;
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("DSAMERole.isMember:adding entry " + string + " " + this.ldapServer + " " + string3 + " " + bl2 + " in subject evaluation cache.");
                }
                SubjectEvaluationCache.addEntry(string, this.ldapServer, string3, bl2);
                if (bl2) break;
            }
        }
        if (debug.messageEnabled()) {
            if (!bl2) {
                debug.message("DSAMERole.isMember(): User " + string2 + " is not a member of this DSAMERole object");
            } else {
                debug.message("DSAMERole.isMember(): User " + string2 + " is a member of this DSAMERole object");
            }
        }
        return bl2;
    }

    public int hashCode() {
        return this.subjectRoles.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DSAMERole) {
            DSAMERole dSAMERole = (DSAMERole)object;
            return this.subjectRoles.equals(dSAMERole.subjectRoles);
        }
        return false;
    }

    public Object clone() {
        DSAMERole dSAMERole = null;
        try {
            dSAMERole = (DSAMERole)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.subjectRoles != null) {
            dSAMERole.subjectRoles = new HashSet();
            dSAMERole.subjectRoles.addAll(this.subjectRoles);
        }
        return dSAMERole;
    }
}

