/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AMIdentitySubject
implements Subject {
    private boolean initialized;
    private String organizationDN;
    private Set subjectValues = new HashSet();
    private static Debug debug = Debug.getInstance("amPolicy");

    public void initialize(Map map) throws PolicyException {
        Set set = (Set)map.get("OrganizationName");
        if (set == null || set.isEmpty()) {
            debug.error("AMIdentitySubject.initialize(Map):  Organization name not set");
            throw new PolicyException("amPolicy", "org_name_not_set", null, null);
        }
        this.organizationDN = (String)set.iterator().next();
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "am_id_subject_not_initialized", null, null);
        }
        throw new PolicyException("amPolicy", "am_id_subject_does_not_support_getvalidvalues", null, null);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (this.subjectValues == null) {
            return Collections.EMPTY_SET;
        }
        return this.subjectValues;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            throw new InvalidNameException("amPolicy", "amidentity_subject_invalid_subject_values", null, null, 5);
        }
        this.subjectValues.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("AMIdentitySubejct set subjectValues to: " + this.subjectValues);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        Object object;
        String string = null;
        String string2 = null;
        if (sSOToken != null && (object = sSOToken.getTokenID()) != null) {
            string = object.toString();
        }
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("AMIdentitySubject.isMember():tokenID is null");
                debug.warning("AMIdentitySubject.isMember():returning false");
            }
            return false;
        }
        object = sSOToken.getPrincipal();
        if (object != null) {
            string2 = object.getName();
        }
        if (string2 == null) {
            if (debug.warningEnabled()) {
                debug.warning("AMIdentitySubject.isMember():userDN is null");
                debug.warning("AMIdentitySubject.isMember():returning false");
            }
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (debug.messageEnabled()) {
            debug.message("AMIndentitySubject.isMember(): entering with userDN = " + string2);
        }
        Object var6_7 = null;
        if (this.subjectValues.size() > 0) {
            Iterator iterator = this.subjectValues.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray;
                Boolean bl3 = null;
                String string3 = (String)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("AMIndentitySubject.isMember(): checking membership with userDN = " + string2 + ", subjectValue = " + string3);
                }
                if ((bl3 = SubjectEvaluationCache.isMember(string, "AMIdentitySubject", string3)) != null) {
                    boolean bl4;
                    if (debug.messageEnabled()) {
                        debug.message("AMIdentitySubject.isMember():got membership from SubjectEvaluationCache  for userDN = " + string2 + ", subjectValue = " + string3 + ", result = " + bl3);
                    }
                    if (!(bl4 = bl3.booleanValue())) continue;
                    if (debug.messageEnabled()) {
                        debug.message("AMIndentitySubject.isMember():  returning membership status = " + bl4);
                    }
                    return bl4;
                }
                if (debug.messageEnabled()) {
                    debug.message("AMIdentitySubject:isMember():entry for " + string3 + " not in subject evaluation cache, " + "so compute using IDRepo api");
                }
                try {
                    AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(this.getAdminToken(), this.organizationDN);
                    objectArray = IdUtils.getIdentity(this.getAdminToken(), string3);
                    if (objectArray == null) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():subjectIdentity is null for subjectValue = " + string3);
                            debug.message("AMidentitySubject.isMember():returning false");
                        }
                        return false;
                    }
                    AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken);
                    String string4 = IdUtils.getUniversalId(aMIdentity);
                    AMIdentity aMIdentity2 = IdUtils.getIdentity(this.getAdminToken(), string4);
                    if (aMIdentity2 == null) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():userIdentity is null");
                            debug.message("AMidentitySubject.isMember():returning false");
                        }
                        return false;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMidentitySubject.isMember():user uuid = " + IdUtils.getUniversalId(aMIdentity2) + ", subject uuid = " + IdUtils.getUniversalId((AMIdentity)objectArray));
                    }
                    IdType idType = aMIdentity2.getType();
                    IdType idType2 = objectArray.getType();
                    Set set = null;
                    if (aMIdentity2.equals(objectArray)) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():userIdentity equals subjectIdentity:membership=true");
                        }
                        bl2 = true;
                    } else {
                        set = idType2.canHaveMembers();
                        if (set != null && set.contains(idType)) {
                            bl2 = aMIdentity2.isMember((AMIdentity)objectArray);
                            if (debug.messageEnabled()) {
                                debug.message("AMIdentitySubject.isMember():userIdentity type " + idType + " can be a member of " + "subjectIdentityType " + idType2 + ":membership=" + bl2);
                            }
                        } else {
                            bl2 = false;
                            if (debug.messageEnabled()) {
                                debug.message("AMIdentitySubject.isMember():userIdentity type " + idType + " can not be a member of " + "subjectIdentityType " + idType2 + ":membership=" + bl2);
                            }
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMIdentitySubject.isMember: adding entry in SubjectEvaluationCache for , for userDN = " + string2 + ", subjectValue = " + string3 + ", subjectMatch = " + bl2);
                    }
                    SubjectEvaluationCache.addEntry(string, "AMIdentitySubject", string3, bl2);
                    if (!bl && !PolicyEvaluator.ssoListenerRegistry.containsKey(string)) {
                        sSOToken.addSSOTokenListener(PolicyEvaluator.ssoListener);
                        PolicyEvaluator.ssoListenerRegistry.put(string, PolicyEvaluator.ssoListener);
                        if (debug.messageEnabled()) {
                            debug.message("AMIdentitySubject.isMember(): sso listener added ");
                        }
                        bl = true;
                    }
                    if (!bl2) continue;
                    break;
                }
                catch (IdRepoException idRepoException) {
                    debug.warning("AMidentitySubject.isMember():can not check membership for user " + string2 + ", subject " + string3, idRepoException);
                    objectArray = new String[]{string2, string3};
                    throw new PolicyException("amPolicy", "am_id_subject_membership_evaluation_error", objectArray, idRepoException);
                }
            }
        }
        if (debug.messageEnabled()) {
            if (!bl2) {
                debug.message("AMIdentitySubject.isMember(): user " + string2 + " is not a member of this subject");
            } else {
                debug.message("AMIdentitySubject.isMember(): User " + string2 + " is a member of this subject");
            }
        }
        return bl2;
    }

    public int hashCode() {
        return this.subjectValues.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AMIdentitySubject) {
            AMIdentitySubject aMIdentitySubject = (AMIdentitySubject)object;
            return this.subjectValues.equals(aMIdentitySubject.subjectValues);
        }
        return false;
    }

    public Object clone() {
        AMIdentitySubject aMIdentitySubject = null;
        try {
            aMIdentitySubject = (AMIdentitySubject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.subjectValues != null) {
            aMIdentitySubject.subjectValues = new HashSet();
            aMIdentitySubject.subjectValues.addAll(this.subjectValues);
        }
        return aMIdentitySubject;
    }

    private SSOToken getAdminToken() throws SSOException {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (sSOToken == null) {
            throw new SSOException(new PolicyException("amPolicy", "invalid_admin", null, null));
        }
        return sSOToken;
    }
}

