/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResultsCacheUtil {
    static Debug debug = Debug.getInstance("amRemotePolicy");
    private static final String BEGIN_XML_DATA_BLOCK = "<![CDATA[";
    private static final String END_XML_DATA_BLOCK = "]]>";
    private static final String NODE_POLICY_SERVICE = "PolicyService";
    private static final String NODE_POLICY_NOTIFICATION = "PolicyNotification";

    public static void processNotification(String string) throws PolicyEvaluationException {
        PolicyNotification policyNotification;
        if (debug.messageEnabled()) {
            debug.message("ResultsCacheUtil.processNotification():recieved notification xml=" + string);
        }
        if ((policyNotification = ResultsCacheUtil.extractPolicyNotification(string)) != null) {
            ResourceResultCache.processPolicyNotification(policyNotification);
        } else {
            debug.error("ResultsCacheUtil.processPolicyNotification():PolicyNotification is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PolicyNotification extractPolicyNotification(String string) throws PolicyEvaluationException {
        PolicyNotification policyNotification = null;
        try {
            String string2 = ResultsCacheUtil.getNotificationDataBlock(string);
            if (string2 != null) {
                Document document = XMLUtils.getXMLDocument(new ByteArrayInputStream(string2.getBytes()));
                Node node = XMLUtils.getRootNode(document, NODE_POLICY_SERVICE);
                if (node != null) {
                    Node node2 = XMLUtils.getChildNode(node, NODE_POLICY_NOTIFICATION);
                    if (node2 != null) {
                        return PolicyNotification.parseXML(node2);
                    }
                    debug.error("ResultsCacheUtil.extractPolicyNotification():cannot find notification node");
                    throw new PolicyEvaluationException("amPolicy", "invalid_root_element", null, null);
                }
                debug.error("ResultsCacheUtil.extractPolicyNotification():");
                return policyNotification;
            } else {
                debug.error("ResultsCacheUtil:extractPolicyNotification():notification data block is null");
            }
            return policyNotification;
        }
        catch (Exception exception) {
            debug.error("ResultsCacheUtil.extractPolicyNotification():", exception);
            throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, exception);
        }
    }

    private static String getNotificationDataBlock(String string) {
        int n = string.indexOf(BEGIN_XML_DATA_BLOCK);
        if (n != -1 && (n = (string = string.substring(n + BEGIN_XML_DATA_BLOCK.length())).indexOf(END_XML_DATA_BLOCK)) != -1) {
            return string.substring(0, n);
        }
        return null;
    }
}

