/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subjects {
    private final int SUBJECTS_RESULT_CACHE_SIZE = 1000;
    private String name;
    private String description;
    private Map users = new HashMap();
    private Cache resultCache = new Cache(1000);
    private long resultTtl;
    private static String SUBJECTS_ELEMENT_BEGIN = "<Subjects name=\"";
    private static String SUBJECTS_DESCRIPTION = "\" description=\"";
    private static String SUBJECTS_ELEMENT_END = "</Subjects>";
    private static String SUBJECT_ELEMENT = "<Subject name=\"";
    private static String INCLUDE_TYPE = "includeType";
    private static String SUBJECT_TYPE = "\" type=\"";
    private static String SUBJECT_ELEMENT_END = "</Subject>";
    private static String ATTR_VALUE_BEGIN = "<AttributeValuePair><Attribute name=\"Values\"/>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_END = "</AttributeValuePair>";
    private static String SUBJECT_VALUES_ATTR_NAME = "Values";
    private static String INCLUSIVE_TYPE = "inclusive";
    private static String EXCLUSIVE_TYPE = "exclusive";
    private static String REALM_SUBJECT_ELEMENT = "<RealmSubject name=\"";
    private static String REALM_SUBJECT_ELEMENT_END = "\"></RealmSubject>";

    protected Subjects() {
        this((String)null, (String)null);
    }

    protected Subjects(PolicyManager policyManager, Node node) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        Object object;
        String string;
        Node node2;
        if (!node.getNodeName().equalsIgnoreCase("Subjects")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid subjects xml blob given to construct subjects");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_subjects_root_node", null, "", 5);
        }
        this.name = XMLUtils.getNodeAttributeValue(node, "name");
        if (this.name == null) {
            this.name = "Subjects:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue(node, "description")) == null) {
            this.description = "";
        }
        SubjectTypeManager subjectTypeManager = policyManager.getSubjectTypeManager();
        Iterator iterator = XMLUtils.getChildNodes(node, "Subject").iterator();
        while (iterator.hasNext()) {
            Object object2;
            node2 = (Node)iterator.next();
            string = XMLUtils.getNodeAttributeValue(node2, "type");
            if (string == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("subject type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_subjects_root_node", null, "", 5);
            }
            object = subjectTypeManager.getSubject(string);
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                object2 = nodeList.item(n2);
                if (XMLUtils.getNamedChildNode((Node)object2, "Attribute", "name", SUBJECT_VALUES_ATTR_NAME) != null) {
                    object.setValues(XMLUtils.getAttributeValuePair((Node)object2));
                }
                ++n2;
            }
            object2 = XMLUtils.getNodeAttributeValue(node2, "name");
            String string2 = XMLUtils.getNodeAttributeValue(node2, INCLUDE_TYPE);
            this.addSubject((String)object2, (Subject)object, EXCLUSIVE_TYPE.equals(string2));
        }
        iterator = XMLUtils.getChildNodes(node, "RealmSubject").iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string = XMLUtils.getNodeAttributeValue(node2, "name");
            object = XMLUtils.getNodeAttributeValue(node2, INCLUDE_TYPE);
            this.addSubject(string, subjectTypeManager.getSharedSubject(string), EXCLUSIVE_TYPE.equals(object));
        }
    }

    public Subjects(String string, String string2) {
        this.name = string == null ? "Subjects:" + ServiceTypeManager.generateRandomName() : string;
        this.description = string2 == null ? "" : string2;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String string) {
        this.name = string == null ? "Subjects:" + ServiceTypeManager.generateRandomName() : string;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public Set getSubjectNames() {
        return this.users.keySet();
    }

    public Subject getSubject(String string) throws NameNotFoundException {
        QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(string);
        if (qualifiedSubject == null) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 5);
        }
        return qualifiedSubject.getSubject();
    }

    Subject fetchSubject(String string) {
        QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(string);
        return qualifiedSubject != null ? qualifiedSubject.getSubject() : null;
    }

    public void addSubject(Subject subject) throws NameAlreadyExistsException {
        this.addSubject(null, subject, false);
    }

    public void addSubject(String string, Subject subject) throws NameAlreadyExistsException {
        this.addSubject(string, subject, false);
    }

    public void addSubject(String string, Subject subject, boolean bl) throws NameAlreadyExistsException {
        if (string == null) {
            string = "Subject:" + ServiceTypeManager.generateRandomName();
        }
        if (this.users.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objectArray, string, 5);
        }
        this.users.put(string, new QualifiedSubject(subject, bl));
    }

    public void replaceSubject(String string, Subject subject) throws NameNotFoundException {
        this.replaceSubject(string, subject, false);
    }

    public void replaceSubject(String string, Subject subject, boolean bl) throws NameNotFoundException {
        if (!this.users.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 5);
        }
        this.users.put(string, new QualifiedSubject(subject, bl));
    }

    public Subject removeSubject(String string) {
        Subject subject = null;
        QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.remove(string);
        if (qualifiedSubject != null) {
            subject = qualifiedSubject.getSubject();
        }
        return subject;
    }

    public Subject removeSubject(Subject subject) {
        QualifiedSubject qualifiedSubject;
        Subject subject2 = null;
        String string = this.getSubjectName(subject);
        if (string != null && (qualifiedSubject = (QualifiedSubject)this.users.remove(string)) != null) {
            subject2 = qualifiedSubject.getSubject();
        }
        return subject2;
    }

    public boolean isSubjectExclusive(String string) throws NameNotFoundException {
        if (!this.users.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 5);
        }
        return ((QualifiedSubject)this.users.get(string)).isExclusive();
    }

    public boolean isRealmSubject(String string) throws NameNotFoundException {
        if (!this.users.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 5);
        }
        return ((QualifiedSubject)this.users.get(string)).isRealmSubject();
    }

    public String getSubjectName(Subject subject) {
        String string = null;
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(string2);
            if (!qualifiedSubject.getSubject().equals(subject)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Subjects) {
            Subjects subjects = (Subjects)object;
            if (subjects.users.size() == this.users.size()) {
                Iterator iterator = this.users.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next().getValue();
                    if (subjects.users.containsValue(v)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Subjects subjects = null;
        try {
            subjects = (Subjects)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            subjects = new Subjects();
        }
        subjects.name = this.name;
        subjects.description = this.description;
        subjects.users = new HashMap();
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(string);
            subjects.users.put(string, new QualifiedSubject((Subject)qualifiedSubject.getSubject().clone(), qualifiedSubject.isExclusive()));
        }
        return subjects;
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        boolean bl = false;
        long l = System.currentTimeMillis();
        long[] lArray = null;
        lArray = (long[])this.resultCache.get(sSOToken.getTokenID().toString());
        if (lArray == null) {
            lArray = new long[2];
        }
        if (l - lArray[0] < this.resultTtl) {
            boolean bl2 = bl = lArray[1] == 1L;
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("Subjects.isMember():getting subject evaluation results from resultCache of policy");
            }
        } else {
            Iterator iterator = this.users.entrySet().iterator();
            while (iterator.hasNext()) {
                QualifiedSubject qualifiedSubject = (QualifiedSubject)iterator.next().getValue();
                if (qualifiedSubject.subject.isMember(sSOToken)) {
                    if (qualifiedSubject.exclusive) continue;
                    bl = true;
                    break;
                }
                if (!qualifiedSubject.exclusive) continue;
                bl = true;
                break;
            }
            long l2 = bl ? 1L : 0L;
            lArray[0] = l;
            lArray[1] = l2;
            this.resultCache.put(sSOToken.getTokenID().toString(), lArray);
        }
        return bl;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n").append(SUBJECTS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters(this.name)).append(SUBJECTS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters(this.description)).append("\">");
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(string);
            boolean bl = qualifiedSubject.isRealmSubject();
            if (bl) {
                stringBuffer.append("\n").append(REALM_SUBJECT_ELEMENT).append(XMLUtils.escapeSpecialCharacters(string)).append("\" ").append(INCLUDE_TYPE).append("=\"").append(qualifiedSubject.isExclusive() ? EXCLUSIVE_TYPE : INCLUSIVE_TYPE).append(REALM_SUBJECT_ELEMENT_END);
                continue;
            }
            Subject subject = qualifiedSubject.getSubject();
            stringBuffer.append("\n").append(SUBJECT_ELEMENT).append(XMLUtils.escapeSpecialCharacters(string)).append(SUBJECT_TYPE).append(XMLUtils.escapeSpecialCharacters(SubjectTypeManager.subjectTypeName(subject))).append("\" ").append(INCLUDE_TYPE).append("=\"").append(qualifiedSubject.isExclusive() ? EXCLUSIVE_TYPE : INCLUSIVE_TYPE).append("\">");
            Set set = subject.getValues();
            if (set != null && !set.isEmpty()) {
                stringBuffer.append("\n").append(ATTR_VALUE_BEGIN);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append(VALUE_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)iterator2.next())).append(VALUE_END);
                }
                stringBuffer.append("\n").append(ATTR_VALUE_END);
            }
            stringBuffer.append("\n").append(SUBJECT_ELEMENT_END);
        }
        stringBuffer.append("\n").append(SUBJECTS_ELEMENT_END);
        return stringBuffer.toString();
    }

    void setResultTtl(long l) {
        this.resultTtl = l;
    }

    long getResultTtl() {
        return this.resultTtl;
    }

    long getResultTtl(SSOToken sSOToken) {
        long l = Long.MAX_VALUE;
        long[] lArray = (long[])this.resultCache.get(sSOToken.getTokenID().toString());
        if (lArray != null) {
            l = lArray[0] + this.resultTtl;
        }
        return l;
    }

    void setPolicyConfig(Map map) throws PolicyException {
        this.resultCache = new Cache(1000);
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(iterator.next());
            qualifiedSubject.getSubject().initialize(map);
        }
        this.setResultTtl(PolicyConfig.getSubjectsResultTtl(map));
    }

    int size() {
        return this.users.size();
    }

    boolean isSubjectResultCached(SSOToken sSOToken) throws SSOException {
        return this.resultCache.get(sSOToken.getTokenID().toString()) != null;
    }

    private static class QualifiedSubject {
        Subject subject;
        boolean exclusive = false;

        QualifiedSubject(Subject subject, boolean bl) {
            this.subject = subject;
            this.exclusive = bl;
        }

        Subject getSubject() {
            return this.subject;
        }

        boolean isExclusive() {
            return this.exclusive;
        }

        boolean isRealmSubject() {
            return this.subject instanceof SharedSubject;
        }
    }
}

