/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.ObjectInUseException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import netscape.ldap.util.DN;

public class SubjectTypeManager {
    private static String SUBJECT = "Subject";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private Subjects realmSubjects = null;
    private Map sharedSubjects = Collections.synchronizedMap(new HashMap());
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String pmRealmName;
    static Debug debug = PolicyManager.debug;
    private static ServiceSchemaManager ssm;

    protected SubjectTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String string = this.token.getProperty("Locale");
        java.util.Locale locale = Locale.getLocale(string);
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    protected SubjectTypeManager(PolicyManager policyManager) {
        java.util.Locale locale;
        this.pm = policyManager;
        this.pmRealmName = new DN(policyManager.getOrganizationDN()).toRFCString().toLowerCase();
        this.token = policyManager.token;
        try {
            String string = this.token.getProperty("Locale");
            locale = Locale.getLocale(string);
        }
        catch (SSOException sSOException) {
            debug.error("SubjectTypeManager:Unable to retreive locale from SSOToken", sSOException);
            locale = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + locale + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    public Set getSubjectTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(SUBJECT);
    }

    public Set getSelectedSubjectTypeNames() throws SSOException, PolicyException {
        Map map = this.pm.getPolicyConfig();
        Set set = null;
        if (map != null) {
            set = (Set)map.get("iplanet-am-policy-selected-subjects");
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public String getSubjectTypeName(Subject subject) {
        return SubjectTypeManager.subjectTypeName(subject);
    }

    protected String getI18NPropertiesFileName(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        return null;
    }

    public String getI18NKey(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        if (pluginSchema != null) {
            return pluginSchema.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String string) {
        String string2 = null;
        String string3 = this.getI18NKey(string);
        string2 = string3 == null || string3.length() == 0 ? string : Locale.getString(this.rb, string3, debug);
        return string2;
    }

    public Subject getSubject(String string) throws NameNotFoundException, PolicyException {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string);
        if (pluginSchema == null) {
            throw new NameNotFoundException("amPolicy", "invalid_subject", null, string, 5);
        }
        Subject subject = null;
        try {
            String string2 = pluginSchema.getClassName();
            subject = (Subject)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
        subject.initialize(this.pm.getPolicyConfig());
        return subject;
    }

    public void addSubject(String string, Subject subject) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        this.addSubject(string, subject, false);
    }

    private void addSubject(String string, Subject subject, boolean bl) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Adding realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        this.realmSubjects.addSubject(string, subject, bl);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Added realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
    }

    public Subject removeSubject(String string) throws ObjectInUseException, PolicyException, SSOException {
        return this.removeSubject(string, false);
    }

    public Subject removeSubject(String string, boolean bl) throws ObjectInUseException, PolicyException, SSOException {
        Object object;
        if (debug.messageEnabled()) {
            debug.message("Removing realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (bl) {
            object = this.pm.getPoliciesUsingRealmSubject(string);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Policy policy = (Policy)iterator.next();
                policy.removeSubject(string);
            }
        } else {
            object = this.pm.getPolicyUsingRealmSubject(string);
            if (object != null) {
                throw new ObjectInUseException(null, null, null, null, null);
            }
        }
        object = this.realmSubjects.removeSubject(string);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Removed realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
        return object;
    }

    public void replaceSubject(String string, Subject subject) throws NameNotFoundException, PolicyException, SSOException {
        this.replaceSubject(string, subject, false);
    }

    private void replaceSubject(String string, Subject subject, boolean bl) throws NameNotFoundException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Replacing realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        this.realmSubjects.replaceSubject(string, subject, bl);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Replaced realm subject : " + string + ", in realm:" + this.pmRealmName);
        }
    }

    public Set getSubjectNames() throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Getting subject names from realm: " + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        Set set = this.realmSubjects.getSubjectNames();
        if (debug.messageEnabled()) {
            debug.message("Returning subject names from realm: " + this.pmRealmName + ",subjectNames=" + set);
        }
        return set;
    }

    public Subject getSubjectByName(String string) throws NameNotFoundException, PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Getting subject by name from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (debug.messageEnabled()) {
            debug.message("Returning subject by name from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        return (Subject)this.realmSubjects.getSubject(string).clone();
    }

    synchronized Subject getCachedSubjectByName(String string) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Getting cached subject by name from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (debug.messageEnabled()) {
            debug.message("Returning cached subject by name from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        return this.realmSubjects.fetchSubject(string);
    }

    Subject getSharedSubject(String string) throws PolicyException {
        Subject subject;
        if (debug.messageEnabled()) {
            debug.message("Getting shared subject from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        if ((subject = (Subject)this.sharedSubjects.get(string)) == null) {
            subject = new SharedSubject(string, this);
            this.sharedSubjects.put(string, subject);
        }
        if (debug.messageEnabled()) {
            debug.message("Returning shared subject from realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        return subject;
    }

    static String subjectTypeName(Subject subject) {
        if (subject == null) {
            return null;
        }
        String string = null;
        String string2 = subject.getClass().getName();
        Iterator iterator = PolicyManager.getPluginSchemaNames(SUBJECT).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            PluginSchema pluginSchema = PolicyManager.getPluginSchema(SUBJECT, string3);
            if (!string2.equals(pluginSchema.getClassName())) continue;
            string = string3;
            break;
        }
        return string;
    }

    public String getViewBeanURL(Subject subject) {
        return PolicyManager.getViewBeanURL(SUBJECT, subject.getClass().getName());
    }

    private boolean isSubjectExclusive(String string) throws NameNotFoundException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Checking is subject exclusive in realm: " + this.pmRealmName + ", subjectName=" + string);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        boolean bl = this.realmSubjects.isSubjectExclusive(string);
        if (debug.messageEnabled()) {
            debug.message("Returning is subject exclusive in realm: " + this.pmRealmName + ", subjectName=" + string + "exclusive=" + bl);
        }
        return bl;
    }

    PolicyManager getPolicyManager() {
        return this.pm;
    }

    private void saveSubjects() throws PolicyException, SSOException {
        if (this.realmSubjects != null) {
            this.pm.saveRealmSubjects(this.realmSubjects);
        }
    }

    private void initRealmSubjects() throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Initializing realm subjects in realm : " + this.pmRealmName);
        }
        try {
            this.realmSubjects = this.pm.readRealmSubjects();
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "could_not_initialize_realm_subjects", null, sSOException);
        }
        if (debug.messageEnabled()) {
            debug.message("Initialized realm subjects in realm : " + this.pmRealmName);
        }
    }

    void resetRealmSubjects() {
        if (debug.messageEnabled()) {
            debug.message("Resetting realm subjects in realm : " + this.pmRealmName);
        }
        SubjectTypeManager subjectTypeManager = this;
        synchronized (subjectTypeManager) {
            this.realmSubjects = null;
        }
        if (debug.messageEnabled()) {
            debug.message("Reset realm subjects in realm : " + this.pmRealmName);
        }
    }
}

