/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Referrals
implements Cloneable {
    private String name;
    private String description;
    private Map referrals = new HashMap();
    private static String REFERRALS_ELEMENT_BEGIN = "<Referrals name=\"";
    private static String REFERRALS_DESCRIPTION = "\" description=\"";
    private static String REFERRALS_ELEMENT_END = "</Referrals>";
    private static String REFERRAL_ELEMENT = "<Referral name=\"";
    private static String REFERRAL_TYPE = "\" type=\"";
    private static String REFERRAL_ELEMENT_END = "</Referral>";
    private static String ATTR_VALUE_BEGIN = "<AttributeValuePair><Attribute name=\"Values\"/>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_END = "</AttributeValuePair>";
    private static String REFERRAL_VALUES_ATTR_NAME = "Values";

    protected Referrals() {
        this((String)null, (String)null);
    }

    protected Referrals(PolicyManager policyManager, Node node) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        if (!node.getNodeName().equalsIgnoreCase("Referrals")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid referrals xml blob given to construct referrals");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_referrals_root_node", null, "", 8);
        }
        this.name = XMLUtils.getNodeAttributeValue(node, "name");
        if (this.name == null) {
            this.name = "Referrals:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue(node, "description")) == null) {
            this.description = "";
        }
        ReferralTypeManager referralTypeManager = policyManager.getReferralTypeManager();
        Iterator iterator = XMLUtils.getChildNodes(node, "Referral").iterator();
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string = XMLUtils.getNodeAttributeValue(node2, "type");
            if (string == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("referral type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_referrals_root_node", null, "", 8);
            }
            Referral referral = referralTypeManager.getReferral(string);
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                object = nodeList.item(n2);
                if (XMLUtils.getNamedChildNode((Node)object, "Attribute", "name", REFERRAL_VALUES_ATTR_NAME) != null) {
                    referral.setValues(XMLUtils.getAttributeValuePair((Node)object));
                }
                ++n2;
            }
            object = XMLUtils.getNodeAttributeValue(node2, "name");
            this.addReferral((String)object, referral);
        }
    }

    public Referrals(String string, String string2) {
        this.name = string == null ? "Referrals:" + ServiceTypeManager.generateRandomName() : string;
        this.description = string2 == null ? "" : string2;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String string) {
        this.name = string == null ? "Referrals:" + ServiceTypeManager.generateRandomName() : string;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public Set getReferralNames() {
        return this.referrals.keySet();
    }

    public Referral getReferral(String string) throws NameNotFoundException {
        Referral referral = (Referral)this.referrals.get(string);
        if (referral == null) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 8);
        }
        return referral;
    }

    public void addReferral(Referral referral) throws NameAlreadyExistsException {
        this.addReferral(null, referral);
    }

    public void addReferral(String string, Referral referral) throws NameAlreadyExistsException {
        if (string == null) {
            string = "Referral:" + ServiceTypeManager.generateRandomName();
        }
        if (this.referrals.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objectArray, string, 8);
        }
        this.referrals.put(string, referral);
    }

    public void replaceReferral(String string, Referral referral) throws NameNotFoundException {
        if (!this.referrals.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 8);
        }
        this.referrals.put(string, referral);
    }

    public Referral removeReferral(String string) {
        return (Referral)this.referrals.remove(string);
    }

    public Referral removeReferral(Referral referral) {
        String string = this.getReferralName(referral);
        if (string != null) {
            return this.removeReferral(string);
        }
        return null;
    }

    public String getReferralName(Referral referral) {
        String string = null;
        Iterator iterator = this.referrals.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!referral.equals(this.referrals.get(string2))) continue;
            string = string2;
            break;
        }
        return string;
    }

    public boolean equals(Object object) {
        Iterator iterator = null;
        if (object instanceof Referrals) {
            Referrals referrals = (Referrals)object;
            iterator = this.referrals.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next().getValue();
                if (referrals.referrals.containsValue(v)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        Referrals referrals = null;
        try {
            referrals = (Referrals)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            PolicyManager.debug.error("Referrals: clone failed", cloneNotSupportedException);
        }
        referrals.name = this.name;
        referrals.description = this.description;
        referrals.referrals = new HashMap();
        Iterator iterator = this.referrals.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            referrals.referrals.put(k, this.referrals.get(k));
        }
        return referrals;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n").append(REFERRALS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters(this.name)).append(REFERRALS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters(this.description)).append("\">");
        Iterator iterator = this.referrals.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Referral referral = (Referral)this.referrals.get(string);
            stringBuffer.append("\n").append(REFERRAL_ELEMENT).append(XMLUtils.escapeSpecialCharacters(string)).append(REFERRAL_TYPE).append(XMLUtils.escapeSpecialCharacters(ReferralTypeManager.referralTypeName(referral))).append("\">");
            Set set = referral.getValues();
            if (set != null && !set.isEmpty()) {
                stringBuffer.append("\n").append(ATTR_VALUE_BEGIN);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("\n").append(VALUE_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)iterator2.next())).append(VALUE_END);
                }
                stringBuffer.append("\n").append(ATTR_VALUE_END);
            }
            stringBuffer.append("\n").append(REFERRAL_ELEMENT_END);
        }
        stringBuffer.append("\n").append(REFERRALS_ELEMENT_END);
        return stringBuffer.toString();
    }

    PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, String string2, Set set, Map map) throws SSOException, NameNotFoundException, PolicyException {
        PolicyDecision policyDecision = null;
        ServiceType serviceType = ServiceTypeManager.getServiceTypeManager().getServiceType(string);
        Set set2 = this.getReferralNames();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Referral referral = this.getReferral(string3);
            if (referral instanceof OrgReferral) continue;
            PolicyDecision policyDecision2 = referral.getPolicyDecision(sSOToken, string, string2, set, map);
            if (policyDecision == null) {
                policyDecision = policyDecision2;
            } else {
                PolicyEvaluator.mergePolicyDecisions(serviceType, policyDecision2, policyDecision);
            }
            set.removeAll(PolicyEvaluator.getFinalizedActions(serviceType, policyDecision));
            if (set.isEmpty()) break;
        }
        return policyDecision;
    }

    boolean isEmpty() {
        return this.referrals.isEmpty();
    }

    Set getResourceNames(SSOToken sSOToken, String string, String string2) throws PolicyException, SSOException {
        HashSet hashSet = new HashSet();
        Set set = this.getReferralNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Referral referral = this.getReferral(string3);
            if (referral instanceof OrgReferral) continue;
            Set set2 = referral.getResourceNames(sSOToken, string, string2);
            hashSet.addAll(set2);
        }
        return hashSet;
    }
}

