/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ReferralTypeManager {
    private static String REFERRAL = "Referral";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static Debug debug = PolicyManager.debug;
    private static ServiceSchemaManager ssm;

    protected ReferralTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String string = this.token.getProperty("Locale");
        java.util.Locale locale = Locale.getLocale(string);
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    protected ReferralTypeManager(PolicyManager policyManager) {
        java.util.Locale locale;
        this.pm = policyManager;
        this.token = policyManager.token;
        try {
            String string = this.token.getProperty("Locale");
            locale = Locale.getLocale(string);
        }
        catch (SSOException sSOException) {
            debug.error("ConditionTypeManager:Unable to retreive locale from SSOToken", sSOException);
            locale = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + locale + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    public Set getReferralTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(REFERRAL);
    }

    public Set getSelectedReferralTypeNames() throws SSOException, PolicyException {
        Map map = this.pm.getPolicyConfig();
        Set set = null;
        if (map != null) {
            set = (Set)map.get("iplanet-am-policy-selected-referrals");
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public String getReferralTypeName(Referral referral) {
        return ReferralTypeManager.referralTypeName(referral);
    }

    protected String getI18NPropertiesFileName(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(REFERRAL, string);
        return null;
    }

    public String getI18NKey(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(REFERRAL, string);
        if (pluginSchema != null) {
            return pluginSchema.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String string) {
        String string2 = null;
        String string3 = this.getI18NKey(string);
        string2 = string3 == null || string3.length() == 0 ? string : Locale.getString(this.rb, string3, debug);
        return string2;
    }

    public Referral getReferral(String string) throws NameNotFoundException, PolicyException {
        Object object;
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(REFERRAL, string);
        if (pluginSchema == null) {
            throw new NameNotFoundException("amPolicy", "invalid_referral", null, string, 5);
        }
        Referral referral = null;
        try {
            object = pluginSchema.getClassName();
            referral = (Referral)Class.forName((String)object).newInstance();
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
        object = this.pm.getPolicyConfig();
        referral.initialize((Map)object);
        return referral;
    }

    static String referralTypeName(Referral referral) {
        if (referral == null) {
            return null;
        }
        String string = null;
        String string2 = referral.getClass().getName();
        Iterator iterator = PolicyManager.getPluginSchemaNames(REFERRAL).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            PluginSchema pluginSchema = PolicyManager.getPluginSchema(REFERRAL, string3);
            if (!string2.equals(pluginSchema.getClassName())) continue;
            string = string3;
            break;
        }
        return string;
    }

    public String getViewBeanURL(Referral referral) {
        return PolicyManager.getViewBeanURL(REFERRAL, referral.getClass().getName());
    }
}

