/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.AMResourceBundleCache;
import com.sun.identity.common.L10NMessage;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

class ChainedException
extends Exception
implements L10NMessage {
    private String _message;
    private Throwable _nestedException;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String _bundleName;
    private String _errorCode;
    private Object[] _args;
    private ResourceBundle _bundle;

    public ChainedException(String string, Throwable throwable) {
        this._message = string;
        this._nestedException = throwable;
    }

    public ChainedException(Throwable throwable) {
        this._nestedException = throwable;
        if (this._nestedException instanceof L10NMessage) {
            L10NMessage l10NMessage = (L10NMessage)((Object)this._nestedException);
            this._message = l10NMessage.getMessage();
            this._bundleName = l10NMessage.getResourceBundleName();
            this._errorCode = l10NMessage.getErrorCode();
            this._args = l10NMessage.getMessageArgs();
        }
    }

    public ChainedException(String string) {
        this._message = string;
    }

    public ChainedException(String string, String string2, Object[] objectArray, Throwable throwable) {
        this._bundleName = string;
        this._errorCode = string2;
        this._args = objectArray;
        this._nestedException = throwable;
        this._message = this.getCompleteL10NMessage(Locale.ENGLISH);
    }

    public String getL10NMessage(Locale locale) {
        String string = this._message;
        if (this._errorCode != null && this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String string2 = this._bundle.getString(this._errorCode);
            string = this._args == null || this._args.length == 0 ? string2 : MessageFormat.format(string2, this._args);
        }
        return string;
    }

    public String getCompleteL10NMessage(Locale locale) {
        String string;
        String string2 = this._message;
        if (this._errorCode != null && this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            string = this._bundle.getString(this._errorCode);
            string2 = this._args == null || this._args.length == 0 ? string : MessageFormat.format(string, this._args);
        }
        string = null;
        if (this._nestedException != null) {
            if (this._nestedException instanceof L10NMessage) {
                L10NMessage l10NMessage = (L10NMessage)((Object)this._nestedException);
                string = l10NMessage.getL10NMessage(locale);
            } else {
                string = this._nestedException.getMessage();
            }
        }
        if (string != null) {
            string2 = string2 != null ? string2 + "\n" + string : string;
        }
        return string2;
    }

    public String getResourceBundleName() {
        return this._bundleName;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public Object[] getMessageArgs() {
        return this._args;
    }

    public String getMessage() {
        String string = this._message;
        String string2 = null;
        if (this._nestedException != null) {
            string2 = this._nestedException.getMessage();
        }
        string = string2 != null ? (string != null ? this._message + "\n" + string2 : string2) : this._message;
        return string;
    }

    public void printStackTrace() {
        System.err.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.fetchStackTrace());
    }

    private String getLocalMessage() {
        return this._message;
    }

    private String fetchStackTrace() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Throwable throwable = this;
        stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + ((ChainedException)throwable).getLocalMessage() + "\n");
        while (throwable instanceof ChainedException && ((ChainedException)throwable)._nestedException != null) {
            throwable = ((ChainedException)throwable)._nestedException;
            ++n;
            if (throwable instanceof ChainedException) {
                stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + ((ChainedException)throwable).getLocalMessage() + "\n");
                continue;
            }
            stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + throwable.getMessage() + "\n");
        }
        if (throwable == this) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((ChainedException)throwable).printExceptionStackTrace(printWriter);
            string = stringWriter.getBuffer().toString();
        } else {
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.printExceptionStackTrace(new PrintWriter(stringWriter2));
            StringBuffer stringBuffer2 = stringWriter.getBuffer();
            StringBuffer stringBuffer3 = stringWriter2.getBuffer();
            stringBuffer2.insert(0, stringBuffer.toString());
            string = stringBuffer2.toString();
        }
        return string;
    }

    private void printExceptionStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public Throwable getNestedException() {
        return this._nestedException;
    }
}

