/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ActionDecision {
    static final String ACTION_DECISION = "ActionDecision";
    static final String ADVICES = "Advices";
    static final String VALUES = "Values";
    static final String TIME_TO_LIVE = "timeToLive";
    static Debug debug = Debug.getInstance("amPolicy");
    private String actionName;
    private Set values;
    private long timeToLive = Long.MAX_VALUE;
    private Map advices;
    public static final String CLIENT_CLOCK_SKEW = "com.sun.identity.policy.client.clockSkew";
    private static final long clientClockSkew = ActionDecision.getClientClockSkew();

    public ActionDecision() {
    }

    public ActionDecision(String string, Set set) {
        this.actionName = string;
        this.values = set;
    }

    public ActionDecision(String string, Set set, Map map, long l) {
        this.actionName = string;
        this.values = set;
        this.advices = map;
        this.timeToLive = l;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setValues(Set set) {
        this.values = set;
    }

    public Set getValues() {
        return this.values;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public void setAdvices(Map map) {
        this.advices = map;
    }

    public Map getAdvices() {
        return this.advices;
    }

    public String toString() {
        return this.actionName + "=" + this.values;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(ACTION_DECISION).append(" ");
        stringBuffer.append(TIME_TO_LIVE).append("=").append(PolicyUtils.quote(this.timeToLive) + ">");
        stringBuffer.append("\r\n");
        stringBuffer.append(PolicyUtils.attributeValuePairToXMLString(this.getActionName(), this.values));
        stringBuffer.append("<").append(ADVICES).append(">").append("\r\n");
        if (this.advices != null) {
            stringBuffer.append(PolicyUtils.mapToXMLString(this.advices));
        }
        stringBuffer.append("</").append(ADVICES).append(">").append("\r\n");
        stringBuffer.append("</").append(ACTION_DECISION).append(">").append("\r\n");
        return stringBuffer.toString();
    }

    public static ActionDecision parseActionDecision(Node node) throws PolicyException {
        ActionDecision actionDecision = null;
        Set set = XMLUtils.getChildNodes(node, "AttributeValuePair");
        if (set == null || set.isEmpty()) {
            debug.error("parseActionDecision: missing element AttributeValuePair");
            return null;
        }
        Iterator iterator = set.iterator();
        Node node2 = (Node)iterator.next();
        String string = PolicyUtils.getAttributeName(node2);
        Set set2 = PolicyUtils.getAttributeValues(node2);
        actionDecision = new ActionDecision(string, set2);
        long l = Long.MAX_VALUE;
        String string2 = XMLUtils.getNodeAttributeValue(node, TIME_TO_LIVE);
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
                if (l != Long.MAX_VALUE) {
                    l += clientClockSkew;
                }
            }
            catch (Exception exception) {
                debug.error("Error while parsing timeToLive in  ActionDecision:" + string2);
                Object[] objectArray = new Object[]{new Long(l)};
                throw new PolicyException("amPolicy", "invalid_time_to_live", objectArray, exception);
            }
        }
        actionDecision.setTimeToLive(l);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        set = XMLUtils.getChildNodes(node, ADVICES);
        if (set != null && (set = XMLUtils.getChildNodes(node2 = (Node)(iterator = set.iterator()).next(), "AttributeValuePair")) != null) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                String string3 = PolicyUtils.getAttributeName(node2);
                if (string3 == null) continue;
                Set set3 = PolicyUtils.getAttributeValues(node2);
                hashMap.put(string3, set3);
            }
        }
        actionDecision.setAdvices(hashMap);
        return actionDecision;
    }

    public Object clone() {
        Iterator<Object> iterator;
        ActionDecision actionDecision = new ActionDecision();
        actionDecision.actionName = this.actionName;
        actionDecision.timeToLive = this.timeToLive;
        if (this.values != null) {
            iterator = this.values.iterator();
            actionDecision.values = new HashSet(this.values.size());
            while (iterator.hasNext()) {
                actionDecision.values.add(iterator.next());
            }
        }
        if (this.advices != null) {
            iterator = this.advices.keySet().iterator();
            actionDecision.advices = new HashMap(this.advices.size());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                actionDecision.advices.put(string, this.advices.get(string));
            }
        }
        return actionDecision;
    }

    static long getClientClockSkew() {
        long l;
        block6: {
            l = 0L;
            String string = SystemProperties.get(CLIENT_CLOCK_SKEW);
            if (string == null) {
                if (debug.messageEnabled()) {
                    debug.message("PolicyUtils.getClientClockSkew():com.sun.identity.policy.client.clockSkew Property not defined : defaulting to 0");
                }
            } else {
                try {
                    l = Long.valueOf(string) * 1000L;
                    if (debug.messageEnabled()) {
                        debug.message("PolicyUtils.getClientClockSkew():com.sun.identity.policy.client.clockSkew = " + string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debug.messageEnabled()) break block6;
                    debug.message("PolicyUtils.getClientClockSkew():com.sun.identity.policy.client.clockSkew not a long number: defaulting to 0", numberFormatException);
                }
            }
        }
        return l;
    }
}

