/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ReaderWriterLock;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger
extends java.util.logging.Logger {
    private String currentFileName = new String();
    private static LogManager lm;
    private String logName;
    protected static boolean resolveHostName;
    public static ReaderWriterLock rwLock;
    static /* synthetic */ Class class$java$lang$String;

    protected Logger(String string, String string2) {
        super(string, string2);
    }

    private static void processNewLoggerObject(Logger logger) {
        Formatter formatter = null;
        String string = LogManager.HANDLER;
        String string2 = LogManager.FORMATTER;
        String string3 = "iplanet-am-logging." + logger.logName + ".level";
        String string4 = lm.getProperty(string3);
        if (string4 != null) {
            logger.setLevel(Level.parse(string4));
        } else {
            string4 = SystemProperties.get(string3);
            if (string4 == null) {
                string4 = "INFO";
            }
            logger.setLevel(Level.parse(string4));
        }
        String string5 = lm.getProperty("com.iplanet.am.logstatus");
        if (string5 != null && string5.startsWith("INACTIVE")) {
            logger.setLevel(Level.OFF);
        }
        Class<?> clazz = null;
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
        Object[] objectArray = new Object[]{new String(logger.logName)};
        Constructor<?> constructor = null;
        Handler handler = null;
        if (string == null) {
            Debug.error("Logger: HandlerClass not in classpath ");
            return;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            Debug.error("Logger: HandlerClass not in classpath: " + string, exception);
            return;
        }
        try {
            if (clazz != null) {
                constructor = clazz.getDeclaredConstructor(classArray);
            }
        }
        catch (Exception exception) {
            Debug.error("Logger: constructor parameter mismatch ", exception);
            return;
        }
        try {
            if (constructor != null) {
                handler = (Handler)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            Debug.error("Logger: Couldn't instantiate handler: " + string, exception);
            return;
        }
        if (string2 == null) {
            Debug.error("Logger: formatterClass not in classpath ");
            return;
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
        }
        catch (Exception exception) {
            Debug.error("Logger: Couldn't load Formatter Class: " + string2, exception);
            return;
        }
        try {
            if (clazz != null) {
                formatter = (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            Debug.error("Logger: Couldn't get Formatter instance " + string2, exception);
            return;
        }
        try {
            handler.setFormatter(formatter);
            logger.addHandler(handler);
        }
        catch (Exception exception) {
            Debug.error("Logger: Unable to add Handler", exception);
            return;
        }
        String string6 = lm.getProperty("iplanet-am-logging-filter-class-name");
        try {
            if (string6 != null) {
                Filter filter = (Filter)Class.forName(string6).newInstance();
                logger.setFilter(filter);
            }
        }
        catch (Exception exception) {
            Debug.error("Logger: CouldNot set Filter: " + string6, exception);
        }
        logger.setUseParentHandlers(false);
    }

    public void log(java.util.logging.LogRecord logRecord) {
        this.log(logRecord, null);
    }

    public void log(java.util.logging.LogRecord logRecord, Object object) {
        String string;
        String string2;
        String string3 = this.getName();
        if (!LogManager.isLocal) {
            if (object == null) {
                Debug.error(string3 + ":Logger.log(): remote logging, ssoToken is null, will not log");
                return;
            }
        } else if (!Authorizer.isAuthorized((String)string3, (String)"MODIFY", (Object)object)) {
            Debug.error(string3 + ":Logger.log(): authorization failed, will not log");
            return;
        }
        SSOToken sSOToken = null;
        LogRecord logRecord2 = (LogRecord)logRecord;
        if (object instanceof SSOToken) {
            sSOToken = (SSOToken)object;
            string2 = sSOToken.getTokenID().toString();
            logRecord2.addLogInfo("LoggedBySid", string2);
            string = null;
            try {
                string = sSOToken.getPrincipal().getName();
            }
            catch (SSOException sSOException) {
                Debug.error(string3 + ":Logger.log(): could not get clientID from ssoToken", sSOException);
            }
            logRecord2.addLogInfo("LoggedBy", string);
        }
        if ((string2 = (String)logRecord2.getLogInfoMap().get("ModuleName")) == null || string2.length() <= 0) {
            logRecord2.addLogInfo("ModuleName", this.getName());
        }
        logRecord2.setLoggerName(this.getName());
        string = this.getResourceBundleName();
        ResourceBundle resourceBundle = null;
        if (string != null) {
            resourceBundle = ResourceBundle.getBundle(string);
            logRecord2.setResourceBundle(resourceBundle);
        }
        try {
            rwLock.readRequest();
            Logger logger = this;
            synchronized (logger) {
                super.log(logRecord2);
            }
            Object var12_12 = null;
            rwLock.readDone();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            rwLock.readDone();
            throw throwable;
        }
    }

    public void flush() {
        Logger logger = this;
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray != null) {
            int n = 0;
            while (n < handlerArray.length) {
                handlerArray[n].flush();
                ++n;
            }
        }
    }

    public static synchronized java.util.logging.Logger getLogger(String string) {
        if (string == null || string.length() == 0 || string.indexOf("..") >= 0) {
            return null;
        }
        boolean bl = false;
        Enumeration<String> enumeration = lm.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            bl = true;
        }
        if (bl) {
            Logger logger = (Logger)lm.getLogger(string);
            return logger;
        }
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(string);
        lm.addLogger(logger);
        Logger logger2 = (Logger)lm.getLogger(string);
        logger2.logName = string;
        Logger.processNewLoggerObject(logger2);
        return logger2;
    }

    public static synchronized java.util.logging.Logger getLogger(String string, String string2) {
        if (string == null || string.length() == 0 || string.indexOf("..") >= 0) {
            return null;
        }
        boolean bl = false;
        Enumeration<String> enumeration = lm.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            bl = true;
        }
        Logger logger = (Logger)java.util.logging.Logger.getLogger(string, string2);
        logger.logName = string;
        if (bl) {
            return logger;
        }
        Logger.processNewLoggerObject(logger);
        return logger;
    }

    public String getCurrentFile() {
        return this.currentFileName;
    }

    public void setCurrentFile(String string) {
        this.currentFileName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        File file;
        rwLock = new ReaderWriterLock();
        lm = (LogManager)LogManagerUtil.getLogManager();
        try {
            lm.readConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = lm.getProperty("iplanet-am-logging-location");
        String string2 = lm.getProperty("iplanet-am-logging-type");
        if (string != null && string2.equals("File") && !(file = new File(string)).exists() && !file.mkdirs()) {
            Debug.error("Logger: Creation of Log Directory failed: " + string);
        }
        resolveHostName = Boolean.valueOf(SystemProperties.get("com.sun.identity.log.resolveHostName", "true"));
    }
}

