/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesProvider;
import java.security.ProviderException;

public class IdServicesFactory {
    private static IdServices idServices;
    private static Debug debug;
    private static boolean isInitialized;
    private static final String CONFIGURED_SDK_PACKAGE_PROPERTY = "com.iplanet.am.sdk.package";
    private static final String SERVER_IDM_PACKAGE = "com.sun.identity.idm.server";
    private static final String REMOTE_IDM_PACKAGE = "com.sun.identity.idm.remote";
    private static final String ID_SERVICES_PROVIDER_CLASS = "IdServicesProviderImpl";
    private static final String REMOTE_SERVICES_PROVIDER_CLASS = "IdRemoteServicesProviderImpl";
    private static final String PACKAGE_SEPARATOR = ".";

    private static void initialize() {
        String string = SystemProperties.get(CONFIGURED_SDK_PACKAGE_PROPERTY);
        if (string == null || string.equals(SERVER_IDM_PACKAGE)) {
            try {
                IdServicesFactory.instantiateImpls(SERVER_IDM_PACKAGE, ID_SERVICES_PROVIDER_CLASS);
            }
            catch (ProviderException providerException) {
                if (debug.messageEnabled()) {
                    debug.message("IdServicesFactory.static{} - Initializing the server packages failed. Hence trying the remote client sdk pacakage");
                }
                IdServicesFactory.instantiateImpls(REMOTE_IDM_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS);
            }
        } else if (string.equals(REMOTE_IDM_PACKAGE)) {
            IdServicesFactory.instantiateImpls(REMOTE_IDM_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS);
        } else {
            IdServicesFactory.instantiateImpls(SERVER_IDM_PACKAGE, ID_SERVICES_PROVIDER_CLASS);
        }
        AMDirectoryAccessFactory.getDirectoryServices();
        isInitialized = true;
    }

    private static void instantiateImpls(String string, String string2) {
        String string3 = string + PACKAGE_SEPARATOR + string2;
        try {
            IdServicesProvider idServicesProvider = (IdServicesProvider)Class.forName(string3).newInstance();
            idServices = idServicesProvider.getProvider();
        }
        catch (InstantiationException instantiationException) {
            debug.error("IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", instantiationException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.error("IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", illegalAccessException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", classNotFoundException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        if (debug.messageEnabled()) {
            debug.message("IdServicesFactory.instantiateImpls() - Successfully initialized Impls Using Impl Package: " + string + " for accessing Directory Services");
        }
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    public static IdServices getDataStoreServices() {
        if (!IdServicesFactory.isInitialized()) {
            IdServicesFactory.initialize();
        }
        return idServices;
    }

    static {
        debug = Debug.getInstance("amIdm");
        isInitialized = false;
    }
}

