/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public final class AMIdentityRepository {
    private SSOToken token;
    private String org;
    private IdRepo pluginClass;
    public static Debug debug = Debug.getInstance("amIdm");
    public static Map listeners = new CaseInsensitiveHashMap();

    public AMIdentityRepository(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        this.token = sSOToken;
        this.org = DNMapper.orgNameToDN(string);
    }

    public Set getSupportedIdTypes() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set set = idServices.getSupportedTypes(this.token, this.org);
        set.remove(IdType.REALM);
        return set;
    }

    public Set getAllowedIdOperations(IdType idType) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getSupportedOperations(this.token, idType, this.org);
    }

    public IdSearchResults getSpecialIdentities(IdType idType) throws IdRepoException, SSOException {
        return this.getSpecialIdentities(this.token, idType, this.org);
    }

    public IdSearchResults searchIdentities(IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, boolean bl2) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.search(this.token, idType, string, map, bl, n, n2, set, this.org);
    }

    public IdSearchResults searchIdentities(IdType idType, String string, IdSearchControl idSearchControl) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.search(this.token, idType, string, idSearchControl, this.org);
    }

    public AMIdentity getRealmIdentity() throws IdRepoException, SSOException {
        String string = "id=ContainerDefaultTemplateRole,ou=realm," + this.org;
        return IdUtils.getIdentity(this.token, string);
    }

    public AMIdentity createIdentity(IdType idType, String string, Map map) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.create(this.token, idType, string, map, this.org);
    }

    public Set createIdentities(IdType idType, Map map) throws IdRepoException, SSOException {
        HashSet<AMIdentity> hashSet = new HashSet<AMIdentity>();
        if (map == null || map.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map2 = (Map)map.get(string);
            AMIdentity aMIdentity = idServices.create(this.token, idType, string, map2, this.org);
            hashSet.add(aMIdentity);
        }
        return hashSet;
    }

    public void deleteIdentities(IdType idType, Set set) throws IdRepoException, SSOException {
        if (set == null || set.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMIdentity aMIdentity = (AMIdentity)iterator.next();
            idServices.delete(this.token, aMIdentity.getType(), aMIdentity.getName(), this.org, aMIdentity.DN);
        }
    }

    public int addEventListener(IdEventListener idEventListener) {
        ArrayList<IdEventListener> arrayList = (ArrayList<IdEventListener>)listeners.get(this.org);
        if (arrayList == null) {
            arrayList = new ArrayList<IdEventListener>();
        }
        Map map = listeners;
        synchronized (map) {
            arrayList.add(idEventListener);
            listeners.put(this.org, arrayList);
        }
        return arrayList.size() - 1;
    }

    public void removeEventListener(int n) {
        ArrayList arrayList = (ArrayList)listeners.get(this.org);
        if (arrayList != null) {
            Map map = listeners;
            synchronized (map) {
                arrayList.remove(n);
            }
        }
    }

    public IdSearchResults getSpecialIdentities(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        Object object;
        Object object2;
        Object object3;
        OrderedSet orderedSet = new OrderedSet();
        IdRepo idRepo = null;
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object3 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            if (this.pluginClass == null) {
                try {
                    object2 = Class.forName((String)object3);
                    idRepo = (IdRepo)((Class)object2).newInstance();
                    idRepo.initialize(new HashMap());
                    object = new HashMap();
                    object.put("realm", string);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap((Map)object);
                    idRepo.addListener(sSOToken, idRepoListener);
                    this.pluginClass = idRepo;
                    Set set = idRepo.getSupportedOperations(idType);
                    if (set != null && set.contains(IdOperation.READ)) {
                        orderedSet.add(idRepo);
                    }
                }
                catch (Exception exception) {
                    debug.error("Unable to instantiate plugin: " + (String)object3, exception);
                }
            } else {
                object2 = this.pluginClass.getSupportedOperations(idType);
                if (object2 != null && object2.contains(IdOperation.READ)) {
                    orderedSet.add(this.pluginClass);
                }
            }
        }
        if (orderedSet.isEmpty()) {
            return new IdSearchResults(idType, string);
        }
        object3 = (IdRepo)orderedSet.iterator().next();
        object2 = ((IdRepo)object3).search(sSOToken, idType, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        object = new Object[1][2];
        object[0][0] = object2;
        object[0][1] = Collections.EMPTY_MAP;
        return this.combineSearchResults(sSOToken, (Object[][])object, 1, idType, string, false, null);
    }

    private Map reverseMapAttributeNames(Map map, Map map2) {
        Map map3;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map[] mapArray = this.getAttributeNameMap(map2);
        if (mapArray == null) {
            map3 = map;
        } else {
            map3 = new CaseInsensitiveHashMap();
            Map map4 = mapArray[1];
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map4.containsKey(string)) {
                    map3.put((String)map4.get(string), (Set)map.get(string));
                    continue;
                }
                map3.put(string, (Set)map.get(string));
            }
        }
        return map3;
    }

    private IdSearchResults combineSearchResults(SSOToken sSOToken, Object[][] objectArray, int n, IdType idType, String string, boolean bl, Object[][] objectArray2) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap caseInsensitiveHashMap2 = new CaseInsensitiveHashMap();
        int n2 = 0;
        if (bl) {
            RepoSearchResults repoSearchResults = (RepoSearchResults)objectArray2[0][0];
            object5 = (Map)objectArray2[0][1];
            object4 = repoSearchResults.getSearchResults();
            iterator = repoSearchResults.getResultAttributes();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                string2 = new DN((String)object2).explodeDN(true)[0];
                caseInsensitiveHashMap.put(string2, object2);
                object = new HashSet();
                object.add((Map)iterator.get(object2));
                caseInsensitiveHashMap2.put(string2, object);
            }
            n2 = repoSearchResults.getErrorCode();
        }
        int n3 = 0;
        while (n3 < n) {
            object5 = (RepoSearchResults)objectArray[n3][0];
            object4 = (Map)objectArray[n3][1];
            iterator = ((RepoSearchResults)object5).getSearchResults().iterator();
            object3 = ((RepoSearchResults)object5).getResultAttributes();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                string2 = object2;
                object = (Map)object3.get(object2);
                if (DN.isDN((String)object2)) {
                    string2 = new DN((String)object2).explodeDN(true)[0];
                }
                object = this.reverseMapAttributeNames((Map)object, (Map)object4);
                HashSet<Object> hashSet = (HashSet<Object>)caseInsensitiveHashMap2.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                }
                hashSet.add(object);
                caseInsensitiveHashMap2.put(string2, hashSet);
            }
            ++n3;
        }
        object5 = new IdSearchResults(idType, string);
        object4 = caseInsensitiveHashMap2.keySet().iterator();
        while (object4.hasNext()) {
            iterator = (String)object4.next();
            object3 = this.combineAttrMaps((Set)caseInsensitiveHashMap2.get(iterator), true);
            object2 = new AMIdentity(sSOToken, (String)((Object)iterator), idType, string, (String)caseInsensitiveHashMap.get(iterator));
            ((IdSearchResults)object5).addResult((AMIdentity)object2, (Map)object3);
        }
        ((IdSearchResults)object5).setErrorCode(n2);
        return object5;
    }

    private Map[] getAttributeNameMap(Map map) {
        Set set = (Set)map.get("sunIdRepoAttributeMapping");
        if (set == null || set.isEmpty()) {
            return null;
        }
        Map[] mapArray = new Map[2];
        int n = set.size();
        mapArray[0] = new CaseInsensitiveHashMap(n);
        mapArray[1] = new CaseInsensitiveHashMap(n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.indexOf(61);
            if (n2 > -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                mapArray[0].put(string2, string3);
                mapArray[1].put(string3, string2);
                continue;
            }
            mapArray[0].put(string, string);
            mapArray[1].put(string, string);
        }
        return mapArray;
    }

    private Map combineAttrMaps(Set set, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (map == null) continue;
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                String string = (String)iterator2.next();
                if (bl) {
                    object2 = (Set)aMHashMap.get(string);
                    object = (Set)map.get(string);
                    if (object2 != null) {
                        object2.addAll(object);
                        continue;
                    }
                    object2 = new HashSet((Set)map.get(string));
                    aMHashMap.put(string, object2);
                    continue;
                }
                object2 = (byte[][])aMHashMap.get(string);
                object = (byte[][])map.get(string);
                int n = ((Object)object).length;
                if (object2 != null) {
                    n = ((Object)object2).length + ((Object)object).length;
                    byte[][] byArrayArray = new byte[n][];
                    int n2 = 0;
                    while (n2 < ((HashSet<E>)object2).length) {
                        byArrayArray[n2] = (byte[])object2[n2];
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        byArrayArray[n3] = (byte[])object[n3];
                        ++n3;
                    }
                    object2 = byArrayArray;
                } else {
                    object2 = (byte[][])object.clone();
                }
                aMHashMap.put(string, object2);
            }
        }
        return aMHashMap;
    }
}

