/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSScoping;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.RequestAuthnContext;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSAuthnRequest
extends AbstractRequest {
    private boolean isPassive = false;
    private boolean forceAuthn = false;
    private boolean federate = false;
    private String nameIDPolicy = null;
    private String protocolProfile = null;
    private String providerId = null;
    private RequestAuthnContext authnContext = null;
    private String relayState = null;
    protected String xmlString = null;
    protected String signatureString = null;
    protected String authContextCompType = null;
    protected String id = null;
    protected String assertionConsumerServiceID = null;
    protected String consentURI = null;
    protected String affiliationID = null;
    protected int minorVersion = 0;
    protected FSScoping scoping = null;

    public FSAuthnRequest() {
        this.setIssueInstant(new Date());
    }

    public FSAuthnRequest(String string, List list, List list2, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, RequestAuthnContext requestAuthnContext, String string5, String string6) throws FSMsgException {
        this.setIssueInstant(new Date());
        if (list != null && list != Collections.EMPTY_LIST) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!(e instanceof String)) {
                    FSUtils.debug.error("FSAuthnRequest: wrong input for RespondWith");
                    throw new FSMsgException("wrongInput", null);
                }
                ++n2;
            }
            this.respondWiths = list;
        }
        if (string != null && !string.equals("")) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest: couldn't gen RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.isPassive = bl2;
        this.forceAuthn = bl;
        this.providerId = string2;
        this.federate = bl3;
        this.nameIDPolicy = string3;
        this.protocolProfile = string4;
        this.relayState = string5;
        this.authnContext = requestAuthnContext;
        this.authContextCompType = string6;
        this.id = this.requestID;
    }

    public FSAuthnRequest(Element element) throws FSMsgException {
        Object object;
        String string = null;
        if (element == null) {
            FSUtils.debug.error("FSAuthnRequest(Element): null input.");
            throw new FSMsgException("nullInput", null);
        }
        string = element.getLocalName();
        if (string == null || !string.equals("AuthnRequest")) {
            FSUtils.debug.error("FSAuthnRequest(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.error("FSAuthnRequest(Element): missing IssueInstant");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            FSUtils.debug.error("FSAuthnRequest(Element): could not parse IssueInstant", parseException);
            throw new FSMsgException("wrongInput", null);
        }
        this.consentURI = element.getAttribute("consent");
        this.id = element.getAttribute("id");
        this.requestID = element.getAttribute("RequestID");
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null) {
                if (string3.equals("RespondWith")) {
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(XMLUtils.getElementValue((Element)node));
                } else if (!string3.equals("Signature")) {
                    if (string3.equals("ProviderID")) {
                        if (this.providerId != null && !this.providerId.equals("")) {
                            FSUtils.debug.error("FSAuthnRequest(Element): shouldcontain only one ProviderID.");
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.providerId = XMLUtils.getElementValue((Element)node);
                    } else if (string3.equals("NameIDPolicy")) {
                        this.nameIDPolicy = XMLUtils.getElementValue((Element)node);
                        if (this.nameIDPolicy != null && (this.nameIDPolicy.equals("federated") || this.nameIDPolicy.equals("onetime"))) {
                            this.federate = true;
                        }
                    } else if (string3.equals("Federate")) {
                        object = XMLUtils.getElementValue((Element)node);
                        if (object != null && !((String)object).equals("") && ((String)object).equals("true") || ((String)object).equals("1")) {
                            this.federate = true;
                        }
                    } else if (string3.equals("IsPassive")) {
                        object = XMLUtils.getElementValue((Element)node);
                        this.isPassive = object != null && !((String)object).equals("") && ((String)object).equals("true");
                    } else if (string3.equals("ForceAuthn")) {
                        object = XMLUtils.getElementValue((Element)node);
                        this.forceAuthn = object != null && !((String)object).equals("") && ((String)object).equals("true");
                    } else if (string3.equals("ProtocolProfile")) {
                        if (this.protocolProfile != null && !this.protocolProfile.equals("")) {
                            FSUtils.debug.error("FSAuthnRequest(Element): should contain only one ProtocolProfile.");
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.protocolProfile = XMLUtils.getElementValue((Element)node);
                    } else if (string3.equals("AuthnContext")) {
                        this.authnContext = new RequestAuthnContext((Element)node);
                    } else if (string3.equals("RequestAuthnContext")) {
                        this.authnContext = new RequestAuthnContext((Element)node);
                    } else if (string3.equals("RelayState")) {
                        this.relayState = XMLUtils.getElementValue((Element)node);
                    } else if (string3.equals("AuthnContextComparison")) {
                        this.authContextCompType = XMLUtils.getElementValue((Element)node);
                        if (!(this.authContextCompType.equals("minimum") || this.authContextCompType.equals("exact") || this.authContextCompType.equals("maximum") || this.authContextCompType.equals("better"))) {
                            throw new FSMsgException("wrongInput", null);
                        }
                    } else if (string3.equals("AssertionConsumerServiceID")) {
                        this.assertionConsumerServiceID = XMLUtils.getElementValue((Element)node);
                    } else if (string3.equals("AffiliationID")) {
                        this.affiliationID = XMLUtils.getElementValue((Element)node);
                    } else if (string3.equals("Extension")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthnRequest(Element): Extensions are not supported");
                        }
                    } else if (string3.equals("Scoping")) {
                        this.scoping = new FSScoping((Element)node);
                    } else {
                        FSUtils.debug.error("FSAuthnRequest(Element): invalid node" + string3);
                        throw new FSMsgException("wrongInput", null);
                    }
                }
            }
            ++n2;
        }
        object = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n3 = object.size();
        if (n3 == 1) {
            Element element2 = (Element)object.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
        } else if (n3 != 0) {
            FSUtils.debug.error("FSAuthnRequest(Element): included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        if (this.xmlString != null) {
            return this.xmlString;
        }
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSAuthnRequest.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("nullProviderIdWRequestId") + this.requestID);
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string = "lib:";
            string2 = "samlp:";
        }
        if (bl2) {
            string3 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string4 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String string5 = DateUtils.toUTCDateFormat(this.issueInstant);
        if (this.requestID != null) {
            Object object;
            stringBuffer.append("<").append(string).append("AuthnRequest").append(string3).append(" ").append(string4);
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\" ");
            }
            stringBuffer.append(" RequestID=\"").append(this.requestID).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string5).append("\"");
            if (this.consentURI != null) {
                stringBuffer.append(" consent=\"").append(this.consentURI).append("\"");
            }
            stringBuffer.append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                object = this.respondWiths.iterator();
                while (object.hasNext()) {
                    stringBuffer.append("<").append(string2).append("RespondWith>").append((String)object.next()).append("</").append(string2).append("RespondWith>");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    stringBuffer.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print(this.signature);
                    stringBuffer.append(this.signatureString);
                }
            }
            stringBuffer.append("<").append(string).append("ProviderID").append(">").append(this.providerId).append("</").append(string).append("ProviderID").append(">");
            if (this.affiliationID != null) {
                stringBuffer.append("<").append(string).append("AffiliationID").append(">").append(this.affiliationID).append("</").append(string).append("AffiliationID").append(">");
            }
            if (this.minorVersion == 2) {
                object = "none";
                if (this.federate) {
                    object = "federated";
                    if (this.nameIDPolicy != null && this.nameIDPolicy.length() > 0) {
                        object = this.nameIDPolicy;
                    }
                }
                stringBuffer.append("<").append(string).append("NameIDPolicy").append(">").append((String)object).append("</").append(string).append("NameIDPolicy").append(">");
            } else {
                object = "false";
                if (this.federate) {
                    object = "true";
                }
                stringBuffer.append("<").append(string).append("Federate").append(">").append((String)object).append("</").append(string).append("Federate").append(">");
            }
            object = this.forceAuthn ? "true" : "false";
            stringBuffer.append("<").append(string).append("ForceAuthn").append(">").append((String)object).append("</").append(string).append("ForceAuthn").append(">");
            String string6 = this.isPassive ? "true" : "false";
            stringBuffer.append("<").append(string).append("IsPassive").append(">").append(string6).append("</").append(string).append("IsPassive").append(">");
            if (this.protocolProfile != null && !this.protocolProfile.equals("")) {
                stringBuffer.append("<").append(string).append("ProtocolProfile").append(">").append(this.protocolProfile).append("</").append(string).append("ProtocolProfile").append(">");
            }
            if (this.assertionConsumerServiceID != null) {
                stringBuffer.append("<").append(string).append("AssertionConsumerServiceID").append(">").append(this.assertionConsumerServiceID).append("</").append(string).append("AssertionConsumerServiceID").append(">");
            }
            if (this.authnContext != null) {
                this.authnContext.setMinorVersion(this.minorVersion);
                stringBuffer.append(this.authnContext.toXMLString());
            }
            if (this.relayState != null && !this.relayState.equals("")) {
                stringBuffer.append("<").append(string).append("RelayState").append(">").append(this.relayState).append("</").append(string).append("RelayState").append(">");
            }
            if (this.minorVersion == 2 && this.scoping != null) {
                stringBuffer.append(this.scoping.toXMLString(true, false));
            }
            if (this.minorVersion == 0 && this.authContextCompType != null && !this.authContextCompType.equals("")) {
                stringBuffer.append("<").append(string).append("AuthnContextComparison").append(">").append(this.authContextCompType).append("</").append(string).append("AuthnContextComparison").append(">");
            }
        } else {
            FSUtils.debug.error("FSAuthnRequest.toString: requestID is null ");
            throw new FSMsgException("requestID is null");
        }
        stringBuffer.append("</").append(string).append("AuthnRequest>");
        return stringBuffer.toString();
    }

    public static FSAuthnRequest parseXML(String string) throws FSMsgException {
        Document document = XMLUtils.toDOMDocument(string, FSUtils.debug);
        if (document == null) {
            FSUtils.debug.error("FSAuthnRequest.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element element = document.getDocumentElement();
        return new FSAuthnRequest(element);
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public void setForceAuthn(boolean bl) {
        this.forceAuthn = bl;
    }

    public boolean getIsPassive() {
        return this.isPassive;
    }

    public void setIsPassive(boolean bl) {
        this.isPassive = bl;
    }

    public boolean getFederate() {
        return this.federate;
    }

    public void setFederate(boolean bl) {
        this.federate = bl;
    }

    public String getNameIDPolicy() {
        return this.nameIDPolicy;
    }

    public void setNameIDPolicy(String string) {
        this.nameIDPolicy = string;
    }

    public String getProtocolProfile() {
        return this.protocolProfile;
    }

    public void setProtocolProfile(String string) {
        this.protocolProfile = string;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String string) {
        this.relayState = string;
    }

    public RequestAuthnContext getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(RequestAuthnContext requestAuthnContext) {
        this.authnContext = requestAuthnContext;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String string) {
        this.providerId = string;
    }

    public String getAuthContextCompType() {
        return this.authContextCompType;
    }

    public void setAuthContextCompType(String string) {
        this.authContextCompType = string;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public String getAffiliationID() {
        return this.affiliationID;
    }

    public void setAffiliationID(String string) {
        this.affiliationID = string;
    }

    public String getAssertionConsumerServiceID() {
        return this.assertionConsumerServiceID;
    }

    public void setAssertionConsumerServiceID(String string) {
        this.assertionConsumerServiceID = string;
    }

    public String getConsent() {
        return this.consentURI;
    }

    public void setConsent(String string) {
        this.consentURI = string;
    }

    public void setScoping(FSScoping fSScoping) {
        this.scoping = fSScoping;
    }

    public FSScoping getScoping() {
        return this.scoping;
    }

    private void parseMajorVersion(String string) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): invalid MajorVersion", numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest(Element): MajorVersion of the AuthnRequest is too high.");
                }
                throw new FSMsgException(SAMLUtilsCommon.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): MajorVersion of the AuthnRequest is too low.");
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): invalid MinorVersion", numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion == 2 || this.minorVersion == 0) {
            return;
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too low.");
        }
        throw new FSMsgException("requestVersionTooLow", null);
    }

    private static int checkMajorVersion(String string) throws FSMsgException {
        int n;
        if (string == null) {
            throw new FSMsgException("MajorVersion of the AuthnRequest is null");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMajorVersion: invalid MajorVersion: " + numberFormatException.getMessage());
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (n != 1) {
            if (n > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest.checkMajorVersion: MajorVersion of the AuthnRequest is too high" + n);
                }
                throw new FSMsgException(SAMLUtilsCommon.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMajorVersion:MajorVersion of the AuthnRequest is too low. " + n);
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("requestVersionTooLow"));
        }
        return n;
    }

    private static int checkMinorVersion(String string) throws FSMsgException {
        int n;
        if (string == null) {
            throw new FSMsgException("MinorVersion of the AuthnRequest is null");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: invalid MinorVersion", numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (n == 2 || n == 0) {
            return n;
        }
        if (n > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too low.");
        }
        throw new FSMsgException("requestVersionTooLow", null);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        int n;
        String string;
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("nullProviderIdWRequestId") + this.requestID);
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("RequestID=").append(AMURLEncDec.encode(this.requestID)).append("&");
        stringBuffer.append("MajorVersion=").append(this.majorVersion).append("&");
        stringBuffer.append("MinorVersion=").append(this.minorVersion).append("&");
        stringBuffer.append("ProviderID=").append(AMURLEncDec.encode(this.providerId)).append("&");
        if (this.consentURI != null) {
            stringBuffer.append("consent=").append(AMURLEncDec.encode(this.consentURI)).append("&");
        }
        if (this.affiliationID != null) {
            stringBuffer.append("AffiliationID=").append(AMURLEncDec.encode(this.affiliationID)).append("&");
        }
        if (this.issueInstant == null) {
            FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: issueInstant missing");
            throw new FSMsgException("missingAttribute", null);
        }
        stringBuffer.append("IssueInstant=").append(AMURLEncDec.encode(DateUtils.toUTCDateFormat(this.issueInstant))).append("&");
        String string2 = new String();
        string2 = this.forceAuthn ? "true" : "false";
        stringBuffer.append("ForceAuthn=").append(string2).append("&");
        String string3 = new String();
        string3 = this.isPassive ? "true" : "false";
        stringBuffer.append("IsPassive=").append(string3).append("&");
        if (this.minorVersion == 2) {
            string = "none";
            if (this.federate) {
                string = "federated";
                if (this.nameIDPolicy != null && this.nameIDPolicy.length() > 0) {
                    string = this.nameIDPolicy;
                }
            }
            stringBuffer.append("NameIDPolicy=").append(string).append("&");
        } else {
            string = "false";
            if (this.federate) {
                string = "true";
            }
            stringBuffer.append("Federate=").append(string).append("&");
        }
        if (this.protocolProfile != null && !this.protocolProfile.equals("")) {
            stringBuffer.append("ProtocolProfile=").append(AMURLEncDec.encode(this.protocolProfile)).append("&");
        }
        if (this.authnContext != null) {
            this.authnContext.setMinorVersion(this.minorVersion);
            stringBuffer.append(this.authnContext.toURLEncodedQueryString());
        }
        if (this.relayState != null && !this.relayState.equals("")) {
            stringBuffer.append("RelayState=").append(AMURLEncDec.encode(this.relayState)).append("&");
        }
        if (this.scoping != null) {
            stringBuffer.append(this.scoping.toURLEncodedQueryString());
        }
        if (this.minorVersion == 0 && this.authContextCompType != null && !this.authContextCompType.equals("")) {
            stringBuffer.append("AuthnContextComparison=").append(AMURLEncDec.encode(this.authContextCompType)).append("&");
        }
        if (stringBuffer.charAt(n = stringBuffer.length() - 1) == '&') {
            stringBuffer = stringBuffer.deleteCharAt(n);
        }
        return stringBuffer.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSAuthnRequest.toBASE64EncodedString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("nullProviderIdWRequestId") + this.requestID);
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toBASE64EncodedString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    public static FSAuthnRequest parseURLEncodedRequest(HttpServletRequest httpServletRequest) throws FSMsgException {
        String string;
        FSAuthnRequest fSAuthnRequest = new FSAuthnRequest();
        if (httpServletRequest.getParameter("RequestID") == null || httpServletRequest.getParameter("RequestID").equals("")) {
            throw new FSMsgException("RequestID in the AuthnRequest is null");
        }
        fSAuthnRequest.requestID = httpServletRequest.getParameter("RequestID");
        String string2 = httpServletRequest.getParameter("IssueInstant");
        if (string2 == null || string2.equals("")) {
            throw new FSMsgException("missingAttribute");
        }
        try {
            fSAuthnRequest.issueInstant = DateUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            throw new FSMsgException(parseException.getMessage());
        }
        fSAuthnRequest.majorVersion = FSAuthnRequest.checkMajorVersion(httpServletRequest.getParameter("MajorVersion"));
        fSAuthnRequest.minorVersion = FSAuthnRequest.checkMinorVersion(httpServletRequest.getParameter("MinorVersion"));
        if (httpServletRequest.getParameter("ProviderID") == null || httpServletRequest.getParameter("ProviderID").equals("")) {
            throw new FSMsgException("ProviderID of the AuthnRequest is null");
        }
        FSUtils.debug.message("ProviderID of the sender: " + httpServletRequest.getParameter("ProviderID"));
        fSAuthnRequest.providerId = httpServletRequest.getParameter("ProviderID");
        fSAuthnRequest.affiliationID = httpServletRequest.getParameter("AffiliationID");
        fSAuthnRequest.forceAuthn = httpServletRequest.getParameter("ForceAuthn") != null && !httpServletRequest.getParameter("ForceAuthn").equals("") && (httpServletRequest.getParameter("ForceAuthn").equals("true") || httpServletRequest.getParameter("ForceAuthn").equals("1"));
        fSAuthnRequest.isPassive = httpServletRequest.getParameter("IsPassive") != null && !httpServletRequest.getParameter("IsPassive").equals("") && (httpServletRequest.getParameter("IsPassive").equals("true") || httpServletRequest.getParameter("IsPassive").equals("1"));
        if (fSAuthnRequest.minorVersion == 2) {
            string = httpServletRequest.getParameter("NameIDPolicy");
            if (string != null && (string.equals("federated") || string.equals("onetime"))) {
                fSAuthnRequest.federate = true;
            }
            fSAuthnRequest.nameIDPolicy = string;
        } else {
            fSAuthnRequest.federate = httpServletRequest.getParameter("Federate") != null && !httpServletRequest.getParameter("Federate").equals("") && (httpServletRequest.getParameter("Federate").equals("true") || httpServletRequest.getParameter("Federate").equals("1"));
        }
        if (httpServletRequest.getParameter("ProtocolProfile") != null && !httpServletRequest.getParameter("ProtocolProfile").equals("")) {
            fSAuthnRequest.protocolProfile = httpServletRequest.getParameter("ProtocolProfile");
        }
        if (httpServletRequest.getParameter("RelayState") != null && !httpServletRequest.getParameter("RelayState").equals("")) {
            fSAuthnRequest.setRelayState(httpServletRequest.getParameter("RelayState"));
        }
        if (httpServletRequest.getParameter("AuthnContextComparison") != null && !httpServletRequest.getParameter("AuthnContextComparison").equals("")) {
            fSAuthnRequest.setAuthContextCompType(httpServletRequest.getParameter("AuthnContextComparison"));
            string = fSAuthnRequest.getAuthContextCompType();
            if (!(string.equals("minimum") || string.equals("exact") || string.equals("maximum") || string.equals("better"))) {
                throw new FSMsgException("wrongInput", null);
            }
        }
        fSAuthnRequest.authnContext = RequestAuthnContext.parseURLEncodedRequest((HttpServletRequest)httpServletRequest, (int)fSAuthnRequest.getMinorVersion());
        fSAuthnRequest.scoping = FSScoping.parseURLEncodedRequest((HttpServletRequest)httpServletRequest);
        return fSAuthnRequest;
    }

    public static FSAuthnRequest parseBASE64EncodedString(String string) throws FSMsgException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        if (string != null && !string.equals("")) {
            try {
                String string2 = new String(bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string.getBytes())));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest.parseBASE64EncodedString: decoded input string: " + string2);
                }
                return FSAuthnRequest.parseXML(string2);
            }
            catch (IOException iOException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest.parseBASE64EncodedString: IOException occured during encoding");
                }
                throw new FSMsgException(iOException, "IOException occured during encoding");
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequest.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSAuthnRequest.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception") + ":" + exception.getMessage());
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("Unsupported method");
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print(element);
        return super.setSignature(element);
    }
}

