/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.util.LinkedList;

public class ReaderWriterLock {
    private int currentReaders;
    private int queuedReaders;
    private int currentWriters;
    private final LinkedList writerLocks = new LinkedList();

    public synchronized void readRequest() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
        } else {
            ++this.queuedReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean readRequestImmediate() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
            return true;
        }
        return false;
    }

    public synchronized void readDone() {
        if (--this.currentReaders == 0) {
            this.notify_writers();
        }
    }

    public void writeRequest() {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            ReaderWriterLock readerWriterLock = this;
            synchronized (readerWriterLock) {
                boolean bl;
                boolean bl2 = bl = this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0;
                if (bl) {
                    ++this.currentWriters;
                    return;
                }
                this.writerLocks.addLast(object);
            }
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean writeRequestImmediate() {
        if (this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0) {
            ++this.currentWriters;
            return true;
        }
        return false;
    }

    public synchronized void writeDone() {
        --this.currentWriters;
        if (this.queuedReaders > 0) {
            this.notify_readers();
        } else {
            this.notify_writers();
        }
    }

    private void notify_readers() {
        this.currentReaders += this.queuedReaders;
        this.queuedReaders = 0;
        this.notifyAll();
    }

    private void notify_writers() {
        if (this.writerLocks.size() > 0) {
            Object e = this.writerLocks.removeFirst();
            ++this.currentWriters;
            Object e2 = e;
            synchronized (e2) {
                e.notify();
            }
        }
    }
}

