/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso.providers.dpro;

import com.iplanet.am.util.SecureRandomManager;
import com.iplanet.dpro.session.Session;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.providers.dpro.SSOPrincipal;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.iplanet.sso.providers.dpro.SSOSessionListener;
import com.iplanet.sso.providers.dpro.SSOTokenIDImpl;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import java.net.InetAddress;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.security.auth.login.LoginException;

class SSOTokenImpl
implements SSOToken {
    private Session SSOSession;
    private boolean ldapConnect = false;
    private SSOToken ssoToken = null;
    private Principal ldapBindDN;
    private HashMap ldapTokenProperty = new HashMap();

    SSOTokenImpl(Session session) {
        this.SSOSession = session;
        this.ldapConnect = false;
    }

    SSOTokenImpl(Principal principal, String string) throws SSOException {
        try {
            AuthContext authContext = new AuthContext(principal, string.toCharArray());
            if (authContext.getLoginStatus() != 3) {
                if (SSOProviderImpl.debug.messageEnabled()) {
                    SSOProviderImpl.debug.message("SSO Auth failed for " + principal.getName());
                }
                throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
            }
            this.ldapBindDN = authContext.getPrincipal();
            this.ssoToken = authContext.getSSOToken();
            this.SSOSession = null;
            this.ldapConnect = true;
            SecureRandom secureRandom = SecureRandomManager.getSecureRandom();
            String string2 = Long.toHexString(secureRandom.nextLong());
            this.setProperty("AMCtxId", string2);
        }
        catch (LoginException loginException) {
            SSOProviderImpl.debug.error("Ldap Authentication failed for the user" + principal.getName(), loginException);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
        catch (InvalidAuthContextException invalidAuthContextException) {
            SSOProviderImpl.debug.error("Ldap Authentication failed for the user" + principal.getName(), invalidAuthContextException);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Failed to create the context id for this token" + principal.getName(), exception);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
    }

    public Principal getPrincipal() throws SSOException {
        try {
            if (this.ldapConnect) {
                return this.ldapBindDN;
            }
            String string = this.SSOSession.getProperty("Principal");
            SSOPrincipal sSOPrincipal = new SSOPrincipal(string);
            return sSOPrincipal;
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.message("Can't get token principal name");
            throw new SSOException(exception);
        }
    }

    public String getAuthType() throws SSOException {
        try {
            if (this.ldapConnect) {
                return "LDAP";
            }
            String string = this.SSOSession.getProperty("AuthType");
            int n = string.indexOf("|");
            if (n != -1) {
                return string.substring(0, n);
            }
            return string;
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token authentication type");
            throw new SSOException(exception);
        }
    }

    public int getAuthLevel() throws SSOException {
        this.checkTokenType("getAuthLevel");
        try {
            return new Integer(this.SSOSession.getProperty("AuthLevel"));
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token authentication level");
            throw new SSOException(exception);
        }
    }

    public InetAddress getIPAddress() throws SSOException {
        try {
            if (this.ldapConnect) {
                return InetAddress.getLocalHost();
            }
            String string = this.SSOSession.getProperty("Host");
            if (string == null || string.equals("")) {
                throw new SSOException(SSOProviderBundle.rbName, "ipaddressnull", null);
            }
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get client's IPAddress");
            throw new SSOException(exception);
        }
    }

    public String getHostName() throws SSOException {
        try {
            if (this.ldapConnect) {
                return InetAddress.getLocalHost().getHostName();
            }
            String string = this.SSOSession.getProperty("HostName");
            if (string == null || string.equals("")) {
                throw new SSOException(SSOProviderBundle.rbName, "hostnull", null);
            }
            return string;
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get client's token Host name");
            throw new SSOException(exception);
        }
    }

    public long getTimeLeft() throws SSOException {
        this.checkTokenType("getTimeLeft");
        try {
            return this.SSOSession.getTimeLeft();
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token maximum time");
            throw new SSOException(exception);
        }
    }

    public long getMaxSessionTime() throws SSOException {
        this.checkTokenType("getMaxSessionTime");
        try {
            return this.SSOSession.getMaxSessionTime();
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token maximum time");
            throw new SSOException(exception);
        }
    }

    public long getIdleTime() throws SSOException {
        this.checkTokenType("getIdleTime");
        try {
            return this.SSOSession.getIdleTime();
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token idle time");
            throw new SSOException(exception);
        }
    }

    public long getMaxIdleTime() throws SSOException {
        this.checkTokenType("getMaxIdleTime");
        try {
            return this.SSOSession.getMaxIdleTime();
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't get token maximum idle time");
            throw new SSOException(exception);
        }
    }

    public SSOTokenID getTokenID() {
        if (this.ldapConnect) {
            if (this.ssoToken != null) {
                return this.ssoToken.getTokenID();
            }
            return null;
        }
        return new SSOTokenIDImpl(this.SSOSession.getID());
    }

    public void setProperty(String string, String string2) throws SSOException {
        if (this.ldapConnect) {
            this.ldapTokenProperty.put(string, string2);
            return;
        }
        try {
            this.SSOSession.setProperty(string, string2);
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Can't set property:  " + string + " " + string2);
            throw new SSOException(exception);
        }
    }

    public String getProperty(String string) throws SSOException {
        String string2 = null;
        if (this.ssoToken != null) {
            string2 = this.ssoToken.getProperty(string);
        }
        if (string2 == null) {
            if (this.ldapConnect) {
                string2 = (String)this.ldapTokenProperty.get(string);
            } else {
                try {
                    string2 = this.SSOSession.getProperty(string);
                }
                catch (Exception exception) {
                    SSOProviderImpl.debug.error("Can't get property: " + string);
                    throw new SSOException(exception);
                }
            }
        }
        return string2;
    }

    public void addSSOTokenListener(SSOTokenListener sSOTokenListener) throws SSOException {
        if (this.ldapConnect) {
            return;
        }
        try {
            SSOSessionListener sSOSessionListener = new SSOSessionListener(sSOTokenListener);
            this.SSOSession.addSessionListener(sSOSessionListener);
        }
        catch (Exception exception) {
            SSOProviderImpl.debug.error("Couldn't add listener to the token" + this.getTokenID().toString());
            throw new SSOException(exception);
        }
    }

    public boolean isValid() {
        try {
            block7: {
                block6: {
                    if (this.ldapConnect) {
                        return true;
                    }
                    int n = this.SSOSession.getState(true);
                    if (n == 1) break block6;
                    if (n != 2) break block7;
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void validate() throws SSOException {
        try {
            block7: {
                block6: {
                    if (this.ldapConnect) {
                        return;
                    }
                    int n = this.SSOSession.getState(true);
                    if (n == 1) break block6;
                    if (n != 2) break block7;
                }
                return;
            }
            throw new SSOException(SSOProviderBundle.rbName, "invalidstate", null);
        }
        catch (Exception exception) {
            throw new SSOException(exception);
        }
    }

    public boolean isLdapConnection() {
        return this.ldapConnect;
    }

    protected void setStatus(boolean bl) {
        this.ldapConnect = bl;
    }

    public String encodeURL(String string) {
        this.checkTokenType("encodeURL");
        return this.SSOSession.encodeURL(string);
    }

    public void checkTokenType(String string) {
        if (this.ldapConnect) {
            String string2 = string + "is an unsupported operation for tokens created" + "by direct ldap connection";
            SSOProviderImpl.debug.error(string2);
            throw new UnsupportedOperationException(string2);
        }
    }

    Session getSession() {
        return this.SSOSession;
    }
}

