/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.sun.identity.authentication.internal.AuthSSOProvider;
import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class SSOTokenManager {
    static final String GRAPPA_PROVIDER_PACKAGE = "com.sun.identity.authentication.internal";
    static SSOProvider grappaProvider = null;
    static SSOProvider dProProvider = null;
    public static Debug debug = Debug.getInstance("amSDK");
    private static SSOTokenManager instance = null;
    static /* synthetic */ Class class$com$iplanet$sso$SSOTokenManager;

    public static SSOTokenManager getInstance() throws SSOException {
        if (instance == null) {
            Class clazz = class$com$iplanet$sso$SSOTokenManager == null ? (class$com$iplanet$sso$SSOTokenManager = SSOTokenManager.class$("com.iplanet.sso.SSOTokenManager")) : class$com$iplanet$sso$SSOTokenManager;
            synchronized (clazz) {
                if (instance == null) {
                    debug.message("Constructing a new instance of SSOTokenManager");
                    instance = new SSOTokenManager();
                }
            }
        }
        return instance;
    }

    private SSOTokenManager() throws SSOException {
        Throwable throwable = null;
        try {
            grappaProvider = new AuthSSOProvider();
            if (debug.messageEnabled()) {
                debug.message("Obtained Grappa SSO Provider");
            }
        }
        catch (Throwable throwable2) {
            debug.error("Unable to obtain Grappa SSO provider", throwable2);
            throwable = throwable2;
        }
        try {
            dProProvider = new SSOProviderImpl();
            if (debug.messageEnabled()) {
                debug.message("Obtained DPRO SSO Provider");
            }
        }
        catch (Throwable throwable3) {
            debug.error("DPRO SSO Provider Exception", throwable3);
            throwable = throwable3;
        }
        if (dProProvider == null && grappaProvider == null) {
            debug.error("Unable to obtain either GRAPPA or DPRO SSO providers");
            I18n i18n = I18n.getInstance("amSDK");
            String string = i18n.getResBundleName();
            if (throwable instanceof ClassNotFoundException) {
                throw new SSOException(string, "sso-noproviderclass", null);
            }
            if (throwable instanceof InstantiationException) {
                throw new SSOException(string, "sso-noproviderinstance", null);
            }
            if (throwable instanceof IllegalAccessException) {
                throw new SSOException(string, "sso-illegalaccess", null);
            }
            throw new SSOException(throwable);
        }
    }

    protected static SSOProvider getProvider(SSOToken sSOToken) throws SSOException {
        if (sSOToken == null) {
            throw new SSOException(SSOProviderBundle.rbName, "ssotokennull", null);
        }
        String string = sSOToken.getClass().getName();
        if (string.startsWith(GRAPPA_PROVIDER_PACKAGE)) {
            if (grappaProvider == null) {
                I18n i18n = I18n.getInstance("amSDK");
                throw new SSOException(i18n.getResBundleName(), "sso-noproviderclass", null);
            }
            return grappaProvider;
        }
        return dProProvider;
    }

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(httpServletRequest);
        }
        return grappaProvider.createSSOToken(httpServletRequest);
    }

    public SSOToken createSSOToken(Principal principal, String string) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(principal, string);
        }
        return grappaProvider.createSSOToken(principal, string);
    }

    public SSOToken createSSOToken(String string) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(string);
        }
        return grappaProvider.createSSOToken(string);
    }

    public SSOToken createSSOToken(String string, String string2) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(string, string2);
        }
        return grappaProvider.createSSOToken(string, string2);
    }

    public boolean isValidToken(SSOToken sSOToken) {
        try {
            return SSOTokenManager.getProvider(sSOToken).isValidToken(sSOToken);
        }
        catch (SSOException sSOException) {
            return false;
        }
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).validateToken(sSOToken);
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).destroyToken(sSOToken);
    }

    public void refreshSession(SSOToken sSOToken) throws SSOException {
        try {
            SSOTokenManager.getProvider(sSOToken).refreshSession(sSOToken);
        }
        catch (Exception exception) {
            debug.error("Error in refreshing the session from session server");
            throw new SSOException(exception);
        }
    }

    public void destroyToken(SSOToken sSOToken, SSOToken sSOToken2) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).destroyToken(sSOToken, sSOToken2);
    }

    public Set getValidSessions(SSOToken sSOToken, String string) throws SSOException {
        return SSOTokenManager.getProvider(sSOToken).getValidSessions(sSOToken, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

