/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RequestSetParser {
    private Document document;
    protected static Debug debug = Debug.getInstance("amComm");

    public RequestSetParser(Document document) {
        this.document = document;
    }

    public RequestSetParser(String string) {
        this.document = XMLUtils.toDOMDocument(string, debug);
    }

    public RequestSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element element = this.document.getDocumentElement();
        RequestSet requestSet = new RequestSet();
        this.setRequestSetAttributes(element, requestSet);
        NodeList nodeList = element.getElementsByTagName("Request");
        if (nodeList == null) {
            return requestSet;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            requestSet.addRequest(this.parseRequestElement((Element)nodeList.item(n2)));
            ++n2;
        }
        return requestSet;
    }

    private void setRequestSetAttributes(Element element, RequestSet requestSet) {
        String string = element.getAttribute("vers");
        if (string != null) {
            requestSet.setRequestSetVersion(string);
        }
        if ((string = element.getAttribute("svcid")) != null) {
            requestSet.setServiceID(string);
        }
        if ((string = element.getAttribute("reqid")) != null) {
            requestSet.setRequestSetID(string);
        }
    }

    private Request parseRequestElement(Element element) {
        Node node;
        Request request = new Request();
        String string = element.getAttribute("dtdid");
        if (string != null) {
            request.setDtdID(string);
        }
        if ((string = element.getAttribute("sid")) != null) {
            request.setSessionID(string);
        }
        if ((node = element.getFirstChild()) != null) {
            request.setContent(node.getNodeValue());
        }
        return request;
    }
}

