/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.JSSDebug;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;
    public static boolean checkSubjectAltName = false;
    public static boolean resolveIPAddress = false;
    public static HashSet sslTrustHosts = new HashSet();
    private static Class[] argTypes = new Class[0];
    private static Object[] params = new Object[0];
    private static final String NEW_METHOD_NAME = "iterator";
    private static final String OLD_METHOD_NAME = "elements";
    private static Method method = null;
    static /* synthetic */ Class class$sun$security$x509$GeneralNames;

    private static Method getMethod() throws NoSuchMethodException {
        if (method == null) {
            String string = NEW_METHOD_NAME;
            Method[] methodArray = (class$sun$security$x509$GeneralNames == null ? (class$sun$security$x509$GeneralNames = ApprovalCallback.class$("sun.security.x509.GeneralNames")) : class$sun$security$x509$GeneralNames).getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(OLD_METHOD_NAME)) {
                    string = OLD_METHOD_NAME;
                    break;
                }
                ++n;
            }
            method = (class$sun$security$x509$GeneralNames == null ? (class$sun$security$x509$GeneralNames = ApprovalCallback.class$("sun.security.x509.GeneralNames")) : class$sun$security$x509$GeneralNames).getMethod(string, argTypes);
        }
        return method;
    }

    private ApprovalCallback() {
    }

    public ApprovalCallback(String string) {
        if (string != null) {
            this.reqHost = string.toLowerCase();
        }
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        Enumeration enumeration = validityStatus.getReasons();
        if (trustAllServerCerts) {
            return true;
        }
        if (this.reqHost == null && !enumeration.hasMoreElements()) {
            return true;
        }
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            Object object;
            SSLCertificateApprovalCallback.ValidityItem validityItem = (SSLCertificateApprovalCallback.ValidityItem)enumeration.nextElement();
            int n = validityItem.getReason();
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("ApprovalCallback: reason " + n);
            }
            if (n != -12276) {
                bl = false;
                continue;
            }
            String string = null;
            try {
                object = x509Certificate.getSubjectDN().getName();
                string = new X500Name((String)object).getCommonName();
            }
            catch (Exception exception) {
                if (JSSDebug.debug.messageEnabled()) {
                    JSSDebug.debug.message("ApprovalCallback:", exception);
                }
                bl = false;
            }
            if (string == null) {
                return false;
            }
            if (!sslTrustHosts.isEmpty()) {
                if (JSSDebug.debug.messageEnabled()) {
                    JSSDebug.debug.message("ApprovalCallback: server cert CN : " + string);
                }
                if (sslTrustHosts.contains(string.toLowerCase())) {
                    return true;
                }
            }
            if (resolveIPAddress) {
                try {
                    bl = InetAddress.getByName(string).getHostAddress().equals(InetAddress.getByName(this.reqHost).getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    if (JSSDebug.debug.messageEnabled()) {
                        JSSDebug.debug.message("ApprovalCallback:", unknownHostException);
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl || !checkSubjectAltName) continue;
            try {
                Object object2;
                object = new X509CertImpl(x509Certificate.getEncoded());
                X509CertInfo x509CertInfo = new X509CertInfo(((X509CertImpl)object).getTBSCertificate());
                CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)certificateExtensions.get("SubjectAlternativeName");
                if (subjectAlternativeNameExtension == null) continue;
                GeneralNames generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                Method method = ApprovalCallback.getMethod();
                Object var14_17 = null;
                if (method.getName().equals(OLD_METHOD_NAME)) {
                    object2 = (Enumeration)method.invoke((Object)generalNames, params);
                    while (!bl && object2.hasMoreElements()) {
                        bl = this.compareHosts((GeneralName)object2.nextElement());
                    }
                    continue;
                }
                object2 = (Iterator)method.invoke((Object)generalNames, params);
                while (!bl && object2.hasNext()) {
                    bl = this.compareHosts((GeneralName)object2.next());
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return bl;
    }

    private boolean compareHosts(GeneralName generalName) {
        block3: {
            try {
                if (generalName.getType() == 2) {
                    String string = generalName.toString();
                    string = string.substring(string.indexOf(58) + 1).trim();
                    return InetAddress.getByName(string).equals(InetAddress.getByName(this.reqHost));
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!JSSDebug.debug.messageEnabled()) break block3;
                JSSDebug.debug.message(unknownHostException.toString());
            }
        }
        return false;
    }

    private static void getSSLTrustHosts(String string) {
        if (JSSDebug.debug.messageEnabled()) {
            JSSDebug.debug.message("ApprovalCallback  SSLTrustHostList = " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        sslTrustHosts.clear();
        while (stringTokenizer.hasMoreTokens()) {
            sslTrustHosts.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = SystemProperties.get("com.iplanet.am.jssproxy.trustAllServerCerts");
        trustAllServerCerts = string != null && string.equalsIgnoreCase("true");
        string = SystemProperties.get("com.iplanet.am.jssproxy.checkSubjectAltName");
        checkSubjectAltName = string != null && string.equalsIgnoreCase("true");
        string = SystemProperties.get("com.iplanet.am.jssproxy.resolveIPAddress");
        resolveIPAddress = string != null && string.equalsIgnoreCase("true");
        string = SystemProperties.get("com.iplanet.am.jssproxy.SSLTrustHostList", null);
        if (string != null) {
            ApprovalCallback.getSSLTrustHosts(string);
        }
        if (JSSDebug.debug.messageEnabled()) {
            JSSDebug.debug.message("ApprovalCallback trustAllServerCerts = " + trustAllServerCerts);
            JSSDebug.debug.message("ApprovalCallback checkSubjectAltName = " + checkSubjectAltName);
            JSSDebug.debug.message("ApprovalCallback resolveIPAddress = " + resolveIPAddress);
            JSSDebug.debug.message("ApprovalCallback  SSLTrustHostList = " + sslTrustHosts.toString());
        }
    }
}

