/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class PLLClient {
    private static final String sccsID = "$Id: PLLClient.java,v 1.21.10.2 2006/04/04 07:41:36 vm113264 Exp $ $Date: 2006/04/04 07:41:36 $  Sun Microsystems, Inc.";
    private static Hashtable notificationHandlers = new Hashtable();
    private static Debug debug = Debug.getInstance("PLLClient");

    public static Vector send(URL uRL, RequestSet requestSet) throws SendRequestException {
        return PLLClient.send(uRL, null, requestSet, null);
    }

    public static Vector send(URL uRL, String string, RequestSet requestSet) throws SendRequestException {
        return PLLClient.send(uRL, string, requestSet, null);
    }

    public static Vector send(URL uRL, RequestSet requestSet, HashMap hashMap) throws SendRequestException {
        return PLLClient.send(uRL, null, requestSet, hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector send(URL uRL, String string, RequestSet requestSet, HashMap hashMap) throws SendRequestException {
        Vector vector;
        BufferedReader bufferedReader;
        block20: {
            HttpURLConnection httpURLConnection = null;
            OutputStream outputStream = null;
            bufferedReader = null;
            try {
                try {
                    int n;
                    Object object;
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setRequestMethod("POST");
                    StringBuffer stringBuffer = null;
                    if (string != null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string);
                    }
                    if (hashMap != null && !hashMap.isEmpty()) {
                        object = hashMap.values().iterator();
                        while (object.hasNext()) {
                            Cookie cookie = (Cookie)object.next();
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                            } else {
                                stringBuffer.append(";");
                            }
                            stringBuffer.append(cookie.getName()).append("=").append(cookie.getValue());
                        }
                    }
                    if (stringBuffer != null) {
                        string = stringBuffer.toString();
                        if (debug.messageEnabled()) {
                            debug.message("sending cookies: " + string);
                        }
                        httpURLConnection.setRequestProperty("Cookie", string);
                    }
                    httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
                    object = requestSet.toXMLString();
                    int n2 = ((String)object).getBytes("UTF-8").length;
                    httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
                    outputStream = httpURLConnection.getOutputStream();
                    outputStream.write(((String)object).getBytes("UTF-8"));
                    outputStream.flush();
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char[] cArray = new char[1024];
                    while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                        stringBuffer2.append(cArray, 0, n);
                    }
                    String string2 = stringBuffer2.toString();
                    Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                    if (hashMap != null) {
                        PLLClient.parseCookies(map, hashMap);
                    }
                    ResponseSet responseSet = ResponseSet.parseXML(string2);
                    vector = responseSet.getResponses();
                    Object var18_19 = null;
                    if (outputStream == null) break block20;
                }
                catch (Exception exception) {
                    debug.message("PLLClient send exception: ", exception);
                    throw new SendRequestException(exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new SendRequestException(iOException.getMessage());
                    }
                }
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new SendRequestException(iOException.getMessage());
                }
            }
            try {}
            catch (IOException iOException) {
                throw new SendRequestException(iOException.getMessage());
            }
            outputStream.close();
        }
        if (bufferedReader == null) return vector;
        try {}
        catch (IOException iOException) {
            throw new SendRequestException(iOException.getMessage());
        }
        bufferedReader.close();
        return vector;
    }

    public static void parseCookies(Map map, HashMap hashMap) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("header in parseCookies(): " + map);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            List list;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string == null || !string.equalsIgnoreCase("Set-cookie") && !string.equalsIgnoreCase("cookie") || (list = (List)entry.getValue()) == null || list.isEmpty()) continue;
            Cookie cookie = null;
            Object var7_7 = null;
            Object var8_8 = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string2;
                int n;
                StringTokenizer stringTokenizer;
                String string3 = (String)iterator2.next();
                if (debug.messageEnabled()) {
                    debug.message("cookie: " + string3);
                }
                if (!(stringTokenizer = new StringTokenizer(string3, ";")).hasMoreTokens() || (n = (string2 = stringTokenizer.nextToken()).indexOf("=")) == -1) continue;
                String string4 = string2.substring(0, n).trim();
                String string5 = string2.substring(n + 1);
                cookie = new Cookie(string4, string5);
                hashMap.put(string4, cookie);
            }
        }
    }

    public static void addNotificationHandler(String string, NotificationHandler notificationHandler) throws AlreadyRegisteredException {
        if (notificationHandlers.containsKey(string)) {
            throw new AlreadyRegisteredException(PLLBundle.getString("alreadyRegistered") + string);
        }
        notificationHandlers.put(string, notificationHandler);
    }

    public static void removeNotificationHandler(String string) {
        notificationHandlers.remove(string);
    }

    public static NotificationHandler getNotificationHandler(String string) {
        return (NotificationHandler)notificationHandlers.get(string);
    }
}

