/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.service.SessionConstraint;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class InternalSession
implements Serializable {
    private static final String sccsID = "@(#)InternalSession.java      1.14  01/04/20 04/20/01  Sun Microsystems, Inc.";
    private String uuid;
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private int sessionState;
    private Properties sessionProperties;
    private boolean willExpireFlag;
    private boolean isEncoded = false;
    private transient boolean isSessionUpgrade = false;
    private static SessionService ss;
    private transient Map internalObjects = new HashMap();
    private long creationTime;
    private long latestAccessTime;
    private transient HttpSession httpSession;
    private boolean isISStored = false;
    Boolean cookieMode = null;
    private String cookieStr;
    private Map restrictedTokensBySid = Collections.synchronizedMap(new HashMap());
    private Map restrictedTokensByRestriction = Collections.synchronizedMap(new HashMap());
    private static String superUserDN;
    private static boolean isEnableHostLookUp;
    private long timedOutAt = 0L;
    private long version = 0L;
    private static long purgeDelay;
    private String sessionHandle = null;
    private static final String LOGIN_URL = "loginURL";
    private static final String SESSION_TIMED_OUT = "SessionTimedOut";
    private static final String HOST = "Host";
    private static final String HOST_NAME = "HostName";
    private static final String AM_MAX_IDLE_TIME = "AMMaxIdleTime";
    protected static final String UNIVERSAL_IDENTIFIER = "sun.am.UniversalIdentifier";
    private static final String LOG_MSG_SESSION_MAX_LIMIT_REACHED = "SESSION_MAX_LIMIT_REACHED";
    private static final String DONOT_TRIM_LIST = "com.sun.identity.session.property.doNotTrimList";
    private static String[] doNotTrimList;
    private static long maxDefaultIdleTime;
    protected static Set protectedProperties;
    private Map sessionEventURLs = Collections.synchronizedMap(new HashMap());

    private static long getPropValue(String string, long l) {
        String string2 = SystemProperties.get(string, String.valueOf(l));
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    InternalSession(SessionID sessionID) {
        this.sessionID = sessionID;
        this.sessionState = 0;
        this.setCreationTime();
        this.setLatestAccessTime();
        this.sessionProperties = new Properties();
        this.willExpireFlag = true;
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public void setType(int n) {
        this.sessionType = n;
        this.updateForFailover();
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String string) {
        this.clientID = string;
        this.updateForFailover();
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public void setClientDomain(String string) {
        this.clientDomain = string;
        this.updateForFailover();
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public void setMaxSessionTime(long l) {
        this.maxSessionTime = l;
        this.updateForFailover();
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long l) {
        int n;
        this.maxIdleTime = l;
        if (this.httpSession != null && this.maxIdleTime > (long)(n = this.httpSession.getMaxInactiveInterval())) {
            this.httpSession.setMaxInactiveInterval((int)this.maxIdleTime * 60);
        }
        this.updateForFailover();
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public void setMaxCachingTime(long l) {
        this.maxCachingTime = l;
        this.updateForFailover();
    }

    public long getIdleTime() {
        long l = System.currentTimeMillis() / 1000L;
        return l - this.latestAccessTime;
    }

    public long getTimeLeft() {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.creationTime + this.maxSessionTime * 60L - l;
        if (l2 >= 0L) {
            return l2;
        }
        return 0L;
    }

    public long getTimeLeftBeforePurge() {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.timedOutAt + purgeDelay * 60L - l;
        return l2 > 0L ? l2 : 0L;
    }

    public boolean isTimedOut() {
        return this.timedOutAt != 0L;
    }

    public int getState() {
        return this.sessionState;
    }

    public Object getObject(String string) {
        return this.internalObjects.get(string);
    }

    public void removeObject(String string) {
        this.internalObjects.remove(string);
    }

    public void setObject(String string, Object object) {
        this.internalObjects.put(string, object);
    }

    public String getProperty(String string) {
        return this.sessionProperties.getProperty(string);
    }

    public Enumeration getPropertyNames() {
        return this.sessionProperties.propertyNames();
    }

    void putExternalProperty(String string, String string2) throws SessionException {
        if (protectedProperties.contains(string)) {
            SessionService.sessionDebug.error("Attempt to set protected property [" + string + "=" + string2 + "]");
            SessionService.getSessionService().logIt(this, "SESSION_PROTECTED_PROPERTY_ERROR");
            throw new SessionException(SessionBundle.getString("protectedProperty") + " " + string);
        }
        this.internalPutProperty(string, string2);
    }

    public void putProperty(String string, String string2) {
        this.internalPutProperty(string, string2);
    }

    protected void internalPutProperty(String string, String string2) {
        if (string.equals(HOST_NAME) || string.equals(HOST)) {
            if (string2 == null || string2.equals("")) {
                return;
            }
            if (isEnableHostLookUp) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    String string3 = inetAddress.getHostName();
                    ((Hashtable)this.sessionProperties).put(HOST_NAME, string3);
                    ((Hashtable)this.sessionProperties).put(HOST, string2);
                }
                catch (UnknownHostException unknownHostException) {
                    SessionService.sessionDebug.error("InternalSession.internalputProperty():Unable to get HostName for:" + string2 + " SessionException: ", unknownHostException);
                }
            } else {
                ((Hashtable)this.sessionProperties).put(HOST_NAME, string2);
                ((Hashtable)this.sessionProperties).put(HOST, string2);
            }
        } else if (string.equals(AM_MAX_IDLE_TIME)) {
            this.setMaxIdleTime(Long.parseLong(string2));
        } else {
            ((Hashtable)this.sessionProperties).put(string, string2);
        }
        if (this.sessionState == 1 && SessionService.isSendPropertyNotification(string)) {
            SessionService.getSessionService().sendEvent(this, 6);
            SessionService.getSessionService().logEvent(this, 6);
        }
        this.updateForFailover();
    }

    public void setIsSessionUpgrade(boolean bl) {
        this.isSessionUpgrade = bl;
    }

    public boolean getIsSessionUpgrade() {
        return this.isSessionUpgrade;
    }

    public void setIsISStored(boolean bl) {
        boolean bl2 = this.isISStored;
        this.isISStored = bl;
        if (this.isISStored && !bl2) {
            this.updateForFailover();
        }
    }

    public boolean getIsISstored() {
        return this.isISStored;
    }

    private boolean shouldIgnoreSessionQuotaChecking(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase(superUserDN) || !this.willExpire()) {
            bl = true;
        } else {
            SessionService.getSessionService();
            boolean bl2 = SessionService.bypassConstratintForToplevelAdmin();
            if (bl2 && SessionService.getSessionService().hasTopLevelAdminRole(this.clientID)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean activate(String string) {
        if (string == null) {
            return false;
        }
        if (SessionService.getActiveSessions() >= SessionService.maxSessions && !string.equalsIgnoreCase(superUserDN)) {
            SessionService.getSessionService().logSystemMessage(LOG_MSG_SESSION_MAX_LIMIT_REACHED, Level.INFO);
            return false;
        }
        this.setUUID();
        if (SessionService.isSessionConstraintEnabled() && !this.shouldIgnoreSessionQuotaChecking(string) && SessionConstraint.checkQuotaAndPerformAction((InternalSession)this)) {
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("Session Quota exhausted!");
            }
            SessionService.getSessionService().logEvent(this, 7);
            return false;
        }
        this.setLatestAccessTime();
        this.setState(1);
        SessionService.getSessionService().logEvent(this, 0);
        SessionService.getSessionService().sendEvent(this, 0);
        SessionService.incrementActiveSessions();
        return true;
    }

    public void setUUID() {
        this.uuid = this.getProperty(UNIVERSAL_IDENTIFIER);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void reactivate() {
        this.setCreationTime();
        this.setLatestAccessTime();
        this.setState(1);
        SessionService.getSessionService().logEvent(this, 4);
        SessionService.getSessionService().sendEvent(this, 4);
    }

    public void setExpire(boolean bl) {
        if (!bl) {
            this.maxSessionTime = 0x222222222222222L;
            this.maxIdleTime = 0x222222222222222L;
            this.maxCachingTime = SessionService.applicationMaxCachingTime;
        }
        this.willExpireFlag = bl;
    }

    private boolean checkInvalidSessionDefaultIdleTime() {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.creationTime + maxDefaultIdleTime * 60L - l;
        return l2 < 0L;
    }

    boolean shouldDestroy() {
        if (!this.willExpireFlag) {
            return false;
        }
        if (!this.isTimedOut()) {
            if (this.sessionState == 0) {
                if (this.checkInvalidSessionDefaultIdleTime()) {
                    this.setState(3);
                    ss.sendEvent(this, 5);
                    return true;
                }
                return false;
            }
            if (this.getTimeLeft() == 0L) {
                this.changeStateAndNotify(2);
                return false;
            }
            if (this.getIdleTime() >= this.maxIdleTime * 60L && this.sessionState != 2) {
                this.changeStateAndNotify(1);
                return false;
            }
            return false;
        }
        if (this.getTimeLeftBeforePurge() <= 0L) {
            SessionService.getSessionService().logEvent(this, 5);
            this.setState(3);
            SessionService.getSessionService().sendEvent(this, 5);
            return true;
        }
        return false;
    }

    private void changeStateAndNotify(int n) {
        SessionService.decrementActiveSessions();
        SessionCount.decrementSessionCount((InternalSession)this);
        SessionService.getSessionService().logEvent(this, n);
        this.setState(0);
        this.timedOutAt = System.currentTimeMillis() / 1000L;
        this.putProperty(SESSION_TIMED_OUT, String.valueOf(this.timedOutAt));
        this.trimSession();
        SessionService.getSessionService().sendEvent(this, n);
    }

    public SessionInfo toSessionInfo() {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.sid = this.sessionID.toString();
        if (this.sessionType == 0) {
            sessionInfo.stype = "user";
        } else if (this.sessionType == 1) {
            sessionInfo.stype = "application";
        }
        sessionInfo.cid = this.clientID;
        sessionInfo.cdomain = this.clientDomain;
        sessionInfo.maxtime = Long.toString(this.maxSessionTime);
        sessionInfo.maxidle = Long.toString(this.maxIdleTime);
        sessionInfo.maxcaching = Long.toString(this.maxCachingTime);
        if (this.willExpireFlag) {
            sessionInfo.timeidle = Long.toString(this.getIdleTime());
            sessionInfo.timeleft = Long.toString(this.getTimeLeft());
        } else {
            sessionInfo.timeidle = Long.toString(0L);
            sessionInfo.timeleft = Long.toString(0x222222222222222L);
        }
        if (this.sessionState == 0) {
            sessionInfo.state = "invalid";
        } else if (this.sessionState == 1) {
            sessionInfo.state = "valid";
        } else if (this.sessionState == 2) {
            sessionInfo.state = "inactive";
        } else if (this.sessionState == 3) {
            sessionInfo.state = "destroyed";
        }
        sessionInfo.properties = (Properties)((Hashtable)this.sessionProperties).clone();
        return sessionInfo;
    }

    void setLatestAccessTime() {
        this.latestAccessTime = System.currentTimeMillis() / 1000L;
        this.updateForFailover();
    }

    void setState(int n) {
        this.sessionState = n;
        this.updateForFailover();
    }

    Map getSessionEventURLs() {
        return this.sessionEventURLs;
    }

    boolean hasEventURLs() {
        return this.sessionEventURLs.size() > 0;
    }

    boolean willExpire() {
        return this.willExpireFlag;
    }

    public void setCreationTime() {
        this.creationTime = this.httpSession != null ? this.httpSession.getCreationTime() / 1000L : System.currentTimeMillis() / 1000L;
    }

    void addRestrictedToken(SessionID sessionID, TokenRestriction tokenRestriction) {
        this.restrictedTokensBySid.put(sessionID, tokenRestriction);
        this.restrictedTokensByRestriction.put(tokenRestriction, sessionID);
        this.updateForFailover();
    }

    TokenRestriction getRestrictionForToken(SessionID sessionID) {
        return (TokenRestriction)this.restrictedTokensBySid.get(sessionID);
    }

    SessionID getRestrictedTokenForRestriction(TokenRestriction tokenRestriction) {
        return (SessionID)this.restrictedTokensByRestriction.get(tokenRestriction);
    }

    Object[] getRestrictedTokens() {
        return this.restrictedTokensBySid.keySet().toArray();
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string) {
        return this.encodeURL(httpServletResponse, string, Session.getCookieName());
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string, String string2) {
        return this.encodeURL(string, (short)0, true, string2);
    }

    private String encodeURL(String string, boolean bl) {
        return this.encodeURL(string, (short)0, bl, Session.getCookieName());
    }

    public String encodeURL(String string, short s, boolean bl) {
        return this.encodeURL(string, s, bl, Session.getCookieName());
    }

    public String encodeURL(String string, short s, boolean bl, String string2) {
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Session: url: " + string);
        }
        String string3 = string;
        if (string != null && string.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null && this.cookieStr.length() != 0 && Session.foundCookieName(this.cookieStr, string2)) {
                string3 = SessionEncodeURL.buildCookieString(string, this.cookieStr, s, bl);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(string2, this.sessionID.toString());
                string3 = SessionEncodeURL.encodeURL(this.cookieStr, string, s, bl);
            }
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Returning encoded Session: url: " + string3);
        }
        return string3;
    }

    private String getClientType() {
        String string = null;
        string = this.getProperty("clientType");
        return string;
    }

    private boolean getCookieSupport() {
        boolean bl = false;
        try {
            if (this.sessionID.getCookieMode() != null) {
                bl = this.sessionID.getCookieMode();
            } else if (this.cookieMode != null) {
                bl = this.cookieMode;
            }
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Error getting cookieSupport value: ", exception);
            bl = true;
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("InternalSession: getCookieSupport: " + bl);
        }
        return bl;
    }

    void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    HttpSession getHttpSession() {
        return this.httpSession;
    }

    protected void updateForFailover() {
        if (SessionService.getSessionService().isSessionFailoverEnabled() && this.isISStored) {
            if (this.sessionState != 1) {
                SessionService.getSessionService().deleteFromRepository(this.sessionID);
                this.isISStored = false;
            } else {
                SessionService.getSessionService().saveForFailover(this);
            }
        }
    }

    private void trimSession() {
        String string;
        this.clientDomain = null;
        this.cookieStr = null;
        Properties properties = new Properties();
        String string2 = this.getProperty(LOGIN_URL);
        String string3 = this.getProperty(SESSION_TIMED_OUT);
        if (string2 != null) {
            ((Hashtable)properties).put(LOGIN_URL, string2);
        }
        if (string3 != null) {
            ((Hashtable)properties).put(SESSION_TIMED_OUT, string3);
        }
        if ((string = this.getProperty("AMCtxId")) != null) {
            ((Hashtable)properties).put("AMCtxId", string);
        }
        if (doNotTrimList != null && doNotTrimList.length > 0) {
            String string4 = "";
            String string5 = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < doNotTrimList.length) {
                string4 = doNotTrimList[n];
                string5 = this.getProperty(string4);
                if (string5 != null) {
                    stringBuffer.append(string4).append(", ");
                    ((Hashtable)properties).put(string4, string5);
                }
                ++n;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("trimSession does not trim " + stringBuffer.toString());
            }
        }
        this.sessionProperties = properties;
    }

    public void setCookieMode(Boolean bl) {
        SessionService.sessionDebug.message("CookieMode is:" + bl);
        if (bl != null) {
            this.cookieMode = bl;
        }
    }

    void setSessionHandle(String string) {
        this.sessionHandle = string;
        this.putProperty("SessionHandle", string);
        this.updateForFailover();
    }

    String getSessionHandle() {
        return this.sessionHandle;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public long getVersion() {
        return this.version;
    }

    public long getExpirationTime() {
        long l = Math.max(0L, this.getMaxIdleTime() * 60L - this.getIdleTime());
        if (l == 0L) {
            l = this.getTimeLeftBeforePurge();
        }
        return System.currentTimeMillis() / 1000L + Math.min(this.getTimeLeft(), l);
    }

    static {
        StringTokenizer stringTokenizer;
        ss = SessionService.getSessionService();
        isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));
        doNotTrimList = null;
        maxDefaultIdleTime = InternalSession.getPropValue("com.iplanet.am.session.invalidsessionmaxtime", 3L);
        purgeDelay = InternalSession.getPropValue("com.iplanet.am.session.purgedelay", 120L);
        superUserDN = SystemProperties.get("com.sun.identity.authentication.super.user");
        String string = SystemProperties.get(DONOT_TRIM_LIST, "");
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Initialize doNotTrimList " + string);
        }
        if (!string.equals("")) {
            stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            doNotTrimList = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                InternalSession.doNotTrimList[n] = stringTokenizer.nextToken().trim();
                ++n;
            }
        }
        protectedProperties = new HashSet();
        protectedProperties.add(HOST);
        protectedProperties.add(HOST_NAME);
        protectedProperties.add("AuthLevel");
        protectedProperties.add("AuthType");
        protectedProperties.add("Principal");
        protectedProperties.add("UserId");
        protectedProperties.add("UserToken");
        protectedProperties.add("Organization");
        protectedProperties.add("cookieSupport");
        protectedProperties.add("authInstant");
        protectedProperties.add("Principals");
        protectedProperties.add(LOGIN_URL);
        protectedProperties.add("Role");
        protectedProperties.add("Service");
        protectedProperties.add(SESSION_TIMED_OUT);
        protectedProperties.add("SessionHandle");
        protectedProperties.add("TokenRestriction");
        protectedProperties.add(AM_MAX_IDLE_TIME);
        protectedProperties.add("AMCtxId");
        protectedProperties.add(UNIVERSAL_IDENTIFIER);
        string = SystemProperties.get("com.iplanet.am.session.protectedPropertiesList", "");
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                protectedProperties.add(string2);
                if (!SessionService.sessionDebug.messageEnabled()) continue;
                SessionService.sessionDebug.message("Added protected property [" + string2 + "]");
            }
        }
    }
}

