/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SessionID
implements Serializable {
    private static final String sccsID = "$Id: SessionID.java,v 1.44 2005/06/24 16:54:46 vs125812 Exp $ $Date: 2005/06/24 16:54:46 $  Sun Microsystems, Inc.";
    private String encryptedString = "";
    private boolean isParsed = false;
    private String sessionServerProtocol = "";
    private String sessionServer = "";
    private String sessionServerPort = "";
    protected String sessionDomain = "";
    private String sessionServerID = "";
    private String tail = null;
    private String extensionPart = null;
    private Map extensions = new HashMap();
    private static String cookieName = null;
    private static Debug debug;
    private Boolean cookieMode = null;
    public static final String PRIMARY_ID = "S1";
    public static final String STORAGE_KEY = "SK";
    public static final String SITE_ID = "SI";

    public SessionID(HttpServletRequest httpServletRequest) {
        String string = null;
        if (cookieName != null) {
            string = CookieUtils.getCookieValueFromReq(httpServletRequest, cookieName);
            if (string == null) {
                String string2 = SessionEncodeURL.getSidFromURL(httpServletRequest);
                if (string2 != null) {
                    this.encryptedString = string2;
                }
                this.cookieMode = Boolean.FALSE;
            } else {
                this.cookieMode = Boolean.TRUE;
                this.encryptedString = string;
            }
        }
    }

    public SessionID(String string) {
        this.encryptedString = string;
    }

    public boolean isNull() {
        return SessionID.isNull(this.encryptedString);
    }

    private static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public String getSessionServerProtocol() {
        if (SessionID.isNull(this.sessionServerProtocol)) {
            this.parseSessionString();
        }
        return this.sessionServerProtocol;
    }

    public String getSessionServerPort() {
        if (SessionID.isNull(this.sessionServerPort)) {
            this.parseSessionString();
        }
        return this.sessionServerPort;
    }

    public String getSessionServer() {
        if (SessionID.isNull(this.sessionServer)) {
            this.parseSessionString();
        }
        return this.sessionServer;
    }

    public String getSessionDomain() {
        return this.sessionDomain;
    }

    public String getSessionServerID() {
        if (SessionID.isNull(this.sessionServerID)) {
            this.parseSessionString();
        }
        return this.sessionServerID;
    }

    public String toString() {
        return this.encryptedString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SessionID)) {
            return false;
        }
        SessionID sessionID = (SessionID)object;
        return this.encryptedString.equals(sessionID.encryptedString);
    }

    public int hashCode() {
        return this.encryptedString.hashCode();
    }

    private void parseSessionString() {
        if (this.isParsed) {
            return;
        }
        if (this.isNull()) {
            throw new IllegalArgumentException("sid value is null or empty");
        }
        try {
            Object object;
            int n = this.encryptedString.lastIndexOf("@");
            if (n == -1) {
                this.isParsed = true;
                return;
            }
            String string = this.encryptedString.substring(n + 1);
            int n2 = string.indexOf("#");
            this.tail = string.substring(n2 + 1);
            if (n2 != -1) {
                this.extensionPart = string.substring(0, n2);
                object = new DataInputStream(new ByteArrayInputStream(Base64.decode(this.extensionPart)));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (true) {
                    String string2;
                    try {
                        string2 = ((DataInputStream)object).readUTF();
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    String string3 = ((DataInputStream)object).readUTF();
                    hashMap.put(string2, string3);
                }
                this.extensions = hashMap;
            }
            if ((object = (String)this.extensions.get(SITE_ID)) != null) {
                this.setServerID((String)object);
            }
        }
        catch (Exception exception) {
            debug.error("Invalid sessionid format", exception);
            throw new IllegalArgumentException("Invalid sessionid format" + exception);
        }
        this.isParsed = true;
    }

    protected void setServerID(String string) {
        try {
            URL uRL = new URL(WebtopNaming.getServerFromID(string));
            this.sessionServerID = string;
            this.sessionServerProtocol = uRL.getProtocol();
            this.sessionServer = uRL.getHost();
            this.sessionServerPort = String.valueOf(uRL.getPort());
        }
        catch (Exception exception) {
            debug.error("Could not get server info from sessionid", exception);
            throw new IllegalArgumentException("Invalid server id in session id " + exception);
        }
    }

    public String getTail() {
        this.parseSessionString();
        return this.tail;
    }

    public Boolean getCookieMode() {
        return this.cookieMode;
    }

    public String getExtension(String string) {
        this.parseSessionString();
        return (String)this.extensions.get(string);
    }

    public static String makeSessionID(String string, Map map, String string2) throws SessionException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            if (map != null || string2 != null) {
                stringBuffer.append("@");
            }
            if (map != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    dataOutputStream.writeUTF((String)entry.getKey());
                    dataOutputStream.writeUTF((String)entry.getValue());
                }
                dataOutputStream.close();
                stringBuffer.append(Base64.encode(byteArrayOutputStream.toByteArray()));
                stringBuffer.append("#");
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public static String makeRelatedSessionID(String string, SessionID sessionID) throws SessionException {
        sessionID.parseSessionString();
        return SessionID.makeSessionID(string, sessionID.extensions, sessionID.tail);
    }

    static {
        cookieName = System.getProperty("com.iplanet.am.cookie.name");
        if (cookieName == null) {
            cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        debug = Debug.getInstance("amSession");
    }
}

