/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class SystemProperties {
    private static Properties props;
    private static long lastModified;
    private static String initError;
    public static String iasGXId;
    private static final String SERVER_NAME_PROPERTY = "server.name";
    private static final String CONFIG_NAME_PROPERTY = "amconfig";
    private static final String AMCONFIG_FILE_NAME = "AMConfig";
    public static final String CONFIG_PATH = "com.iplanet.services.configpath";
    public static final String CONFIG_FILE_NAME = "serverconfig.xml";

    public static String get(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = props.getProperty(string);
        }
        return string2;
    }

    public static String get(String string, String string2) {
        String string3 = SystemProperties.get(string);
        return string3 == null ? string2 : string3;
    }

    public static Properties getAll() {
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(props);
        Iterator iterator = ((Hashtable)System.getProperties()).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string == null || string.length() <= 0) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public static Properties getPlatform() {
        return SystemProperties.getAll();
    }

    public static synchronized void initializeProperties(String string) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(props);
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            ((Hashtable)properties).put(string2, resourceBundle.getString(string2));
        }
        props = properties;
        lastModified = System.currentTimeMillis();
    }

    public static synchronized void initializeProperties(Properties properties) {
        Properties properties2 = new Properties();
        ((Hashtable)properties2).putAll(props);
        ((Hashtable)properties2).putAll(properties);
        props = properties2;
        lastModified = System.currentTimeMillis();
    }

    public static synchronized void initializeProperties(String string, String string2) {
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(props);
        ((Hashtable)properties).put(string, string2);
        props = properties;
        lastModified = System.currentTimeMillis();
    }

    public static long lastModified() {
        return lastModified;
    }

    public static String getInitializationError() {
        return initError;
    }

    static {
        iasGXId = null;
        try {
            props = new Properties();
            String string = System.getProperty(SERVER_NAME_PROPERTY);
            String string2 = System.getProperty(CONFIG_NAME_PROPERTY, AMCONFIG_FILE_NAME);
            String string3 = null;
            if (string != null) {
                string = string.replace('.', '_');
                string3 = string2 + "-" + string;
            } else {
                string3 = string2;
            }
            SystemProperties.initializeProperties(string3);
        }
        catch (MissingResourceException missingResourceException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            missingResourceException.printStackTrace(new PrintStream(byteArrayOutputStream));
            initError = byteArrayOutputStream.toString();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

