/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.util.IDebug;
import com.sun.identity.util.IDebugProvider;
import com.sun.identity.util.impl.DebugProviderImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class Debug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    public static final String STR_OFF = "off";
    public static final String STR_ERROR = "error";
    public static final String STR_WARNING = "warning";
    public static final String STR_MESSAGE = "message";
    public static final String STR_ON = "on";
    private static Map debugMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static IDebugProvider debugProvider;
    private static final String CONFIG_DEBUG_PROVIDER = "com.sun.identity.util.debug.provider";
    private IDebug debugServiceInstance;

    public static synchronized Debug getInstance(String string) {
        Debug debug = (Debug)Debug.getDebugMap().get(string);
        if (debug == null) {
            debug = new Debug(Debug.getDebugProvider().getInstance(string));
            Debug.getDebugMap().put(string, debug);
        }
        return debug;
    }

    public static Collection getInstances() {
        return Debug.getDebugMap().values();
    }

    private static Map getDebugMap() {
        return debugMap;
    }

    private static void setDebugProvider(IDebugProvider iDebugProvider) {
        debugProvider = iDebugProvider;
    }

    private static IDebugProvider getDebugProvider() {
        return debugProvider;
    }

    private static synchronized void initialize() {
        if (!serviceInitialized) {
            String string = SystemProperties.get(CONFIG_DEBUG_PROVIDER);
            IDebugProvider iDebugProvider = null;
            boolean bl = false;
            if (string != null && string.trim().length() > 0) {
                try {
                    iDebugProvider = (IDebugProvider)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
                catch (InstantiationException instantiationException) {
                    bl = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    bl = true;
                }
                catch (ClassCastException classCastException) {
                    bl = true;
                }
            }
            if (iDebugProvider == null) {
                if (bl) {
                    ResourceBundle resourceBundle = Locale.getInstallResourceBundle("amUtilMsgs");
                    System.err.println(resourceBundle.getString("com.iplanet.services.debug.invlaidprovider"));
                }
                iDebugProvider = new DebugProviderImpl();
            }
            Debug.setDebugProvider(iDebugProvider);
            serviceInitialized = true;
        }
    }

    public String getName() {
        return this.getDebugServiceInstance().getName();
    }

    public boolean messageEnabled() {
        return this.getDebugServiceInstance().messageEnabled();
    }

    public boolean warningEnabled() {
        return this.getDebugServiceInstance().warningEnabled();
    }

    public boolean errorEnabled() {
        return this.getDebugServiceInstance().errorEnabled();
    }

    public int getState() {
        return this.getDebugServiceInstance().getState();
    }

    public void message(String string) {
        this.getDebugServiceInstance().message(string, null);
    }

    public void message(String string, Throwable throwable) {
        this.getDebugServiceInstance().message(string, throwable);
    }

    public void warning(String string) {
        this.getDebugServiceInstance().warning(string, null);
    }

    public void warning(String string, Throwable throwable) {
        this.getDebugServiceInstance().warning(string, throwable);
    }

    public void error(String string) {
        this.getDebugServiceInstance().error(string, null);
    }

    public void error(String string, Throwable throwable) {
        this.getDebugServiceInstance().error(string, throwable);
    }

    public void setDebug(int n) {
        this.getDebugServiceInstance().setDebug(n);
    }

    public void setDebug(String string) {
        this.getDebugServiceInstance().setDebug(string);
    }

    public void destroy() {
    }

    private void setDebugServiceInstance(IDebug iDebug) {
        this.debugServiceInstance = iDebug;
    }

    private IDebug getDebugServiceInstance() {
        return this.debugServiceInstance;
    }

    private Debug(IDebug iDebug) {
        this.setDebugServiceInstance(iDebug);
    }

    static {
        Debug.initialize();
    }
}

